//////////////////////////////
// Implementation IFSHook class
// FileName: IFSHook.cpp
// Copyright (c) 1997 by Somnath Kundu.  All Rights Reserved.

#define WANTVXDWRAPS
#include <vxdlib.h>
#pragma  hdrstop
#include "fcrypt.h"
#include "ifshook.h"

#pragma VxD_LOCKED_DATA_SEG
#pragma VxD_LOCKED_CODE_SEG

int IFSHook::CallPrevHook (IFSHookParams* pHookParams)
{
    int retVal = (**PrevHookFunc)( pHookParams->FSDFnAddr,
                   pHookParams->FunctionNum, pHookParams->Drive,
                   pHookParams->ResourceFlags, pHookParams->CodePage,
                   pHookParams->pir);
                                    
    return retVal;
}
  
BOOL IFSHook::HookIFS (pIFSFileHookFunc HookFunc)
{
    if (PrevHookFunc)
       return FALSE;

    if (HookFunc)
      CurHookFunc = HookFunc;

    pFileHandle = (FileHandleInfo *)_HeapAllocate( sizeof(FileHandleInfo)*50, HEAPZEROINIT);
    assert( pFileHandle);
    MaxFileHandle = 50;
    FileHandleNo = 0;

    if (CurHookFunc)
       PrevHookFunc = (ppIFSFileHookFunc)CVXDCALL2( IFSMgr_InstallFileSystemApiHook, CurHookFunc);

    return (PrevHookFunc != 0);
}

BOOL IFSHook::UnhookIFS ()
{
    if (PrevHookFunc
        && -1 != CVXDCALL2( IFSMgr_RemoveFileSystemApiHook, CurHookFunc))
    {
       PrevHookFunc = NULL;
       assert( FileHandleNo == 0);
       _HeapFree( pFileHandle, 0);
       return TRUE;
    }
    return FALSE;
}

int IFSHookParams::BCSPath (char* pPathBuff, int len, PathElement* pp_elements)
{
    int rlen;

    if ((BYTE)Drive != 0xff)            // not an UNC path
    {
       pPathBuff[0] = Drive + 'A' - 1;
       pPathBuff[1] = ':';
       rlen = 2;
    }
    else
       rlen = GetBCSFName( pPathBuff, len);
    len = CVXDCALL5( UniToBCSPath, (BYTE*)pPathBuff+rlen, pp_elements, len, CodePage);
    pPathBuff[len+rlen] = '\0';
    return (len+rlen);
}   

int IFSHookParams::GetBCSFName (char* pFNameBuff, int Len)
{
    DWORD ulen = 0;
    while (pir->ir_uFName[ulen])
        ++ulen;
    Len = CVXDCALL6( UniToBCS,(BYTE*)pFNameBuff,pir->ir_uFName,ulen*2,Len,CodePage);
    pFNameBuff[Len] = '\0';
    return Len;
}

int MoveFile (CSTR pExistingFile, CSTR pNewFile)
{
    int attr,f1,f2,n,ret=FALSE;
    STR buf;

   if ((attr = GetFileAttr( pExistingFile)) == -1)
      return ret;

   buf = (STR)CVXDCALL2( IFSMgr_GetHeap, PAGESIZE*2);
   assert( buf);
   if (!buf)
     return ret;

   if ((f1 = open( pExistingFile, ACCESS_READONLY | SHARE_DENYWRITE, ACTION_OPENEXISTING)) == -1)
      goto no_buf;

   if ((f2 = open( pNewFile, ACCESS_WRITEONLY, ACTION_CREATENEW)) == -1)
       goto close1;

   ret = TRUE;
   while ((n = read( f1, buf, PAGESIZE*2)) > 0)
       if (write( f2, buf, n) != n)
          ret = FALSE;

   close( f2);
   if (ret)                          // successfully copied
      SetFileAttr( pNewFile, attr);  // set original file attributes
   else                              // there is some error
      remove( pNewFile);             // delete it

 close1:
   close( f1);
   if (ret)                          // if successfully copied
   {
      SetFileAttr( pExistingFile, FILE_ATTRIBUTE_ARCHIVE);
      remove( pExistingFile);        // remove the original one
   }

 no_buf:
   CVXDCALL2( IFSMgr_RetHeap, buf);

   return ret;
}
