#========================================================================
# Master MAKEFILE for MSVC++ 4.0/4.2/5.0 to build any VxD using VxD95Lib
# Copyright (c) 1997 by Somnath Kundu.
#========================================================================

!IF "$(NAME)" == ""
!  ERROR No VxD name is specified
!ENDIF

!IF "$(CFG)" == ""
CFG=Debug
!  MESSAGE No configuration specified.  Defaulting to $(NAME) - Debug.
!ENDIF 

!IF "$(CFG)" != "Debug" && "$(CFG)" != "Release" 
!  MESSAGE Invalid configuration "$(CFG)" specified.
!  MESSAGE You can specify a configuration when running NMAKE on this makefile
!  MESSAGE by defining the macro CFG on the command line.  For example:
!  MESSAGE 
!  MESSAGE NMAKE /f "test.mak" CFG="Debug"
!  MESSAGE 
!  MESSAGE Possible choices for configuration are:
!  MESSAGE 
!  MESSAGE "Debug" 
!  MESSAGE "Release"
!  MESSAGE 
!  ERROR An invalid configuration is specified.
!ENDIF

#=====================================================================
# Set the path variable
#=====================================================================
PATH = $(DDKROOT)\$(SUBSYSTEM)\bin;$(DDKROOT)\bin;$(SDKROOT)\bin;$(COMPILERROOT)\bin;$(PATH)

#=====================================================================
# Set the file version for linker
#=====================================================================
!IF "$(FMAJORVER)" != "" && "$(FMINORVER)" != ""
VERSION = $(FMAJORVER).$(FMINORVER)
!ELSE
VERSION = 1.0
!ENDIF

#=====================================================================
# Get the object file names from their respective source files
#=====================================================================
!IF "$(AFILES)" != ""
OBJA = $(AFILES:.asm=.obj)
SBRA = $(AFILES:.asm=.sbr)
!ENDIF

!IF "$(CFILES)" != ""
OBJC = $(CFILES:.c=.obj)
SBRC = $(CFILES:.c=.sbr)
!ENDIF

!IF "$(CPPFILES)" != ""
OBJCPP = $(CPPFILES:.cpp=.obj)
SBRCPP = $(CPPFILES:.cpp=.sbr)
!ENDIF

OBJS = $(OBJA) $(OBJC) $(OBJCPP)
SBRS = $(SBRA) $(SBRC) $(SBRCPP)

!IF "$(OBJS)" == ""
!ERROR No source file is specified
!ENDIF

!IF "$(INCFILES)" != ""
INCFILES = $(INCFILES:%= )
!ENDIF

!IF "$(HFILES)" != ""
HFILES = $(HFILES:%= )
!ENDIF

!IF "$(HPPFILES)" != ""
HPPFILES = $(HPPFILES:%= )
!ENDIF

HEADERFILES = $(HFILES) $(HPPFILES)

#=====================================================================
# Set assembler,compiler and linker flags and output directory
#=====================================================================
!IF "$(CFG)" == "Debug"
OUTDIR = .\Debug
OBJAT = $(OBJA:%= .\Debug\)
OBJCT = $(OBJC:%= .\Debug\)
OBJCPPT = $(OBJCPP:%= .\Debug\)
OBJST = $(OBJS:%= .\Debug\)
SBRST = $(SBRS:%= .\Debug\)
AFLAGS = /nologo /c /coff /DBLD_COFF /DIS_32 /W3 /Zi /Cx /Zp1 /DMASM6 \
          $(CONDITIONALS)  /DDEBLEVEL=1 /DDEBUG /Fl"$(OUTDIR)/" \
          /Fo"$(OUTDIR)/" /FR"$(OUTDIR)/"
CFLAGS = /nologo /c /Od /Zi /Zp1 /Zl /Yd /W3 /FAs /YX"$(OUTDIR)\$(NAME).PCH" \
          /DDEBUG /DWIN32 /Fa"$(OUTDIR)/" /Fo"$(OUTDIR)/" /Fd"$(OUTDIR)/" \
          /Fp"$(OUTDIR)\$(NAME).PCH" /FR"$(OUTDIR)/" $(CONDITIONALS)
LFLAGS = /MACHINE:i386 /PDB:"$(OUTDIR)\$(NAME).PDB" /nologo /DEBUG \
         /DEBUGTYPE:BOTH /VERSION:$(VERSION)
!ELSEIF  "$(CFG)" == "Release"
OUTDIR = .\Release
OBJAT = $(OBJA:%= .\Release\)
OBJCT = $(OBJC:%= .\Release\)
OBJCPPT = $(OBJCPP:%= .\Release\)
OBJST = $(OBJS:%= .\Release\)
SBRST = $(SBRS:%= .\Release\)
AFLAGS = /nologo /c /coff /DBLD_COFF /DIS_32 /W3 /Cx /DMASM6 /DNDEBUG \
         /Fo"$(OUTDIR)/" /Fl"$(OUTDIR)/" /FR"$(OUTDIR)/" $(CONDITIONALS)
CFLAGS = /nologo /c /O2 /G5 /DIS_32 /Zp1 /Zl /DWIN32 /DNDEBUG \
         /FAs  /Fa"$(OUTDIR)/" /Fo"$(OUTDIR)/" /FR"$(OUTDIR)/" $(CONDITIONALS)
LFLAGS = /MACHINE:i386 /PDB:NONE /nologo /VERSION:$(VERSION) /RELEASE
!ENDIF

#=====================================================================
# Set path for linker, must be from DDK/MSVC++
#=====================================================================
!IF "$(LINKERPATH)" != ""
LINK = $(LINKERPATH)\LINK
!ELSE
LINK = LINK             # from default compiler's path
!ENDIF

BSC32 = bscmake.exe     # from default path
BSCFLAGS = /nologo /o"$(OUTDIR)/$(NAME).bsc"   

#=====================================================================
# Set path for 16-bit resource compiler from SDK
#=====================================================================
RC = $(SDKROOT)\binw16\rc.exe
!IF EXIST($(RC))
RES = $(OUTDIR)\$(NAME).res
ADDRES = 1
!ENDIF

#=====================================================================
# Set path for default SDK's symbol file processor
#=====================================================================
!IF "$(SYM)" == ""
SYM = mapsym -nologo -o $(OUTDIR)\$(NAME).sym
!ENDIF

#=====================================================================
# Set target, create output directory and set environment for building VxD
#=====================================================================
TARGET_VXD = $(OUTDIR)\$(NAME).VxD
TARGET_BRC = $(OUTDIR)\$(NAME).bsc

all: direxist setenv $(TARGET_VXD) $(TARGET_BRC)

direxist:
      @if not exist $(OUTDIR)\nul  md $(OUTDIR)

setenv:
!IF "$(APPROOT)" == ""
      @SET INCLUDE=$(DDKROOT)\$(SUBSYSTEM)\inc;$(DDKROOT)\inc32;$(SDKROOT)\include;$(INCLUDE);$(DDKROOT)\inc16;$(SDKROOT)\inc16
      @SET LIB=$(DDKROOT)\lib;$(SDKROOT)\lib;$(LIB)
!ELSE
      @SET INCLUDE=$(DDKROOT)\$(SUBSYSTEM)\inc;$(DDKROOT)\inc32;$(APPROOT)\inc32;$(SDKROOT)\include;$(INCLUDE);$(DDKROOT)\inc16;$(SDKROOT)\inc16
      @SET LIB=$(DDKROOT)\lib;$(APPROOT)\lib;$(SDKROOT)\lib;$(LIB)
!ENDIF

#=====================================================================
# Generate browser information
#=====================================================================
$(TARGET_BRC): "$(OUTDIR)" $(SBRST)
    $(BSC32) @<<
       $(BSCFLAGS) $(SBRST)
<<

#=====================================================================
# Build target VxD using inline LNK and DEF file for linker
#=====================================================================
$(TARGET_VXD): $(OBJST) $(RES)
        $(LINK) @<<$(NAME).crf /def:<<$(NAME).def
$(LFLAGS) /VXD
/out:$(TARGET_VXD)
/map:$(OUTDIR)\$(NAME).map
/merge:.CRT=_IDATA /merge:.xdata=_LDATA
/IGNORE:4078,4069
/NODEFAULTLIB
$(OBJST)
vxd95lib.clb vxdwraps.clb $(LIBRARY)
<<
VXD $(NAME) $(TYPE)
!IF "$(DESCRIPTION)" != ""
DESCRIPTION '$(DESCRIPTION)'
!ELSE
DESCRIPTION '$(NAME) Device'
!ENDIF
SEGMENTS
     _LPTEXT    CLASS 'LCODE'   PRELOAD NONDISCARDABLE
     _LTEXT     CLASS 'LCODE'   PRELOAD NONDISCARDABLE
     _LDATA     CLASS 'LCODE'   PRELOAD NONDISCARDABLE
     _TEXT      CLASS 'LCODE'   PRELOAD NONDISCARDABLE
     _DATA      CLASS 'LCODE'   PRELOAD NONDISCARDABLE
     CONST      CLASS 'LCODE'   PRELOAD NONDISCARDABLE
     _TLS       CLASS 'LCODE'   PRELOAD NONDISCARDABLE
     _BSS       CLASS 'LCODE'   PRELOAD NONDISCARDABLE
     _BSSEND    CLASS 'LCODE'   PRELOAD NONDISCARDABLE
     _XDATA     CLASS 'LCODE'   PRELOAD NONDISCARDABLE
     _CRT       CLASS 'ICODE'   DISCARDABLE
     INITCODE   CLASS 'ICODE'   DISCARDABLE
     INITEND    CLASS 'ICODE'   DISCARDABLE
     _ITEXT     CLASS 'ICODE'   DISCARDABLE
     _IDATA     CLASS 'ICODE'   DISCARDABLE
     _PTEXT     CLASS 'PCODE'   NONDISCARDABLE
     _PDATA     CLASS 'PDATA'   NONDISCARDABLE SHARED
     _STEXT     CLASS 'SCODE'   RESIDENT
     _SDATA     CLASS 'SCODE'   RESIDENT
     _DBOSTART  CLASS 'DBOCODE' PRELOAD NONDISCARDABLE CONFORMING
     _DBOCODE   CLASS 'DBOCODE' PRELOAD NONDISCARDABLE CONFORMING
     _DBODATA   CLASS 'DBOCODE' PRELOAD NONDISCARDABLE CONFORMING
     _16ICODE   CLASS '16ICODE' PRELOAD DISCARDABLE
     _RCODE     CLASS 'RCODE'
!IF DEFINED(MESSAGE_SEG)
     _LMSGTABLE  CLASS 'MCODE'   PRELOAD NONDISCARDABLE IOPL
     _LMSGDATA   CLASS 'MCODE'   PRELOAD NONDISCARDABLE IOPL
     _IMSGTABLE  CLASS 'MCODE'   PRELOAD DISCARDABLE IOPL
     _IMSGDATA   CLASS 'MCODE'   PRELOAD DISCARDABLE IOPL
     _PMSGTABLE  CLASS 'MCODE'   NONDISCARDABLE IOPL
     _PMSGDATA   CLASS 'MCODE'   NONDISCARDABLE IOPL
!ENDIF

EXPORTS
    _thisDDB @1 DATA
<<
!IF DEFINED(ADDRES)
      adrc2vxd.exe $@ $(OUTDIR)\$(NAME).res
!ENDIF
      -@del $(OUTDIR)\*.exp
      -@del $(OUTDIR)\*.lib

#=====================================================================
# For debug build generate/load debug information
#=====================================================================
!IF "$(CFG)" == "Debug"
!IF "$(NMSYM)" != ""
      $(NMSYM) /translate:source,package,always /load:symbols /source:. $(OUTDIR)\$(NAME).vxd
!ELSEIF "$(MSYM)" != "" 
      $(MSYM) $(OUTDIR)\$(NAME).map
!ELSE
      $(SYM) $(OUTDIR)\$(NAME).map
!ENDIF
!ENDIF

#=====================================================================
# Compile ASM, C and CPP files
#=====================================================================
!IF DEFINED(OBJA)
$(OBJAT): $(@F:.obj=.asm) $(INCFILES)
   $(AS) $(AFLAGS) $(@F:.obj=.asm)
!ENDIF

!IF DEFINED(OBJC)
$(OBJCT): $(@F:.obj=.c) $(HEADERFILES)
   $(CC) $(CFLAGS) $(@F:.obj=.c)
!ENDIF

!IF DEFINED(OBJCPP)
$(OBJCPPT): $(@F:.obj=.cpp) $(HEADERFILES)
   $(CC) $(CFLAGS) $(@F:.obj=.cpp)
!ENDIF

#=====================================================================
# Generate inline resource file and compile it
#=====================================================================
!IF DEFINED(RES)
$(RES): 
   $(RC) -r -fo$@ <<$(NAME).rc
#include <winver.h>

#define  VER_FILETYPE             VFT_VXD

!IF "$(DEVICE_ID)" == ""
#define VER_FILESUBTYPE           0     
!ELSE
#define VER_FILESUBTYPE           $(DEVICE_ID)
!ENDIF

!IF "$(FMAJORVER)" != "" && "$(FMINORVER)" != ""
#define VER_FILEVERSION           $(FMAJORVER),$(FMINORVER),$(FBUILDVER)
#define VER_FILEVERSION_STR       "$(FMAJORVER).$(FMINORVER).$(FBUILDVER)"
!ELSE
#define VER_FILEVERSION           1,00,00
#define VER_FILEVERSION_STR       "1.00.000"
!ENDIF


!IF "$(PMAJORVER)" != "" && "$(PMINORVER)" != ""
#define VER_PRODUCTVERSION        $(PMAJORVER),$(PMINORVER),$(PBUILDVER)
#define VER_PRODUCTVERSION_STR    "$(PMAJORVER).$(PMINORVER).$(PBUILDVER)"
!ELSE
#define VER_PRODUCTVERSION        1,00,00
#define VER_PRODUCTVERSION_STR    "1.00.000"
!ENDIF

!IF "$(CFG)" == "Debug"
#define VER_DEBUG                 VS_FF_DEBUG
!ELSE
#define VER_DEBUG                 0
!ENDIF

#define VER_PRIVATEBUILD          VS_FF_PRIVATEBUILD
#define VER_PRERELEASE            VS_FF_PRERELEASE

#ifndef VER_FILEFLAGS
#define VER_FILEFLAGS             (VER_PRIVATEBUILD|VER_PRERELEASE|VER_DEBUG)
#endif

#ifndef VER_FILEOS
#define VER_FILEOS                VOS_DOS_WINDOWS32
#endif

#ifndef VER_FILEFLAGSMASK
#define VER_FILEFLAGSMASK         VS_FFI_FILEFLAGSMASK
#endif

#define VER_COMPANYNAME_STR       "$(COMPANY)"

!IF "$(PRODUCTNAME)" != ""
#define VER_PRODUCTNAME_STR       "$(PRODUCTNAME)"
!ELSE
#define VER_PRODUCTNAME_STR       "$(NAME).VxD"
!ENDIF

!IF "$(DESCRIPTION)" != ""
#define VER_FILEDESCRIPTION_STR   "$(DESCRIPTION)"
!ELSE
#define VER_FILEDESCRIPTION_STR   "$(NAME).VxD"
!ENDIF

!IF "$(INTERNALNAME)" == ""
#define VER_INTERNALNAME_STR      "$(NAME)"
!ELSE
#define VER_INTERNALNAME_STR      "$(INTERNALNAME)"
!ENDIF

!IF "$(ORIGINALNAME)" == ""
#define VER_ORIGINALFILENAME_STR  "$(NAME).VXD"
!ELSE
#define VER_ORIGINALFILENAME_STR  "$(ORIGINALNAME)"
!ENDIF

#define VER_LEGALCOPYRIGHT_YEARS  "$(YEAR)"
#define VER_LEGALCOPYRIGHT_STR    "Copyright \251 $(COPYRIGHT), " VER_LEGALCOPYRIGHT_YEARS

#ifdef RC_INVOKED

VS_VERSION_INFO VERSIONINFO 
FILEVERSION    VER_FILEVERSION
PRODUCTVERSION VER_PRODUCTVERSION
FILEFLAGSMASK  VER_FILEFLAGSMASK
FILEFLAGS      VER_FILEFLAGS
FILEOS         VER_FILEOS
FILETYPE       VER_FILETYPE
FILESUBTYPE    VER_FILESUBTYPE
BEGIN
    BLOCK "StringFileInfo"
    BEGIN
        BLOCK "040904E4"
        BEGIN 
            VALUE "CompanyName"     ,VER_COMPANYNAME_STR
            VALUE "FileDescription" ,VER_FILEDESCRIPTION_STR
            VALUE "FileVersion"     ,VER_FILEVERSION_STR
            VALUE "InternalName"    ,VER_INTERNALNAME_STR
            VALUE "OriginalFilename",VER_ORIGINALFILENAME_STR
            VALUE "LegalCopyright"  ,VER_LEGALCOPYRIGHT_STR
            VALUE "ProductName"     ,VER_PRODUCTNAME_STR
            VALUE "ProductVersion"  ,VER_PRODUCTVERSION_STR
        END 

#ifdef INTL
        BLOCK "040904E4"
        BEGIN 
            VALUE "CompanyName"     ,VER_COMPANYNAME_STR
            VALUE "FileDescription" ,VER_FILEDESCRIPTION_STR
            VALUE "FileVersion"     ,VER_FILEVERSION_STR
            VALUE "InternalName"    ,VER_INTERNALNAME_STR
            VALUE "LegalCopyright"  ,VER_LEGALCOPYRIGHT_STR
            VALUE "ProductName"     ,VER_PRODUCTNAME_STR
            VALUE "ProductVersion"  ,VER_PRODUCTVERSION_STR
        END 
#endif
    END 
 
    BLOCK "VarFileInfo" 
    BEGIN 
        /* the following line should be extended for localized versions */
        VALUE "Translation", 0x0409, 0x04E4
    END 
END 

#endif
<<keep
!ENDIF

#=====================================================================
# Clean up output directory
#=====================================================================
clean:
    -@del *.obj
    -@del $(OUTDIR)\*.vxd
    -@del $(OUTDIR)\*.exe
    -@del $(OUTDIR)\*.map
    -@del $(OUTDIR)\*.sym
    -@del $(OUTDIR)\*.res
    -@del $(OUTDIR)\*.pdb
    -@del $(OUTDIR)\*.asm
    -@del $(OUTDIR)\*.lst
    -@del $(OUTDIR)\*.nms
    -@rd  $(OUTDIR)
