/********************************************************************
* Master header file to be included by VxD generated by VxDWriter.  *
*                                                                   *
* Copyright (c) 1997 by Somnath Kundu.  All Rights Reserved.        *
*********************************************************************/

#ifndef _VXDLIB_H
#define _VXDLIB_H

#ifdef __cplusplus              
extern "C" {
#endif

#pragma pack(1)

// Include commonly used DDK header files
#include <basedef.h>
#include <vmm.h>
#include <debug.h>
#include <vwin32.h>
#include <vmmreg.h>
#include <ifs.h>
#include <shell.h>
#include <vtd.h>
#include <dosmgr.h>
#include <winerror.h>
#ifdef WANTVXDWRAPS
#include <vxdwraps.h>
#endif

// Following are include files for the specific type of drivers.
// This listing is not complete and many files come with DDK only
// as INC file. So, please add the necessary files in your VxD or
// here as needed.

#if defined(SUBSYS_BLOCK)
#include <aep.h>
#include <blockdev.h>
#include <config.h>
#include <dcb.h>
#include <ddb.h>
#include <drp.h>
#include <dvt.h>
#include <ida.h>
#include <ilb.h>
#include <ior.h>
#include <iop.h>
#include <irs.h>
#include <isp.h>
#include <ivt.h>
#include <sgd.h>
#include <vrp.h>
#elif defined(SUBSYS_COMM)         // Include file for COMM drivers
#include <vcomm.h>
#endif                          

#define VXDSRVORD(Service)   GetVxDServiceOrdinal(Service)

#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;            
#define _SIZE_T_DEFINED
#endif

typedef char* STR;
typedef const STR CSTR;

typedef void *HWND;

typedef void __cdecl FNVOID (void);
typedef FNVOID *PFNVOID,**PPFNVOID;

typedef struct VxD_Desc_Block VMMDDB;

#define ASIZE(Array)  (sizeof Array / sizeof Array[0])

//===================================================================
// Register structures for using in vxd service and interrupt
// calling macros.
//===================================================================
typedef struct _DWORDREGS
{
   DWORD edi,esi,ebp,res,ebx,edx,ecx,eax,eflags;
   WORD  es,ds,fs,gs;

} DWORDREGS;

typedef struct _WORDREGS
{
   WORD  di,res1,si,res2,bp,res3,res4,res5,bx,res6,dx,res7,cx,res8,ax,res9,flags,res10;
   WORD  es,ds,fs,gs;

} WORDREGS;

typedef struct _BYTEREGS
{
   BYTE res[4*4];
   BYTE bl,bh,res11,res12,dl,dh,res21,res22,cl,ch,res31,res32,al,ah,res41,res42;

} BYTEREGS;

typedef union _REGS
{
   DWORDREGS dr;        // DWORD registers
   WORDREGS  wr;        // WORD registers
   BYTEREGS  br;        // BYTE registers

} REGS, *PREGS;

#define DECLARE_REGS   REGS  _regs
#define DECLARE_PREGS  PREGS _pregs

#define EAX _regs.dr.eax
#define EBX _regs.dr.ebx
#define ECX _regs.dr.ecx
#define EDX _regs.dr.edx

#define _EAX _pregs->dr.eax
#define _EBX _pregs->dr.ebx
#define _ECX _pregs->dr.ecx
#define _EDX _pregs->dr.edx

#define ESI _regs.dr.esi
#define EDI _regs.dr.edi
#define EBP _regs.dr.ebp

#define _ESI _pregs->dr.esi
#define _EDI _pregs->dr.edi
#define _EBP _pregs->dr.ebp

#define EFLAGS _regs.dr.eflags
#define _EFLAGS _pregs->dr.eflags

#define DS _regs.dr.ds
#define ES _regs.dr.es
#define GS _regs.dr.fs
#define FS _regs.dr.gs

#define AX _regs.wr.ax
#define BX _regs.wr.bx
#define CX _regs.wr.cx
#define DX _regs.wr.dx

#define _AX _pregs->wr.ax
#define _BX _pregs->wr.bx
#define _CX _pregs->wr.cx
#define _DX _pregs->wr.dx

#define SI _regs.wr.si
#define DI _regs.wr.di
#define BP _regs.wr.bp

#define _SI _pregs->wr.si
#define _DI _pregs->wr.di
#define _BP _pregs->wr.bp

#define FLAGS _regs.wr.flags
#define _FLAGS _pregs->wr.flags

#define AL _regs.br.al
#define AH _regs.br.ah
#define BL _regs.br.bl
#define BH _regs.br.bh
#define CL _regs.br.cl
#define CH _regs.br.ch
#define DL _regs.br.dl
#define DH _regs.br.dh

#define _AL _pregs->br.al
#define _AH _pregs->br.ah
#define _BL _pregs->br.bl
#define _BH _pregs->br.bh
#define _CL _pregs->br.cl
#define _CH _pregs->br.ch
#define _DL _pregs->br.dl
#define _DH _pregs->br.dh

#define   EFLAG_CF    0x0001      // Carry flag
#define   EFLAG_PF    0x0004      // Parity flag
#define   EFLAG_AF    0x0010      // Adjust flag  
#define   EFLAG_ZF    0x0040      // Zero flag
#define   EFLAG_SF    0x0080      // Sign flag
#define   EFLAG_DF    0x0400      // Direction flag
#define   EFLAG_OF    0x0800      // Overflow flag

//===================================================================
// Macro to access ring3 client register structure
//===================================================================

#define R3_AL pRegs->CBRS.Client_AL
#define R3_BL pRegs->CBRS.Client_BL
#define R3_CL pRegs->CBRS.Client_CL
#define R3_DL pRegs->CBRS.Client_DL
#define R3_AH pRegs->CBRS.Client_AH
#define R3_BH pRegs->CBRS.Client_BH
#define R3_CH pRegs->CBRS.Client_CH
#define R3_DH pRegs->CBRS.Client_DH

#define R3_AX pRegs->CWRS.Client_AX
#define R3_BX pRegs->CWRS.Client_BX
#define R3_CX pRegs->CWRS.Client_CX
#define R3_DX pRegs->CWRS.Client_DX
#define R3_SI pRegs->CWRS.Client_SI
#define R3_DI pRegs->CWRS.Client_DI
#define R3_BP pRegs->CWRS.Client_BP
#define R3_SP pRegs->CWRS.Client_SP
#define R3_IP pRegs->CWRS.Client_IP
#define R3_Flags pRegs->CWRS.Client_Flags
#define R3_AltIP pRegs->CWRS.Client_Alt_IP
#define R3_AltSP pRegs->CWRS.Client_Alt_SP

#define R3_EAX pRegs->CRS.Client_EAX
#define R3_EBX pRegs->CRS.Client_EBX
#define R3_ECX pRegs->CRS.Client_ECX
#define R3_EDX pRegs->CRS.Client_EDX
#define R3_ESI pRegs->CRS.Client_ESI
#define R3_EDI pRegs->CRS.Client_EDI
#define R3_EBP pRegs->CRS.Client_EBP
#define R3_ESP pRegs->CRS.Client_ESP
#define R3_EIP pRegs->CRS.Client_EIP
#define R3_EFlags pRegs->CRS.Client_EFlags
#define R3_CS pRegs->CRS.Client_CS
#define R3_DS pRegs->CRS.Client_DS
#define R3_ES pRegs->CRS.Client_ES
#define R3_FS pRegs->CRS.Client_FS
#define R3_GS pRegs->CRS.Client_GS
#define R3_SS pRegs->CRS.Client_SS
#define R3_AltESP pRegs->CRS.Client_Alt_ESP
#define R3_AltEIP pRegs->CRS.Client_Alt_EIP
#define R3_AltEFlags pRegs->CRS.Client_Alt_EFlags
#define R3_AltCS pRegs->CRS.Client_Alt_CS
#define R3_AltDS pRegs->CRS.Client_Alt_DS
#define R3_AltES pRegs->CRS.Client_Alt_ES
#define R3_AltFS pRegs->CRS.Client_Alt_FS
#define R3_AltGS pRegs->CRS.Client_Alt_GS
#define R3_AltSS pRegs->CRS.Client_Alt_SS


//===================================================================
// Macro to support naked callback function
//===================================================================
// Since MSVC++ inline assembler does not permit the use of __LOCAL_SIZE
// symbol in expression, the following prolog/epilog has become slightly
// more lengthy and complicated.

#define NAKED  __declspec ( naked )

#define ENTER                            \
          DECLARE_PREGS; { __asm {       \
          __asm  push ebp                \
          __asm  mov  ebp, esp           \
          __asm  pushfd                  \
          __asm  sub  esp, __LOCAL_SIZE  \
          __asm  lea  esp, [esp-8]       \
          __asm  push dword ptr [ebp-4]  \
          __asm  pop dword ptr [esp]     \
          __asm  pushad                  \
          __asm  mov  [_pregs], esp      \
          __asm  mov  eax, [ebp]         \
          __asm  mov  [esp+8],  eax      }}


#define LEAVE { __asm {                   \
          __asm  push dword ptr [esp+32]  \
          __asm  pop  dword ptr [ebp]     \
          __asm  popad                    \
          __asm  popfd                    \
          __asm  add esp, __LOCAL_SIZE    \
          __asm  lea esp, [esp+8]         \
          __asm  popfd                    }}


#define RETURN  {     \
          LEAVE       \
          __asm   ret }


#define CALL_SERVICE(Service) { __asm { \
          __asm   mov [esp+36], ebp     \
          __asm   popad                 \
          __asm   popfd                 \
          __asm   call Service          \
          __asm   pushfd                \
          __asm   pushad                \
          __asm   mov ebp, [esp+36]     }}


#define JUMP_SERVICE(Service) {   \
          LEAVE                   \
          __asm  jmp Service      }

//===================================================================
// Macros for hooking and unhooking VxD services 
//===================================================================

#define HOOK_DEVICE_SERVICE(Service,pHookFunc,pppSrvFunc)  \
      Hook_Device_Service( VXDSRVORD(Service),(PFNVOID)pHookFunc,(PPFNVOID)pppSrvFunc)

#define UNHOOK_DEVICE_SERVICE(Service,ppSrvFunc)  \
      Unhook_Device_Service( VXDSRVORD(Service),(PFNVOID)ppSrvFunc)

//===================================================================
// Macros for calling VxD services and interrupts
//===================================================================

#define RVXDCALL(Service)   RVxDCall( VXDSRVORD( Service), &_regs, &_regs)

#define CVXDCALL(Service,Parameters)  CVxDCall( VXDSRVORD( Service),Parameters)

#define CVXDCALL1(Service)  CVxDCall( VXDSRVORD( Service))
#define CVXDCALL2(Service,p1)  CVxDCall( VXDSRVORD( Service),p1)
#define CVXDCALL3(Service,p1,p2)  CVxDCall( VXDSRVORD( Service),p1,p2)
#define CVXDCALL4(Service,p1,p2,p3)  CVxDCall( VXDSRVORD( Service),p1,p2,p3)
#define CVXDCALL5(Service,p1,p2,p3,p4)  CVxDCall( VXDSRVORD( Service),p1,p2,p3,p4)
#define CVXDCALL6(Service,p1,p2,p3,p4,p5)  CVxDCall( VXDSRVORD( Service),p1,p2,p3,p4,p5)
#define CVXDCALL7(Service,p1,p2,p3,p4,p5,p6)  CVxDCall( VXDSRVORD( Service),p1,p2,p3,p4,p5,p6)
#define CVXDCALL8(Service,p1,p2,p3,p4,p5,p6,p7)  CVxDCall( VXDSRVORD( Service),p1,p2,p3,p4,p5,p6,p7)
#define CVXDCALL9(Service,p1,p2,p3,p4,p5,p6,p7,p8)  CVxDCall( VXDSRVORD( Service),p1,p2,p3,p4,p5,p6,p7,p8)
#define CVXDCALL10(Service,p1,p2,p3,p4,p5,p6,p7,p8,p9)  CVxDCall( VXDSRVORD( Service),p1,p2,p3,p4,p5,p6,p7,p8,p9)
#define CVXDCALL11(Service,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10)  CVxDCall( VXDSRVORD( Service),p1,p2,p3,p4,p5,p6,p7,p8,p9,p10)
#define CVXDCALL12(Service,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11)  CVxDCall( VXDSRVORD( Service),p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11)

#define INTV86(Interruptno) IntV86( Interruptno, &_regs, &_regs)
#define INTVXD(Interruptno) IntVxD( Interruptno, &_regs, &_regs)
#define INTPM16(Interruptno) IntPM16( Interruptno, &_regs, &_regs)
#define INTPM32(Interruptno) IntPM32( Interruptno, &_regs, &_regs)

typedef struct _TIME
{
    BYTE  Sec;          // Second (0-59)
    BYTE  Min;          // Minute (0-59)
    BYTE  Hr;           // Hour (0-23)
    BYTE  wDay;         // Day of the week (0-Sun, 1-Mon, . . .)
    BYTE  mDay;         // Day of the month (1-31)
    BYTE  Month;        // Month (0-11)
    WORD  Year;         // Year (1997,. . .)

} TIME, *PTIME;

#define SEEK_SET   0
#define SEEK_CUR   1
#define SEEK_END   2

#define CONTEXT_GLOBAL          0           ; open file in global context
#define CONTEXT_CURRENT         0x80000000  ; open file in current thread context

#define MB_MODELESS 0x80000000

#undef assert
#if defined(DEBUG) || defined(_DEBUG)
#   define assert(x) ((void)((x) || (DoAssert(#x,__FILE__,__LINE__),1)))
#else
#   define assert(ignore) ((void)0)
#endif
void __cdecl DoAssert (char *msg, char *file, DWORD line);

typedef int __stdcall CONTROL_PROC (DECLARE_PREGS);
typedef int __stdcall API_PROC (CLIENT_STRUCT *pClientReg);

int __cdecl CVxDCall (int VxDSrvOrd, ...);
int __stdcall RVxDCall (int VxDSrvOrd, REGS *inregs, REGS *outregs);
int __stdcall IntV86 (int interruptno, REGS *inregs, REGS *outregs);
int __stdcall IntVxD (int interruptno, REGS *inregs, REGS *outregs);
int __stdcall IntPM16 (int interruptno, REGS *inregs, REGS *outregs);
int __stdcall IntPM32 (int interruptno, REGS *inregs, REGS *outregs);

BOOL __stdcall Hook_Device_Service (int ServiceOrd, PFNVOID pHoohFunc, PFNVOID *ppSrvFunc);
BOOL __stdcall Unhook_Device_Service (int ServiceOrd, PFNVOID pSrvFunc);

void* __stdcall malloc (size_t nbytes);
void __stdcall  free (void *memblock);
void* __stdcall realloc (void *memblock, size_t size);
void* __stdcall calloc (size_t num, size_t size);
#define _msize(Ptr) ((*((DWORD *)Ptr-1) & 0x00ffffff) * 8 - 4)

TIME* __stdcall GetTime (void);
char* __stdcall GetTimeStr (void);

int __stdcall  MessageBox (HWND hWnd, char *pMsg, char *pTitle, DWORD dwMBFlag);
int __stdcall BlueMsgBox (char *pMsg, char *pTitle, DWORD dwMBFlag);
void __stdcall WarBell (void);
UINT __stdcall WinExec (char *pCmdLind, UINT uCmdShow);
int __stdcall GetCurAppName (DWORD ir_pid, char *pAppName);

int __cdecl sprintf (char* format, ...);

size_t __cdecl strlen (const char *str);
char* __cdecl strchr (const char *str, int ch);
char* __cdecl strrchr (const char *str, int ch);

int __cdecl strnicmp (const char *str1, const char *str2, size_t len);
int __cdecl stricmp (const char *str1, const char *str2);

int __cdecl strncmp (const char *str1, const char *str2, size_t len);
int __cdecl strcmp (const char *str1, const char *str2);

char* __cdecl strcpy (char *dest, const char *src);
char* __cdecl strncpy (char *dest, const char *src, size_t len);

char* __cdecl strcat (char *dest, const char *src);
char* __cdecl strncat (char *dest, const char *src, size_t count);

char* __cdecl strstr (const char *str1, const char * str2);

void* __cdecl memcpy (void *dest, const void *src, size_t len);
void* __cdecl memmove (void *dest, const void *src, size_t len);
int __cdecl memcmp (const void *dest, const void *src, size_t len);
void* __cdecl memchr (const void *dest, int ch, size_t len);
void* __cdecl memset (void *dest, int c, size_t count);

WORD __cdecl rand ();
void __cdecl srand (DWORD seed);
void __cdecl randomize ();

int __cdecl GetFileAttr (const char *pFileName);
int __cdecl SetFileAttr (const char *pFileName, WORD attr);

int __cdecl remove (const char *pFileName);
int __cdecl rename (const char *pSrcFile, const char *pDesFile);

int __cdecl mkdir (const char* pDirPath);
int __cdecl rmdir (const char* pDirPath);

int __cdecl creat (const char *pFileName, int mode);
int __cdecl open (const char *pFileName, int mode, int oflag);
int __cdecl close (int filehandle);

int __cdecl read (int filehandle, void *pBuff, DWORD len);
int __cdecl write (int filehandle, const void *pBuff, DWORD len);
long __cdecl lseek(int handle, long offset, int fromwhere);
DWORD __cdecl _fsize (int handle);

#ifdef IFS_INC          // If IFS.H is included
DWORD __stdcall FindFirstFile (const char* pFileName, _WIN32_FIND_DATA* pFindData);
DWORD __stdcall FindNextFile (DWORD hFindFirst, _WIN32_FIND_DATA* pFindData);
DWORD __stdcall FindCloseFile (DWORD hFindFirst);
#endif

typedef int (__cdecl * new_handler) (size_t size);  
new_handler __cdecl set_new_handler (new_handler handler);

#pragma pack()

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus      // Include C++ specific declarations

PVOID operator new (size_t size);             // allocate memory from private heap
PVOID operator new (size_t size, PVOID ptr);  // equv. to realloc

PVOID operator new (size_t size, DWORD dwHeapType); // allocate memory from system heap
PVOID operator new (size_t size, DWORD dwHeapType, PVOID ptr); // equv. to realloc

void operator delete (PVOID ptr);   // free heap allocated by both type of memory

#endif   // __cplusplus

#endif
