// Copyright (c) 1996-1998 Ulrich von Zadow

#ifndef INCL_BMPDEC
#define INCL_BMPDEC

#ifndef INCL_PICDEC
#include "picdec.h"
#endif

#ifndef INCL_WINDEFS
#include "windefs.h"
#endif

//! Windows bitmap file decoder. Decodes 1, 4, 8, and 24 bpp
//! bitmap files (compressed and uncompressed). Returns an 8
//! or 32 bpp bitmap.
class CBmpDecoder : public CPicDecoder
{

DECLARE_DYNAMIC (CBmpDecoder);

public:
  //! Creates a decoder
  CBmpDecoder
    ();

  //! Destroys a decoder
  virtual ~CBmpDecoder
    ();

protected:
  //! Does the actual decoding of bitmap data.
  virtual void DoDecode
    ();

private:

  // Decodes the bitmap file & info headers
  WINBITMAPINFOHEADER * getInfoHeader
    ( BYTE ** ppBits
    );

  // Decodes a 2-color bitmap. Ignores the palette & just uses
  // black & white as 'colors'
  void decode1bpp
    ( BYTE * pBits
    );

  // Decodes an uncompressed 16-color-bitmap.
  void decode4bpp
    ( BYTE * pBits
    );

  // Decodes an uncompressed 256-color-bitmap.
  void decode8bpp
    ( BYTE * pBits
    );

  // Decodes a compressed 16-color-bitmap.
  void decodeRLE4
    ( BYTE * pBits
    );

  // Decodes a compressed 256-color-bitmap.
  void decodeRLE8
    ( BYTE * pBits
    );

  // Decodes true-color bitmap
  void decode24bpp
    ( BYTE * pBits
    );

  // Decodes true-color bitmap
  void CBmpDecoder::decode32bpp
    ( BYTE * pBits
    );

  // Decodes two 4-bit pixels using a palette & puts them in pDest
  // and pDest+4.
  void decode2Nibbles
    ( BYTE * pDest,
      BYTE SrcByte,
      RGBAPIXEL * pPal
    );

  // Makes a private copy of the palette in the file and sets the
  // alpha channel.
  void readPalette
    ( WINBITMAPINFOHEADER * pBMI  // Pointer to bitmapinfoheader in file.
    );

};

#endif
