/*
/--------------------------------------------------------------------
|
|      DIBGRIT.H          Bitmap Graphic item class
|
|      A bitmap on a canvas.
|
|      Copyright (c) 1996-1998 Ulrich von Zadow
|
\--------------------------------------------------------------------
*/

#ifndef INCL_DIBGRIT
#define INCL_DIBGRIT

#include "bitmap.h"
#include "gritem.h"

class CDIBGrItem : public CGrItem
{

DECLARE_DYNAMIC (CDIBGrItem);

public:
  CDIBGrItem
    ( int x,            // Position on the canvas
      int y,
      int w,            // Width
      int h,            // Height
      int z,            // Position in z-Order
      BYTE Opacity,     // Opacity of the object. 255 is completely
                        // opaque, 0 is completely transparent.
      CBmp * pBmp       // The bitmap.
    );

  ~CDIBGrItem
    ();

  virtual void Draw
    ( CBmp * pCanvas,
      CRect * pUpdateRect
    );
    // Responsible for drawing the object on the canvas.

  CBmp * GetBmp
    ()
  {
    return m_pBmp;
  }

private:
  void drawClippedNoScale
    ( CBmp * pCanvas,
      CRect * pRect
    );
    // Draws the object. pRect must have been clipped already.
    // Assumes that no scaling is nessesary.

  void drawAlphaLine
    ( BYTE * pDest,
      BYTE * pSrc,
      CRect * pRect
    );

  void drawFadeLine
    ( BYTE * pDest,
      BYTE * pSrc,
      CRect * pRect
    );

  void drawClipped
    ( CBmp * pCanvas,
      CRect * pRect
    );

  void drawScaleLine
    ( BYTE * pDest,
      BYTE * pSrc,
      BOOL bAlpha,
      CRect * pRect
    );

  // Member variables.

  CBmp * m_pBmp;
  BYTE ** m_pLineArray;
};

#endif
