// MainDlg.h : header file
//
//     Copyright (c) 1996-1998 Ulrich von Zadow
//

// CDibtestDlg dialog

#include "winbmp.h"
#include "mtdibwnd.h"
#include "picdec.h"
#include "grarray.h"

class CDibtestDlg : public CDialog
{
// Construction
public:
  CDibtestDlg
    ( char * pszDirName
    );

  ~CDibtestDlg
    ();

  void DoWork
    ();

// Dialog Data
  //{{AFX_DATA(CDibtestDlg)
  enum { IDD = IDD_DIBTEST_DIALOG };
          // NOTE: the ClassWizard will add data members here
  //}}AFX_DATA

  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CDibtestDlg)
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);        // DDX/DDV support
  //}}AFX_VIRTUAL

// Implementation
protected:
  HICON m_hIcon;

  // Generated message map functions
  //{{AFX_MSG(CDibtestDlg)
  virtual BOOL OnInitDialog();
  afx_msg void OnPaint();
  afx_msg HCURSOR OnQueryDragIcon();
  afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()

private:
  void loadDir
    ( CPicDecoder * pDecoder,
      CGrItemArray * pDIBArray,
      const char * pszDirName
    );
    // Tries to load all files in a directory and its
    // subdirectories.

  void loadFile
    ( CPicDecoder * pDecoder,
      CGrItemArray * pDIBArray,
      const char * pszFName
    );
    // Tries to load a file. Does error checking.

  void loadRes
    ( CPicDecoder * pDecoder,
      CGrItemArray * pDIBArray,
      int ResourceID
    );
    // Tries to load a resource. Does error checking.

  void createBkGrnd
    ( CPicDecoder * pDecoder
    );

  void setAlphaChannel
    ( CGrItemArray * pDIBArray
    );

  void update
    ( CGrItemArray * pDIBArray,
      CRect * pOldRect,
      CRect * pNewRect
    );

  void testResource
    ();

  CWinBmp * m_pBmp;
  CWinBmp * m_pBigBmp;

  CMTDIBWnd * m_pDIBWnd;

  CString m_sDirName;

  int m_x;
  int m_y;

  CRITICAL_SECTION m_Critical;
};
