/*
/--------------------------------------------------------------------
|
|      TESTDEC.CPP            Decoder test program.
|
|      This is just a simple program which loads a picture file and
|      saves it in uncompressed tga format.
|
|      Copyright (c) 1996 Ulrich von Zadow
|
\--------------------------------------------------------------------
*/

#include "stdpch.h"
#include "anydec.h"
#include "anybmp.h"
#include "bitmap.h"
#include "tga.h"

void usage
    ()
{
  fprintf (stderr, "Paintlib test program.\n");
  fprintf (stderr, "\n");
  fprintf (stderr, "Usage:\n");
  fprintf (stderr, "  testdec <infile> <outfile>,\n");
  fprintf (stderr, "\n");
  fprintf (stderr, "where <infile> is a file to be decoded and <outfile>.\n");
  fprintf (stderr, "is the destination file. The file is written in TGA\n");
  fprintf (stderr, "format.\n");
}

void writeWord
    ( BYTE * pWord,
      WORD Data
    )
    // TGA is LSB-First.
{
  pWord[0] = Data % 256;
  pWord[1] = Data >> 8;
}

void writeTGAHeader
    ( FILE * pFile,
      CBmp * pBmp
    )
{
  BYTE pBuf [18];
  pBuf[0] = 0;    // No image ID
  pBuf[1] = 0;    // No color map
  pBuf[2] = 2;    // Uncompressed true-color image

  // Write unused color map info
  writeWord (pBuf+3, 0);
  writeWord (pBuf+5, 0);
  pBuf[7] = 0;

  // Image specification
  writeWord (pBuf+8, 0);
  writeWord (pBuf+10, 0);
  writeWord (pBuf+12, pBmp->GetWidth());
  writeWord (pBuf+14, pBmp->GetHeight());
  pBuf[16] = 32;
  pBuf[17] = 32;

  fwrite (pBuf, 1, 18, pFile);
}

void writeTGABody
    ( FILE * pFile,
      CBmp * pBmp
    )
{
  BYTE ** pLineArray = pBmp->GetLineArray();
  int     BytesPerLine = pBmp->GetWidth()*4;
  int     y;

  for (y = 0; y<pBmp->GetHeight(); y++)
  {
    fwrite (pLineArray[y], 1, BytesPerLine, pFile);
  }
}


void saveTGA
    ( char * pszFName,
      CBmp * pBmp
    )
{
  FILE     * pFile;

  pFile = fopen (pszFName, "wb");
  if ((int)pFile == -1)
  {
    TRACE ("Couldn't open output file %s", pszFName);
    return;
  }

  writeTGAHeader (pFile, pBmp);
  writeTGABody (pFile, pBmp);

  fclose (pFile);
}

int main (int argc, char ** argv)
{
  CAnyPicDecoder Decoder;

  CAnyBmp Bmp;

  if (argc != 3)
  {
    usage();
    return -1;
  }
  Decoder.SetTraceConfig (2, NULL);
  Decoder.MakeBmpFromFile (argv[1], &Bmp);

  saveTGA (argv[2], &Bmp);

  return 0;
}
