/*
/--------------------------------------------------------------------
|
|      DATASRC.CPP        Data Source Base Class
|
|      This is a base class for a source of picture data.
|      It defines methods to open, close, and read from data sources.
|
|      Restriction: All picture data is placed into the internal
|      buffer on open so the ReadXxx-routines can be inline'd in this
|      class. The effect is that anything other than memory-mapped
|      files or files already in memory need to be read into memory
|      _before_ decoding can start.
|
|      Copyright (c) 1996-1998 Ulrich von Zadow
|
\--------------------------------------------------------------------
*/

#include "stdpch.h"

#include "datasrc.h"

#ifdef _WINDOWS
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
#endif

IMPLEMENT_DYNAMIC (CDataSource, CObject);


CDataSource::CDataSource
    ()
{
  m_pszName = NULL;
  m_pData = NULL;
  m_pStartData = NULL;
}


CDataSource::~CDataSource
    ()
{
  if (m_pData)
    Close();
}


void CDataSource::Open
    ( const char * pszName,
      BYTE * pData,
      int    FileSize
    )
{
  // Data source may not be open already!
  ASSERT (!m_pData);

  m_pszName = new char [strlen (pszName)+1];
  strcpy (m_pszName, pszName);
  m_pStartData = pData;
  m_pData = pData;
  m_FileSize = FileSize;
}


void CDataSource::Close
    ()
{
  delete m_pszName;
  m_pszName = NULL;
  m_pData = NULL;
  m_pStartData = NULL;
}


char * CDataSource::GetName
    ()
{
  return m_pszName;
}
