//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "NewDemoForm.h"
//---------------------------------------------------------------------------
#pragma link "hyperlnk"
#pragma link "Sampreg"
#pragma resource "*.dfm"
TDemoForm *DemoForm;
//---------------------------------------------------------------------------
__fastcall TDemoForm::TDemoForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
struct IndexColorItem
{
	Graphics::TColor Color;
    char *Name;
};

const int NumOfColors=16;

IndexColorItem IndexColors[NumOfColors]=
{
  	{clBlack,"clBlack"      },
  	{clMaroon,"clMaroin"    },
  	{clGreen,"clGreen"      },
  	{clOlive,"clOlive"      },
  	{clNavy,"clNavy"        },
  	{clPurple,"clPurple"    },
  	{clTeal,"clTeal"        },
  	{clSilver,"clSilver"    },
  	{clGray,"clGray"        },
  	{clRed,"clRed"          },
  	{clLime,"clLime"        },
  	{clYellow,"clYellow"    },
  	{clBlue,"clBlue"        },
  	{clFuchsia,"clFuchsia"  },
  	{clAqua,"clAqua"        },
  	{clWhite,"clWhite"      }
};

static AnsiString GetColorString(const int& index)
{
	return IndexColors[index].Name;
}

static Graphics::TColor GetColor(const int& index)
{
	return IndexColors[index].Color;
}

int ColorToIndex(Graphics::TColor tc)
{
	for (int i=0;i<NumOfColors;i++)
	  	if (GetColor(i)==tc) return i;
    return -1;
}

int StringToIndex(const AnsiString& nm)
{
	for (int i=0;i<NumOfColors;i++)
	  	if (GetColorString(i)==nm) return i;
	return -1;
}

//---------------------------------------------------------------------------
void __fastcall TDemoForm::DisplayHint(TObject *Sender)
{
	if (Application->Hint.Length()>0)
  		SBar->SimpleText=Application->Hint;
	else
  		SBar->SimpleText="Ready...";
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::Button1Click(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::edt_CustomPrefixChange(TObject *Sender)
{
	HyperLink8->CustomPrefix=edt_CustomPrefix->Text;
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::edt_CaptionChange(TObject *Sender)
{
	HyperLink8->Caption=edt_Caption->Text;
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::PageControl1Change(TObject *Sender)
{
	if (tab_Properties->Showing)
	{
		clg_LVColor->ForegroundIndex=ColorToIndex(hl_Prop->LinkColor);
		clg_LVColor->BackgroundIndex=ColorToIndex(hl_Prop->VisitedColor);
      	edt_PCaption->Text=hl_Prop->Caption;
      	com_PLinkType->ItemIndex=(int)hl_Prop->LinkType;
      	chk_PVisited->Checked=hl_Prop->Visited;
      	edt_PCustomPrefix->Text=hl_Prop->CustomPrefix;
      	hl_Prop->Invalidate();
	}
  	else if (tab_Custom->Showing)
	{
		edt_CustomPrefix->Text=HyperLink8->CustomPrefix;
      	edt_Caption->Text=HyperLink8->Caption;
      	HyperLink8->Invalidate();
	}
  	else if (tab_Urls->Showing)
	{
  		ListBox1->Items->Assign(UrlBase->VisitedUrlList);
  		ListBox2->Items->Assign(UrlBase->OtherUrls);
	}
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::FormShow(TObject *Sender)
{
	AnsiString IntroMsg;
	clg_LVColor->ForegroundIndex=ColorToIndex(hl_Prop->LinkColor);
	clg_LVColor->BackgroundIndex=ColorToIndex(hl_Prop->VisitedColor);
	edt_PCaption->Text=hl_Prop->Caption;
    com_PLinkType->ItemIndex=(int) hl_Prop->LinkType;
    chk_PVisited->Checked=hl_Prop->Visited;
    edt_PCustomPrefix->Text=hl_Prop->CustomPrefix;
    edt_PAlias->Text=hl_Prop->Alias;
    edt_PHint->Text=hl_Prop->Hint;
    chk_PParentShowHint->Checked=hl_Prop->ParentShowHint;
    chk_PShowHint->Checked=hl_Prop->ShowHint;
    if (Tag==0)
	{
    	IntroMsg="Welcome to the THyperLink 1.3 demo application\n\n"
                 "This component is (c) 1998 by H.P.G\n\n"
              	 "You can obtain the newest versions always from my homepage\n"
                 "the address is available on the tabsheet \"About\"\n\n"
                 "Click on \"Ok\" to continue...";
		ShowMessage(IntroMsg);
        Tag=1;
	}
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::clg_LVColorChange(TObject *Sender)
{
	hl_Prop->LinkColor=clg_LVColor->ForegroundColor;
	hl_Prop->VisitedColor=clg_LVColor->BackgroundColor;
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::edt_PCaptionChange(TObject *Sender)
{
	hl_Prop->Caption=edt_PCaption->Text;
    FormShow(this);
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::com_PLinkTypeChange(TObject *Sender)
{
	hl_Prop->LinkType=(TLinkType)com_PLinkType->ItemIndex;
    FormShow(this);
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::chk_PVisitedClick(TObject *Sender)
{
	hl_Prop->Visited=chk_PVisited->Checked;
    FormShow(this);
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::edt_PCustomPrefixChange(TObject *Sender)
{
	hl_Prop->CustomPrefix=edt_PCustomPrefix->Text;
    FormShow(this);
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::FormCreate(TObject *Sender)
{
	Application->OnHint=DisplayHint;
	Application->HintHidePause=5000;
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::HyperLink15Execute(TObject *Sender, bool &ExecuteIt)
{
	ExecuteIt=false;
    ShowMessage(
    	"OnBeforeExecute is defined as follows:\n\n"
		"\ttypedef void __fastcall (__closure *TBeforeExecuteEvent)\n\t"
        "(System::TObject* Sender, bool &ExecuteIt);\n\n"
        "This event is fired when the user clicks on the THyperLink and\n"
        "before the OnExecute event occurs. Setting the ExecuteIt parameter\n"
        "to false will prevent THyperLink to execute the address.\n"
        "You can i.e. start another application than the associated one.");
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::HyperLink16Execute(TObject *Sender, bool &ExecuteIt)
{
	ExecuteIt=false;
    ShowMessage(
    	"OnExecute is defined as follows:\n\n"
		"\ttypedef void __fastcall (__closure *TExecuteEvent)\n\t"
        "(System::TObject* Sender, bool &ExecuteIt);\n\n"
        "this event is fired when the user clicks on the THyperLink and\n"
        "the OnBeforeExecute event allows the execution.\n"
        "Setting the ExecuteIt parameter to false will prevent THyperLink\n"
        "to execute the address. The difference to the OnBeforeExecute event\n"
        "is that the OnAfterExecute event will be always fired also when you set\n"
        "ExecuteIt to false which changes the VisitedColor and flag\n"
        "You can i.e. also start another application than the associated one.");
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::HyperLink17Execute(TObject *Sender, bool &ExecuteIt)
{
	ExecuteIt=false;
    ShowMessage(
    	"OnExecute is defined as follows:\n\n"
		"\ttypedef void __fastcall (__closure *TAfterExecuteEvent)\n\t"
        "(System::TObject* Sender, long Reslt);\n\n"
        "this event is fired when the user clicks on the THyperLink and\n"
        "the OnBeforeExecute and OnExecute event allows the execution.\n"
        "The Result parameter is the return value of the ShellExecute function\n"
        "call. If its value is smaller then 32 you got an error and the application\n"
        "could not be started. To determine the reason use the GetLastError()\n"
        "WINAPI function");
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::chk_PParentShowHintClick(TObject *Sender)
{
	hl_Prop->ParentShowHint=chk_PParentShowHint->Checked;
    FormShow(this);
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::chk_PShowHintClick(TObject *Sender)
{
	hl_Prop->ShowHint=chk_PShowHint->Checked;
    FormShow(this);
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::edt_PAliasChange(TObject *Sender)
{
	hl_Prop->Alias=edt_PAlias->Text;
	FormShow(this);
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::edt_PHintChange(TObject *Sender)
{
	hl_Prop->Hint=edt_PHint->Text;
	FormShow(this);
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::Button2Click(TObject *Sender)
{
 	ListBox1->Items->Assign(UrlBase->VisitedUrlList);
 	ListBox2->Items->Assign(UrlBase->OtherUrls);
}
//---------------------------------------------------------------------------
void __fastcall TDemoForm::Button3Click(TObject *Sender)
{
	UrlBase->Reset();
 	ListBox1->Items->Assign(UrlBase->VisitedUrlList);
 	ListBox2->Items->Assign(UrlBase->OtherUrls);
}
//---------------------------------------------------------------------------