#include "stdafx.h"
#include "app.h"
#include "histogram.h"
#include "doc.h"
#include "view.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CHistogramPalette::CHistogramPalette()
{  
  m_bShowRed = TRUE;
  m_bShowGreen = TRUE;
  m_bShowBlue = TRUE;
}

CHistogramPalette::~CHistogramPalette()
{
}


BEGIN_MESSAGE_MAP(CHistogramPalette, CDialogBar)
	//{{AFX_MSG_MAP(CHistogramPalette)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_RED, OnRed)
	ON_BN_CLICKED(IDC_GREEN, OnGreen)
	ON_BN_CLICKED(IDC_BLUE, OnBlue)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CHistogramPalette::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

  CDibtestView* pView = (CDibtestView*) GetMainFrame()->GetActiveFrame()->GetActiveView();

  if (pView)
  {
    CDibtestDoc* pDoc = pView->GetDocument();
    CRect rect;
    GetClientRect(rect);
    int nMaxHeight = rect.Height() - 40;

    //draw the chart axis
    CPen BlackPen(PS_SOLID, 1, RGB(0, 0, 0));
    CPen* pOldPen = dc.SelectObject(&BlackPen);
    dc.MoveTo(9, rect.bottom - 29 - nMaxHeight);
    dc.LineTo(9, rect.bottom - 29);
    dc.LineTo(266, rect.bottom - 29);
    dc.SelectObject(pOldPen);

    BOOL bShowMoreThan1Graph = (m_bShowRed && m_bShowGreen) || (m_bShowRed && m_bShowBlue) || (m_bShowBlue && m_bShowGreen);

    //Do the red histogram
    if (m_bShowRed)
    {
      int m_nMaxColor = pDoc->m_nMaxRed;
      if (bShowMoreThan1Graph)
        m_nMaxColor = pDoc->m_nMaxColor;

      CPen RedPen(PS_SOLID, 1, RGB(255, 0, 0));
      pOldPen = dc.SelectObject(&RedPen);
      int y = rect.bottom - 30;
      if (m_nMaxColor)
        y -= pDoc->m_RedChannel[0]*nMaxHeight/m_nMaxColor;
      dc.MoveTo(10, y);
      for (int i=1; i<256; i++)
      {
        y = rect.bottom - 30;
        if (m_nMaxColor)
          y -= pDoc->m_RedChannel[i]*nMaxHeight/m_nMaxColor;
         dc.LineTo(i+10, y);
      }
      dc.SelectObject(pOldPen);
    }

    //Do the green histogram
    if (m_bShowGreen)
    {
      int m_nMaxColor = pDoc->m_nMaxGreen;
      if (bShowMoreThan1Graph)
        m_nMaxColor = pDoc->m_nMaxColor;

      CPen GreenPen(PS_SOLID, 1, RGB(0, 255, 0));
      pOldPen = dc.SelectObject(&GreenPen);
      int y = rect.bottom - 30;
      if (m_nMaxColor)
        y -= pDoc->m_GreenChannel[0]*nMaxHeight/m_nMaxColor;
      dc.MoveTo(10, y);
      for (int i=1; i<256; i++)
      {
        y = rect.bottom - 30;
        if (m_nMaxColor)
          y -= pDoc->m_GreenChannel[i]*nMaxHeight/m_nMaxColor;
         dc.LineTo(i+10, y);
      }
      dc.SelectObject(pOldPen);
    }


    //Do the blue histogram
    if (m_bShowBlue)
    {
      int m_nMaxColor = pDoc->m_nMaxBlue;
      if (bShowMoreThan1Graph)
        m_nMaxColor = pDoc->m_nMaxColor;

      CPen BluePen(PS_SOLID, 1, RGB(0, 0, 255));
      pOldPen = dc.SelectObject(&BluePen);
      int y = rect.bottom - 30;
      if (m_nMaxColor)
        y -= pDoc->m_BlueChannel[0]*nMaxHeight/m_nMaxColor;
      dc.MoveTo(10, y);
      for (int i=1; i<256; i++)
      {
        y = rect.bottom - 30;
        if (m_nMaxColor)
          y -= pDoc->m_BlueChannel[i]*nMaxHeight/m_nMaxColor;
         dc.LineTo(i+10, y);
      }
      dc.SelectObject(pOldPen);
    }
  }
}


void CHistogramPalette::OnRed() 
{
  CButton* pRed = (CButton*) GetDlgItem(IDC_RED);
  ASSERT(pRed);

  if (pRed->GetCheck() == 1)
    m_bShowRed = TRUE;
  else
    m_bShowRed = FALSE;

  Invalidate();
}

void CHistogramPalette::OnGreen() 
{
  CButton* pGreen = (CButton*) GetDlgItem(IDC_GREEN);
  ASSERT(pGreen);

  if (pGreen->GetCheck() == 1)
    m_bShowGreen = TRUE;
  else
    m_bShowGreen = FALSE;

  Invalidate();
}

void CHistogramPalette::OnBlue() 
{
  CButton* pBlue = (CButton*) GetDlgItem(IDC_BLUE);
  ASSERT(pBlue);

  if (pBlue->GetCheck() == 1)
    m_bShowBlue = TRUE;
  else
    m_bShowBlue = FALSE;

  Invalidate();
}


void CHistogramPalette::SetChecks()
{
  CButton* pRed = (CButton*) GetDlgItem(IDC_RED);
  ASSERT(pRed);
  pRed->SetCheck(1);

  CButton* pGreen = (CButton*) GetDlgItem(IDC_GREEN);
  ASSERT(pGreen);
  pGreen->SetCheck(1);

  CButton* pBlue = (CButton*) GetDlgItem(IDC_BLUE);
  ASSERT(pBlue);
  pBlue->SetCheck(1);
}


BOOL CHistogramPalette::Create(CWnd* pParentWnd, LPCTSTR lpszTemplateName, UINT nStyle, UINT nID )
{
  BOOL bSuccess = CDialogBar::Create(pParentWnd, lpszTemplateName, nStyle, nID);
  SetChecks();
  return bSuccess;
}

BOOL CHistogramPalette::Create(CWnd* pParentWnd, UINT nIDTemplate, UINT nStyle, UINT nID )
{
  BOOL bSuccess = CDialogBar::Create(pParentWnd, nIDTemplate, nStyle, nID);
  SetChecks();
  return bSuccess;
}

