#include "stdafx.h"
#include "app.h"
#include "MainFrm.h"
#include "ChildFrm.h"
#include "Doc.h"
#include "View.h"
#include "NewImageDlg.h"
#include "combinedlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


CApp* GetApp()
{
  return (CApp*) AfxGetApp();
}

CMainFrame* GetMainFrame()
{
  return (CMainFrame*) AfxGetMainWnd();
}


BEGIN_MESSAGE_MAP(CApp, CWinApp)
	//{{AFX_MSG_MAP(CApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_EDIT_EMPTY, OnEditEmpty)
	ON_UPDATE_COMMAND_UI(ID_EDIT_EMPTY, OnUpdateEditEmpty)
	ON_COMMAND(ID_EDIT_PASTE_IMAGE, OnEditPasteImage)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_IMAGE, OnUpdateEditPasteImage)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_WINDOW_CLOSEALL, OnWindowCloseall)
	ON_UPDATE_COMMAND_UI(ID_WINDOW_CLOSEALL, OnUpdateWindowCloseall)
	ON_COMMAND(ID_CHANNEL_COMBINE, OnChannelCombine)
	ON_UPDATE_COMMAND_UI(ID_CHANNEL_COMBINE, OnUpdateChannelCombine)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

CApp::CApp()
{
  m_bNewFromPaste = FALSE;
  m_nNewWidth = 320;
  m_nNewHeight = 200;
}

CApp theApp;

BOOL CApp::InitInstance()
{
  SetRegistryKey(_T("PJ Naughter"));
	Enable3dControls();			
	LoadStdProfileSettings();

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_DIBTESTYPE,
		RUNTIME_CLASS(CDibtestDoc),
		RUNTIME_CLASS(CChildFrame),
		RUNTIME_CLASS(CDibtestView));
	AddDocTemplate(pDocTemplate);

	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

  m_pMainWnd->DragAcceptFiles();

	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

  if (cmdInfo.m_nShellCommand == CCommandLineInfo::FileNew)
    cmdInfo.m_nShellCommand = CCommandLineInfo::FileNothing;

	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}

void CApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

void CApp::OnEditPasteImage() 
{
  POSITION posTemplate = GetFirstDocTemplatePosition();
  CDocTemplate* pDocTemplate = GetNextDocTemplate(posTemplate);
  m_bNewFromPaste = TRUE;
  CDibtestDoc* pDocument = (CDibtestDoc*) pDocTemplate->OpenDocumentFile(NULL);
  pDocument->m_Dib.PasteFromClipboard();
  pDocument->UpdateHistogramData();
  pDocument->SetModifiedFlag(TRUE);
  pDocument->UpdateAllViews(NULL);
  m_bNewFromPaste = FALSE;
}

void CApp::OnUpdateEditPasteImage(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(CDibImage::PasteAvailable());
}

void CApp::OnEditEmpty() 
{
	if (OpenClipboard(NULL))
	{
		if (EmptyClipboard())
		CloseClipboard();
	}
}

void CApp::OnUpdateEditEmpty(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(CountClipboardFormats() != 0);
}

void CApp::OnFileNew() 
{
  CNewImageDlg dlg;
  dlg.m_nWidth = m_nNewWidth;
  dlg.m_nHeight = m_nNewHeight;
  if (dlg.DoModal() == IDOK)
  {
    m_nNewWidth = dlg.m_nWidth;
    m_nNewHeight = dlg.m_nHeight;
    CWinApp::OnFileNew();
  }
}

void CApp::OnWindowCloseall() 
{
  POSITION posTemplate = GetFirstDocTemplatePosition();
  while (posTemplate != NULL) 
  {
    CDocTemplate* pTemplate = GetNextDocTemplate(posTemplate);
    ASSERT(pTemplate->IsKindOf(RUNTIME_CLASS(CDocTemplate)));
    POSITION posDoc = pTemplate->GetFirstDocPosition();
    while (posDoc != NULL) 
    {
      CDocument* pDoc = pTemplate->GetNextDoc(posDoc);
      if (!pDoc->SaveModified())
        return;        // user aborted
      pDoc->OnCloseDocument();
    }
  }
}


int CApp::NumberOfOpenDocuments() const
{
	int nOpenDocuments = 0;
  POSITION posTemplate = GetFirstDocTemplatePosition();
  while (posTemplate != NULL) 
  {
    CDocTemplate* pTemplate = GetNextDocTemplate(posTemplate);
    ASSERT(pTemplate->IsKindOf(RUNTIME_CLASS(CDocTemplate)));
    POSITION posDoc = pTemplate->GetFirstDocPosition();
    while (posDoc != NULL) 
    {
      CDocument* pDoc = pTemplate->GetNextDoc(posDoc);
      ++nOpenDocuments;
    }
  }

  return nOpenDocuments;
}


void CApp::OnUpdateWindowCloseall(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(NumberOfOpenDocuments());
}


void CApp::OnChannelCombine() 
{
  CCombineDlg dlg;
  if (dlg.DoModal() == IDOK)
  {
    CDibImage dib;
    if (dib.CombineChannels(*dlg.GetRedImage(), *dlg.GetGreenImage(), *dlg.GetBlueImage()))
    {
      POSITION posTemplate = GetFirstDocTemplatePosition();
      CDocTemplate* pDocTemplate = GetNextDocTemplate(posTemplate);
      m_bNewFromPaste = TRUE;
      CDibtestDoc* pDocument = (CDibtestDoc*) pDocTemplate->OpenDocumentFile(NULL);
      pDocument->m_Dib = dib;
      pDocument->UpdateHistogramData();
      pDocument->SetModifiedFlag(TRUE);
      pDocument->UpdateAllViews(NULL);
      m_bNewFromPaste = FALSE;
    }
    else
      AfxMessageBox(IDS_FAIL_COMBINE);
  }
}

void CApp::OnUpdateChannelCombine(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(NumberOfOpenDocuments());
}






CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()





