#ifndef __VIEW_H__
#define __VIEW_H__


class CDibtestView : public CScrollView
{
public:
  BOOL GetColorAndPositionAtCursor(COLORREF& color, int& x, int& y);


protected: // create from serialization only
	CDibtestView();
	DECLARE_DYNCREATE(CDibtestView)

	CDibtestDoc* GetDocument();

	//{{AFX_VIRTUAL(CDibtestView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

	virtual ~CDibtestView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	//{{AFX_MSG(CDibtestView)
	afx_msg void OnViewNormal();
	afx_msg void OnUpdateViewNormal(CCmdUI* pCmdUI);
  afx_msg LRESULT OnDoRealize(WPARAM wParam, LPARAM lParam);  // user message
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnSelectAll();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	//}}AFX_MSG
	afx_msg void OnZoomin(UINT nID);
  afx_msg void OnUpdateZoomin(CCmdUI* pCmdUI);
	afx_msg void OnZoomout(UINT nID);
  afx_msg void OnUpdateZoomout(CCmdUI* pCmdUI);

  void DrawSelectionRect(CDC* pDC);

	DECLARE_MESSAGE_MAP()

  BOOL m_bZoomIn;
  int m_nZoomIn;
  int m_nZoomOut;
  HCURSOR m_hMagnify;
  HCURSOR m_hDropper;
  HCURSOR m_hRectangleSelection;
};

#ifndef _DEBUG  // debug version in dibtestView.cpp
inline CDibtestDoc* CDibtestView::GetDocument()
   { return (CDibtestDoc*)m_pDocument; }
#endif


#endif __VIEW_H__
