#include "stdafx.h"
#include "app.h"
#include "Doc.h"
#include "View.h"
#include "mainfrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CDibtestView, CScrollView)

BEGIN_MESSAGE_MAP(CDibtestView, CScrollView)
	//{{AFX_MSG_MAP(CDibtestView)
	ON_COMMAND(ID_VIEW_NORMAL, OnViewNormal)
	ON_UPDATE_COMMAND_UI(ID_VIEW_NORMAL, OnUpdateViewNormal)
	ON_MESSAGE(WM_DOREALIZE, OnDoRealize)
	ON_WM_CHAR()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_WM_SETCURSOR()
	ON_COMMAND(ID_SELECT_ALL, OnSelectAll)
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
  ON_COMMAND_RANGE(ID_ZOOMIN2, ID_ZOOMIN16, OnZoomin)
  ON_UPDATE_COMMAND_UI_RANGE(ID_ZOOMIN2, ID_ZOOMIN16, OnUpdateZoomin)
  ON_COMMAND_RANGE(ID_ZOOMOUT2, ID_ZOOMOUT16, OnZoomout)
  ON_UPDATE_COMMAND_UI_RANGE(ID_ZOOMOUT2, ID_ZOOMOUT16, OnUpdateZoomout)
END_MESSAGE_MAP()

CDibtestView::CDibtestView()
{
  m_bZoomIn = TRUE;
  m_nZoomIn = 1;
  m_nZoomOut = 1;

  m_hMagnify = AfxGetApp()->LoadCursor(IDC_MAGNIFY);
  m_hDropper = AfxGetApp()->LoadCursor(IDC_DROPPER);
  m_hRectangleSelection = AfxGetApp()->LoadCursor(IDC_RECTANGLE_SELECTION);
}

CDibtestView::~CDibtestView()
{
}

BOOL CDibtestView::PreCreateWindow(CREATESTRUCT& cs)
{
	return CScrollView::PreCreateWindow(cs);
}

void CDibtestView::OnDraw(CDC* pDC)
{
	CDibtestDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

  CSize size = GetTotalSize();
  CRect rect(0, 0, size.cx, size.cy);
  GetDocument()->m_Dib.Draw(*pDC, &rect);

  DrawSelectionRect(pDC);
}


void CDibtestView::DrawSelectionRect(CDC* pDC)
{
  CRectTracker RectTracker;
  RectTracker.m_nStyle = CRectTracker::dottedLine;
  RectTracker.m_rect = GetDocument()->m_Dib.GetWorkingArea()->BoundingRectangle();
  if (m_bZoomIn)
  {
    RectTracker.m_rect.top *= m_nZoomIn;
    RectTracker.m_rect.bottom *= m_nZoomIn;
    RectTracker.m_rect.left *= m_nZoomIn;
    RectTracker.m_rect.right *= m_nZoomIn;
  }
  else
  {
    RectTracker.m_rect.top /= m_nZoomOut;
    RectTracker.m_rect.bottom /= m_nZoomOut;
    RectTracker.m_rect.left /= m_nZoomOut;
    RectTracker.m_rect.right /= m_nZoomOut;
  }

  RectTracker.Draw(pDC);
}


BOOL CDibtestView::OnPreparePrinting(CPrintInfo* pInfo)
{
  pInfo->SetMaxPage(1);
	return DoPreparePrinting(pInfo);
}

void CDibtestView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}

void CDibtestView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}

#ifdef _DEBUG
void CDibtestView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CDibtestView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CDibtestDoc* CDibtestView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDibtestDoc)));
	return (CDibtestDoc*)m_pDocument;
}
#endif //_DEBUG

LRESULT CDibtestView::OnDoRealize(WPARAM wParam, LPARAM)
{
	ASSERT(wParam != NULL);
	CDibtestDoc* pDoc = GetDocument();
	if (pDoc->m_Dib.GetHDIB() == NULL)
		return 0L;  // must be a new document

  CPalette pal;
  pal.Attach(pDoc->m_Dib.GetHPALLETTE());
	CPalette* pPal = &pal;
	if (pPal != NULL)
	{
		CMainFrame* pAppFrame = (CMainFrame*) AfxGetApp()->m_pMainWnd;
		ASSERT_KINDOF(CMainFrame, pAppFrame);

		CClientDC appDC(pAppFrame);
		// All views but one should be a background palette.
		// wParam contains a handle to the active view, so the SelectPalette
		// bForceBackground flag is FALSE only if wParam == m_hWnd (this view)
		CPalette* oldPalette = appDC.SelectPalette(pPal, ((HWND)wParam) != m_hWnd);

		if (oldPalette != NULL)
		{
			UINT nColorsChanged = appDC.RealizePalette();
			if (nColorsChanged > 0)
				pDoc->UpdateAllViews(NULL);
			appDC.SelectPalette(oldPalette, TRUE);
		}
		else
		{
			TRACE0("\tSelectPalette failed in CDibView::OnPaletteChanged\n");
		}
	}
  pal.Detach();

	return 0L;
}


void CDibtestView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
  GetDocument()->m_Dib.Draw(*pDC, &pInfo->m_rectDraw);
}

void CDibtestView::OnZoomin(UINT nID) 
{
  m_bZoomIn = TRUE;
  m_nZoomIn = (nID - ID_ZOOMIN2) + 2;
  CSize size(GetDocument()->m_Dib.Size());
  size.cx *= m_nZoomIn;
  size.cy *= m_nZoomIn;
  SetScrollSizes(MM_TEXT, size);
  Invalidate();
}

void CDibtestView::OnUpdateZoomin(CCmdUI* pCmdUI) 
{
  if (m_bZoomIn)
	  pCmdUI->SetCheck((pCmdUI->m_nID - ID_ZOOMIN2+2) == (UINT) m_nZoomIn);
  else
	  pCmdUI->SetCheck(FALSE);
}

void CDibtestView::OnZoomout(UINT nID) 
{
  m_bZoomIn = FALSE;
  m_nZoomOut = (nID - ID_ZOOMOUT2) + 2;
  CSize size(GetDocument()->m_Dib.Size());
  size.cx /= m_nZoomOut;
  size.cy /= m_nZoomOut;
  SetScrollSizes(MM_TEXT, size);
  Invalidate();
}

void CDibtestView::OnUpdateZoomout(CCmdUI* pCmdUI) 
{
  if (!m_bZoomIn)
	  pCmdUI->SetCheck((pCmdUI->m_nID - ID_ZOOMOUT2+2) == (UINT) m_nZoomOut);
  else
	  pCmdUI->SetCheck(FALSE);
}

void CDibtestView::OnViewNormal() 
{
  m_bZoomIn = FALSE;
  m_nZoomOut = 1;
  m_nZoomIn = 1;
  SetScrollSizes(MM_TEXT, GetDocument()->m_Dib.Size());
  Invalidate();
}

void CDibtestView::OnUpdateViewNormal(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck((m_nZoomIn == 1) && (m_nZoomOut == 1));
}

void CDibtestView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{
	CScrollView::OnActivateView(bActivate, pActivateView, pDeactiveView);

	if (bActivate)
	{
    GetMainFrame()->m_HistogramBar.Invalidate();
		ASSERT(pActivateView == this);
		OnDoRealize((WPARAM)m_hWnd, 0);   // same as SendMessage(WM_DOREALIZE);
	}
}

void CDibtestView::OnInitialUpdate() 
{
	CScrollView::OnInitialUpdate();
	SetScrollSizes(MM_TEXT, GetDocument()->m_Dib.Size());
}

void CDibtestView::OnUpdate(CView* /*pSender*/, LPARAM /*lHint*/, CObject* /*pHint*/) 
{
  CSize size(GetDocument()->m_Dib.Size());
  if (m_bZoomIn)
  {
    size.cx *= m_nZoomIn;
    size.cy *= m_nZoomIn;
  }
  else
  {
    size.cx /= m_nZoomOut;
    size.cy /= m_nZoomOut;
  }
  SetScrollSizes(MM_TEXT, size);
  Invalidate();
}

BOOL CDibtestView::OnEraseBkgnd(CDC* pDC) 
{
  //return CScrollView::OnEraseBkgnd(pDC);
  CBrush br;
  br.CreateHatchBrush(HS_DIAGCROSS, RGB(0, 0, 0));
  FillOutsideRect(pDC, &br);
  return TRUE;
}

void CDibtestView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (nChar == VK_ESCAPE)
	{
		CFrameWnd* pFrame = (CFrameWnd*) AfxGetMainWnd();
	  pFrame->PostMessage(WM_COMMAND, ID_VIEW_FULLSCREEN);
	}
  CView::OnChar(nChar, nRepCnt, nFlags);
}


BOOL CDibtestView::GetColorAndPositionAtCursor(COLORREF& color, int& x, int& y) 
{
  POINT point;
  if (!GetCursorPos(&point))
    return FALSE;
  ScreenToClient(&point);

  CSize size = GetTotalSize();
  CRect rect(0, 0, size.cx, size.cy);
  if (!rect.PtInRect(point))
    return FALSE;

  CClientDC dc(this);
  color = dc.GetPixel(point.x, point.y);

  x = point.x;
  y = point.y;

  if (m_bZoomIn)
  {
    x /= m_nZoomIn;
    y /= m_nZoomIn;
  }
  else
  {
    x *= m_nZoomOut;
    y *= m_nZoomOut;
  }

  return TRUE;
}


void CDibtestView::OnLButtonDown(UINT /*nFlags*/, CPoint point) 
{
  if (GetMainFrame()->m_ToolOption == Magnify)
  {
    if (m_nZoomOut > 2 && m_nZoomOut <= 16)
      OnZoomout(ID_ZOOMOUT2+m_nZoomOut-3);
    else if (m_nZoomOut == 2)
      OnViewNormal();
    else if (m_nZoomOut == 1 && m_nZoomIn == 1)
      OnZoomin(ID_ZOOMIN2);
    else if (m_nZoomIn < 16)
      OnZoomin(ID_ZOOMIN2+m_nZoomIn-1);
  }
  else if (GetMainFrame()->m_ToolOption == ColorDropper)
  {
    int x;
    int y;
    COLORREF color;
    if (GetColorAndPositionAtCursor(color, x, y)) 
    {
      GetMainFrame()->m_PaletteBar.m_ForeColor = color;
      GetMainFrame()->m_PaletteBar.Invalidate();
    }
  }
  else if (GetMainFrame()->m_ToolOption == RectangleSelection)
  {
    Invalidate();
    CRectTracker RectTracker;
    if (RectTracker.TrackRubberBand(this, point))
    {
      CWaitCursor wait;
      //m_bHaveSelectionRect = TRUE;
      CDibtestDoc* pDoc = GetDocument();

      //ensure the rectangle is the right way up
      if (RectTracker.m_rect.left > RectTracker.m_rect.right)
      {
        int t = RectTracker.m_rect.left;
        RectTracker.m_rect.left = RectTracker.m_rect.right;
        RectTracker.m_rect.right = t;
      }

      //ensure the rectangle is the right way up
      if (RectTracker.m_rect.top > RectTracker.m_rect.bottom)
      {
        int t = RectTracker.m_rect.top;
        RectTracker.m_rect.top = RectTracker.m_rect.bottom;
        RectTracker.m_rect.bottom = t;
      }

      //clip the selection to the maximum size of the window
      CSize size(GetTotalSize());
      if (RectTracker.m_rect.left < 0)
        RectTracker.m_rect.left = 0;
      if (RectTracker.m_rect.top < 0)
        RectTracker.m_rect.top = 0;
      if (RectTracker.m_rect.right > size.cx)
        RectTracker.m_rect.right = size.cx;
      if (RectTracker.m_rect.bottom > size.cy)
        RectTracker.m_rect.bottom = size.cy;

      if (m_bZoomIn)
      {
        RectTracker.m_rect.top /= m_nZoomIn;
        RectTracker.m_rect.bottom /= m_nZoomIn;
        RectTracker.m_rect.left /= m_nZoomIn;
        RectTracker.m_rect.right /= m_nZoomIn;
      }
      else
      {
        RectTracker.m_rect.top *= m_nZoomOut;
        RectTracker.m_rect.bottom *= m_nZoomOut;
        RectTracker.m_rect.left *= m_nZoomOut;
        RectTracker.m_rect.right *= m_nZoomOut;
      }

      pDoc->m_Dib.SetWorkingArea(new CRectWorkingArea(RectTracker.m_rect));
      pDoc->UpdateHistogramData();
    }
    else
    {
      //m_bHaveSelectionRect = FALSE;
      MessageBeep(0);
    }
    Invalidate(FALSE);
  }
}


void CDibtestView::OnRButtonDown(UINT /*nFlags*/, CPoint /*point*/) 
{
  if (GetMainFrame()->m_ToolOption == Magnify)
  {
    if (m_nZoomIn > 2 && m_nZoomIn <= 16)
      OnZoomin(ID_ZOOMIN2+m_nZoomIn-3);
    else if (m_nZoomIn == 2)
      OnViewNormal();
    else if (m_nZoomOut == 1 && m_nZoomIn == 1)
      OnZoomout(ID_ZOOMOUT2);
    else if (m_nZoomOut < 16)
      OnZoomout(ID_ZOOMOUT2+m_nZoomOut-1);
  }
  else if (GetMainFrame()->m_ToolOption == ColorDropper)
  {
    int x;
    int y;
    COLORREF color;
    if (GetColorAndPositionAtCursor(color, x, y)) 
    {
      GetMainFrame()->m_PaletteBar.m_BackColor = color;
      GetMainFrame()->m_PaletteBar.Invalidate();
    }
  }
}


BOOL CDibtestView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
  m_hMagnify = AfxGetApp()->LoadCursor(IDC_MAGNIFY);
  m_hDropper = AfxGetApp()->LoadCursor(IDC_DROPPER);
  m_hRectangleSelection = AfxGetApp()->LoadCursor(IDC_RECTANGLE_SELECTION);

  BOOL bSuccess = TRUE;
  if (GetMainFrame()->m_ToolOption == Magnify)
    ::SetCursor(m_hMagnify);
  else if (GetMainFrame()->m_ToolOption == RectangleSelection)
    ::SetCursor(m_hRectangleSelection);
  else if (GetMainFrame()->m_ToolOption == ColorDropper)
    ::SetCursor(m_hDropper);
  else
    bSuccess = CScrollView::OnSetCursor(pWnd, nHitTest, message);

  return bSuccess;
}


void CDibtestView::OnSelectAll() 
{
  CWaitCursor wait;
  CDibtestDoc* pDoc = GetDocument();
  CSize size(pDoc->m_Dib.Size());
  pDoc->m_Dib.SetWorkingArea(new CRectWorkingArea(pDoc->m_Dib.Rect()));
  pDoc->UpdateHistogramData();
  Invalidate(FALSE);
}


