#include "stdafx.h"
#include "app.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_PALETTECHANGED()
	ON_WM_QUERYNEWPALETTE()
	ON_COMMAND(ID_VIEW_FULLSCREEN, OnViewFullscreen)
	ON_COMMAND(ID_IMAGE_COLORDROPPER, OnImageColordropper)
	ON_UPDATE_COMMAND_UI(ID_IMAGE_COLORDROPPER, OnUpdateImageColordropper)
	ON_COMMAND(ID_IMAGE_SELECT, OnImageSelect)
	ON_UPDATE_COMMAND_UI(ID_IMAGE_SELECT, OnUpdateImageSelect)
	ON_COMMAND(ID_VIEW_ZOOM, OnViewZoom)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ZOOM, OnUpdateViewZoom)
  ON_COMMAND_EX(ID_VIEW_COLORPALETTE, OnBarCheck)
  ON_COMMAND_EX(ID_VIEW_HISTOGRAM, OnBarCheck)
  ON_COMMAND_EX(ID_VIEW_TOOLPALETTE, OnBarCheck)
  ON_UPDATE_COMMAND_UI(ID_VIEW_COLORPALETTE, OnUpdateControlBarMenu)
  ON_UPDATE_COMMAND_UI(ID_VIEW_HISTOGRAM, OnUpdateControlBarMenu)
  ON_UPDATE_COMMAND_UI(ID_VIEW_TOOLPALETTE, OnUpdateControlBarMenu)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

CMainFrame::CMainFrame()
{
  m_bIsFullScreen = FALSE;
  m_ToolOption = Magnify;
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	//Create the toolbar
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);
  CString sCaption;
  sCaption.LoadString(IDS_TOOLBAR);
  m_wndToolBar.SetWindowText(sCaption);


  //Create the 2nd toolbar
	if (!m_wndToolBar2.Create(this, WS_CHILD | WS_VISIBLE | CBRS_TOP, ID_VIEW_TOOLPALETTE) ||
		!m_wndToolBar2.LoadToolBar(IDR_TOOLS))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	m_wndToolBar2.SetBarStyle(m_wndToolBar2.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndToolBar2.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar2);
  sCaption.LoadString(IDS_TOOLS);
  m_wndToolBar2.SetWindowText(sCaption);


  //create the status bar
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}


  //Create the histogram bar
  m_HistogramBar.Create(this, IDD_HISTOGRAM, CBRS_TOP, ID_VIEW_HISTOGRAM);
  sCaption.LoadString(IDS_HISTOGRAM);
  m_HistogramBar.SetWindowText(sCaption);
  m_HistogramBar.EnableDocking(0);

  CRect rFrame;
  GetWindowRect(rFrame);
  int x = rFrame.right - 340;
  int y = rFrame.top + 90;
  FloatControlBar(&m_HistogramBar, CPoint(x, y), CBRS_ALIGN_TOP);


  //Create the color palette
  m_PaletteBar.Create(this, IDD_COLOR_PALETTE, CBRS_LEFT, ID_VIEW_COLORPALETTE);
  sCaption.LoadString(IDS_COLOR_PALETTE);
  m_PaletteBar.SetWindowText(sCaption);
  m_PaletteBar.EnableDocking(CBRS_ALIGN_RIGHT | CBRS_ALIGN_LEFT);

  x = rFrame.right - 50;
  y = rFrame.top + 90;
  FloatControlBar(&m_PaletteBar, CPoint(x, y), CBRS_ALIGN_TOP);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	return CMDIFrameWnd::PreCreateWindow(cs);
}

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG


void CMainFrame::OnPaletteChanged(CWnd* pFocusWnd) 
{
	CMDIFrameWnd::OnPaletteChanged(pFocusWnd);

	// always realize the palette for the active view
	CMDIChildWnd* pMDIChildWnd = MDIGetActive();
	if (pMDIChildWnd == NULL)
		return; // no active MDI child frame
	CView* pView = pMDIChildWnd->GetActiveView();
	ASSERT(pView != NULL);

	// notify all child windows that the palette has changed
	SendMessageToDescendants(WM_DOREALIZE, (WPARAM)pView->m_hWnd);
}

BOOL CMainFrame::OnQueryNewPalette() 
{
	// always realize the palette for the active view
	CMDIChildWnd* pMDIChildWnd = MDIGetActive();
	if (pMDIChildWnd == NULL)
		return FALSE; // no active MDI child frame (no new palette)
	CView* pView = pMDIChildWnd->GetActiveView();
	ASSERT(pView != NULL);

	// just notify the target view
	pView->SendMessage(WM_DOREALIZE, (WPARAM)pView->m_hWnd);
	return TRUE;
}



void CMainFrame::OnViewFullscreen() 
{
	// if the view is now full screen, change the view to normal size and state	
	if (m_bIsFullScreen) 
  {
	  // add the WS_CAPTION and WS_THICKFRAME styles to the frame window		
		ModifyStyle(0,WS_CAPTION);			
    ModifyStyle(0,WS_THICKFRAME);

	  // restore the frame window to normal size and state
	  ShowWindow(SW_SHOWNORMAL);	// restore the default menu and show it
		SetMenu(&m_Menu);
    m_Menu.Detach();


    //re show the toolbars
    ShowControlBar(&m_HistogramBar, m_bHistogramVisible, FALSE);
    ShowControlBar(&m_PaletteBar, m_bPaletteVisible, FALSE);
    ShowControlBar(&m_wndToolBar, m_bToolbarVisible, FALSE);
    ShowControlBar(&m_wndStatusBar, m_bStatusbarVisible, FALSE);
    ShowControlBar(&m_wndToolBar2, m_bToolbar2Visible, FALSE);

	  // set flag to indicate that frame window is now NOT full screen
		m_bIsFullScreen = 0;		
  }
	// if the view is now normal, change the view to full screen		
  else 
  {
    //remember each of the controlbars visibility before we hide them
    m_bHistogramVisible = ((m_HistogramBar.GetStyle() & WS_VISIBLE) != 0);
    m_bPaletteVisible = ((m_PaletteBar.GetStyle() & WS_VISIBLE) != 0);
    m_bToolbarVisible = ((m_wndToolBar.GetStyle() & WS_VISIBLE) != 0);
    m_bStatusbarVisible = ((m_wndStatusBar.GetStyle() & WS_VISIBLE) != 0);
    m_bToolbar2Visible = ((m_wndToolBar2.GetStyle() & WS_VISIBLE) != 0);


    m_Menu.Attach(GetMenu()->m_hMenu);

	  // remove the WS_CAPTION and WS_THICKFRAME styles from the frame window
		ModifyStyle(WS_CAPTION,0);			
    ModifyStyle(WS_THICKFRAME,0);
	  // remove the default menu and erase the menu			
    SetMenu(NULL);
	  // show the now menuless and frameless window full screen
		ShowWindow(SW_MAXIMIZE);

    ShowControlBar(&m_HistogramBar, FALSE, FALSE);
    ShowControlBar(&m_PaletteBar, FALSE, FALSE);
    ShowControlBar(&m_wndToolBar, FALSE, FALSE);
    ShowControlBar(&m_wndStatusBar, FALSE, FALSE);
    ShowControlBar(&m_wndToolBar2, FALSE, FALSE);

    CFrameWnd* pFrame = GetActiveFrame();
    if (pFrame)
      pFrame->ShowWindow(SW_MAXIMIZE);

	  //reset the flag to indicate that the view is now full screen
		m_bIsFullScreen = 1;		
  }
}


void CMainFrame::OnImageColordropper() 
{
	m_ToolOption = ColorDropper;
}


void CMainFrame::OnUpdateImageColordropper(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_ToolOption == ColorDropper);
}




void CMainFrame::OnImageSelect() 
{
	m_ToolOption = RectangleSelection;
}


void CMainFrame::OnUpdateImageSelect(CCmdUI* pCmdUI) 
{
  pCmdUI->SetCheck(m_ToolOption == RectangleSelection);
}


void CMainFrame::OnViewZoom() 
{
	m_ToolOption = Magnify;
}


void CMainFrame::OnUpdateViewZoom(CCmdUI* pCmdUI) 
{
  pCmdUI->SetCheck(m_ToolOption == Magnify);
}



