#include "dibimage.h"


class CDibtestDoc : public CDocument
{
protected: // create from serialization only
	CDibtestDoc();
	DECLARE_DYNCREATE(CDibtestDoc)

  CDibImage m_Dib;
  int m_RedChannel[256];
  int m_GreenChannel[256];
  int m_BlueChannel[256];
  int m_nMaxRed;
  int m_nMaxGreen;
  int m_nMaxBlue;
  int m_nMaxColor;
  void UpdateHistogramData();

	//{{AFX_VIRTUAL(CDibtestDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual void DeleteContents();
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL

	virtual ~CDibtestDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	//{{AFX_MSG(CDibtestDoc)
	afx_msg void OnViewGrayscale();
	afx_msg void OnUpdateViewGrayscale(CCmdUI* pCmdUI);
	afx_msg void OnAdjustRed();
	afx_msg void OnUpdateAdjustRed(CCmdUI* pCmdUI);
	afx_msg void OnEditRedo();
	afx_msg void OnUpdateEditRedo(CCmdUI* pCmdUI);
	afx_msg void OnEditUndo();
	afx_msg void OnUpdateEditUndo(CCmdUI* pCmdUI);
	afx_msg void OnColorNegative();
	afx_msg void OnUpdateColorNegative(CCmdUI* pCmdUI);
	afx_msg void OnEditCopy();
	afx_msg void OnEditPasteSelection();
	afx_msg void OnUpdateEditPasteSelection(CCmdUI* pCmdUI);
	afx_msg void OnChannelSplit();
	afx_msg void OnUpdateChannelSplit(CCmdUI* pCmdUI);
	afx_msg void OnAdjustGreen();
	afx_msg void OnUpdateAdjustGreen(CCmdUI* pCmdUI);
	afx_msg void OnAdjustBlue();
	afx_msg void OnUpdateAdjustBlue(CCmdUI* pCmdUI);
	afx_msg void OnAdjustBrightness();
	afx_msg void OnUpdateAdjustBrightness(CCmdUI* pCmdUI);
	afx_msg void OnImageFlip();
	afx_msg void OnUpdateImageFlip(CCmdUI* pCmdUI);
	afx_msg void OnFilterUserdefined();
	afx_msg void OnUpdateFilterUserdefined(CCmdUI* pCmdUI);
	afx_msg void OnImageMirror();
	afx_msg void OnUpdateImageMirror(CCmdUI* pCmdUI);
	afx_msg void OnAdjustGamma();
	afx_msg void OnUpdateAdjustGamma(CCmdUI* pCmdUI);
	afx_msg void OnAdjustContrast();
	afx_msg void OnUpdateAdjustContrast(CCmdUI* pCmdUI);
	afx_msg void OnAdjustMidtone();
	afx_msg void OnUpdateAdjustMidtone(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFilterFindEdges(CCmdUI* pCmdUI);
	afx_msg void OnFilterBlur();
	afx_msg void OnUpdateFilterBlur(CCmdUI* pCmdUI);
	afx_msg void OnAdjustSaturation();
	afx_msg void OnUpdateAdjustSaturation(CCmdUI* pCmdUI);
	afx_msg void OnAdjustHue();
	afx_msg void OnUpdateAdjustHue(CCmdUI* pCmdUI);
	afx_msg void OnFilterFindEdges();
	afx_msg void OnFilterAddNoise();
	afx_msg void OnUpdateFilterAddNoise(CCmdUI* pCmdUI);
	afx_msg void OnFilterFindHorizontalEdges();
	afx_msg void OnUpdateFilterFindHorizontalEdges(CCmdUI* pCmdUI);
	afx_msg void OnFilterFindVerticalEdges();
	afx_msg void OnUpdateFilterFindVerticalEdges(CCmdUI* pCmdUI);
	afx_msg void OnFilterMedian();
	afx_msg void OnUpdateFilterMedian(CCmdUI* pCmdUI);
	afx_msg void OnAdjustHighlight();
	afx_msg void OnUpdateAdjustHighlight(CCmdUI* pCmdUI);
	afx_msg void OnAdjustShadow();
	afx_msg void OnUpdateAdjustShadow(CCmdUI* pCmdUI);
	//}}AFX_MSG
	afx_msg void OnUndoSize(UINT nID);
  afx_msg void OnUpdateUndoSize(CCmdUI* pCmdUI);

	DECLARE_MESSAGE_MAP()
};

