#include "stdafx.h"
#include "app.h"
#include "Doc.h"
#include "OneValueDlg.h"
#include "UserFilterDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(CDibtestDoc, CDocument)

BEGIN_MESSAGE_MAP(CDibtestDoc, CDocument)
	//{{AFX_MSG_MAP(CDibtestDoc)
	ON_COMMAND(ID_VIEW_GRAYSCALE, OnViewGrayscale)
	ON_UPDATE_COMMAND_UI(ID_VIEW_GRAYSCALE, OnUpdateViewGrayscale)
	ON_COMMAND(ID_ADJUST_RED, OnAdjustRed)
	ON_UPDATE_COMMAND_UI(ID_ADJUST_RED, OnUpdateAdjustRed)
	ON_COMMAND(ID_EDIT_REDO, OnEditRedo)
	ON_UPDATE_COMMAND_UI(ID_EDIT_REDO, OnUpdateEditRedo)
	ON_COMMAND(ID_EDIT_UNDO, OnEditUndo)
	ON_UPDATE_COMMAND_UI(ID_EDIT_UNDO, OnUpdateEditUndo)
	ON_COMMAND(ID_COLOR_NEGATIVE, OnColorNegative)
	ON_UPDATE_COMMAND_UI(ID_COLOR_NEGATIVE, OnUpdateColorNegative)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_EDIT_PASTE_SELECTION, OnEditPasteSelection)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_SELECTION, OnUpdateEditPasteSelection)
	ON_COMMAND(ID_CHANNEL_SPLIT, OnChannelSplit)
	ON_UPDATE_COMMAND_UI(ID_CHANNEL_SPLIT, OnUpdateChannelSplit)
	ON_COMMAND(ID_ADJUST_GREEN, OnAdjustGreen)
	ON_UPDATE_COMMAND_UI(ID_ADJUST_GREEN, OnUpdateAdjustGreen)
	ON_COMMAND(ID_ADJUST_BLUE, OnAdjustBlue)
	ON_UPDATE_COMMAND_UI(ID_ADJUST_BLUE, OnUpdateAdjustBlue)
	ON_COMMAND(ID_ADJUST_BRIGHTNESS, OnAdjustBrightness)
	ON_UPDATE_COMMAND_UI(ID_ADJUST_BRIGHTNESS, OnUpdateAdjustBrightness)
	ON_COMMAND(ID_IMAGE_FLIP, OnImageFlip)
	ON_UPDATE_COMMAND_UI(ID_IMAGE_FLIP, OnUpdateImageFlip)
	ON_COMMAND(ID_FILTER_USERDEFINED, OnFilterUserdefined)
	ON_UPDATE_COMMAND_UI(ID_FILTER_USERDEFINED, OnUpdateFilterUserdefined)
	ON_COMMAND(ID_IMAGE_MIRROR, OnImageMirror)
	ON_UPDATE_COMMAND_UI(ID_IMAGE_MIRROR, OnUpdateImageMirror)
	ON_COMMAND(ID_ADJUST_GAMMA, OnAdjustGamma)
	ON_UPDATE_COMMAND_UI(ID_ADJUST_GAMMA, OnUpdateAdjustGamma)
	ON_COMMAND(ID_ADJUST_CONTRAST, OnAdjustContrast)
	ON_UPDATE_COMMAND_UI(ID_ADJUST_CONTRAST, OnUpdateAdjustContrast)
	ON_COMMAND(ID_ADJUST_MIDTONE, OnAdjustMidtone)
	ON_UPDATE_COMMAND_UI(ID_ADJUST_MIDTONE, OnUpdateAdjustMidtone)
	ON_UPDATE_COMMAND_UI(ID_FILTER_FIND_EDGES, OnUpdateFilterFindEdges)
	ON_COMMAND(ID_FILTER_BLUR, OnFilterBlur)
	ON_UPDATE_COMMAND_UI(ID_FILTER_BLUR, OnUpdateFilterBlur)
	ON_COMMAND(ID_ADJUST_SATURATION, OnAdjustSaturation)
	ON_UPDATE_COMMAND_UI(ID_ADJUST_SATURATION, OnUpdateAdjustSaturation)
	ON_COMMAND(ID_ADJUST_HUE, OnAdjustHue)
	ON_UPDATE_COMMAND_UI(ID_ADJUST_HUE, OnUpdateAdjustHue)
	ON_COMMAND(ID_FILTER_FIND_EDGES, OnFilterFindEdges)
	ON_COMMAND(ID_FILTER_ADD_NOISE, OnFilterAddNoise)
	ON_UPDATE_COMMAND_UI(ID_FILTER_ADD_NOISE, OnUpdateFilterAddNoise)
	ON_COMMAND(ID_FILTER_FIND_HORIZONTAL_EDGES, OnFilterFindHorizontalEdges)
	ON_UPDATE_COMMAND_UI(ID_FILTER_FIND_HORIZONTAL_EDGES, OnUpdateFilterFindHorizontalEdges)
	ON_COMMAND(ID_FILTER_FIND_VERTICAL_EDGES, OnFilterFindVerticalEdges)
	ON_UPDATE_COMMAND_UI(ID_FILTER_FIND_VERTICAL_EDGES, OnUpdateFilterFindVerticalEdges)
	ON_COMMAND(ID_FILTER_MEDIAN, OnFilterMedian)
	ON_UPDATE_COMMAND_UI(ID_FILTER_MEDIAN, OnUpdateFilterMedian)
	ON_COMMAND(ID_ADJUST_HIGHLIGHT, OnAdjustHighlight)
	ON_UPDATE_COMMAND_UI(ID_ADJUST_HIGHLIGHT, OnUpdateAdjustHighlight)
	ON_COMMAND(ID_ADJUST_SHADOW, OnAdjustShadow)
	ON_UPDATE_COMMAND_UI(ID_ADJUST_SHADOW, OnUpdateAdjustShadow)
	//}}AFX_MSG_MAP
  ON_UPDATE_COMMAND_UI_RANGE(ID_EDIT_UNDOSIZE_0, ID_EDIT_UNDOSIZE_4, OnUpdateUndoSize)
  ON_COMMAND_RANGE(ID_EDIT_UNDOSIZE_0, ID_EDIT_UNDOSIZE_4, OnUndoSize)
END_MESSAGE_MAP()


CDibtestDoc::CDibtestDoc()
{
  for (int i=0; i<256; i++)
  {
    m_RedChannel[i] = 0;
    m_GreenChannel[i] = 0;
    m_BlueChannel[i] = 0;
  }         
  
  m_nMaxRed = -1;
  m_nMaxGreen = -1;
  m_nMaxBlue = -1;
  m_nMaxColor = -1;
}


CDibtestDoc::~CDibtestDoc()
{
}


BOOL CDibtestDoc::OnNewDocument()
{
  BOOL bSuccess = CDocument::OnNewDocument();
  if (!GetApp()->m_bNewFromPaste)
    bSuccess = bSuccess && m_Dib.Create(CSize(GetApp()->m_nNewWidth, GetApp()->m_nNewHeight), 24);

  UpdateHistogramData();

  return bSuccess;
}


BOOL CDibtestDoc::OnSaveDocument(LPCTSTR lpszPathName) 
{
	DeleteContents();
	CWaitCursor wait;
  BOOL bSuccess = m_Dib.Save(lpszPathName);
  if (!bSuccess)
		ReportSaveLoadException(lpszPathName, NULL,	FALSE, AFX_IDP_FAILED_TO_SAVE_DOC);
	SetModifiedFlag(FALSE);
	return bSuccess;
}


BOOL CDibtestDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	DeleteContents();
	CWaitCursor wait;
  BOOL bSuccess = m_Dib.Load(lpszPathName);
  if (!bSuccess)
		ReportSaveLoadException(lpszPathName, NULL,	FALSE, AFX_IDP_FAILED_TO_OPEN_DOC);
	SetPathName(lpszPathName);
	SetModifiedFlag(FALSE);
  UpdateHistogramData();
	return bSuccess;
}


void CDibtestDoc::DeleteContents() 
{
	m_Dib.Destroy();
  for (int i=0; i<256; i++)
  {
    m_RedChannel[i] = 0;
    m_GreenChannel[i] = 0;
    m_BlueChannel[i] = 0;
  }         
  
  m_nMaxRed = -1;
  m_nMaxGreen = -1;
  m_nMaxBlue = -1;
  m_nMaxColor = -1;

	CDocument::DeleteContents();
}


#ifdef _DEBUG
void CDibtestDoc::AssertValid() const
{
	CDocument::AssertValid();
}


void CDibtestDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


void CDibtestDoc::OnViewGrayscale() 
{
  CWaitCursor wait;
  if (m_Dib.Greyscale())
  {
    UpdateHistogramData();
    SetModifiedFlag(TRUE);
    UpdateAllViews(NULL);
  }
  else
    AfxMessageBox(IDS_FAIL_GREYSCALE);
}


void CDibtestDoc::OnUpdateViewGrayscale(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}


void CDibtestDoc::OnAdjustRed() 
{
  COneValueDlg dlg;
  CString sCaption;
  sCaption.LoadString(IDS_ADJUST_RED);
  dlg.m_sCaption = sCaption;
  CString sPrompt;
  sPrompt.LoadString(IDS_ADJUST_RED_PERCENT);
  dlg.m_sPrompt = sPrompt;
  if (dlg.DoModal() == IDOK)
  {
    CWaitCursor wait;
    if (m_Dib.AdjustRed(dlg.m_nValue))
    {
      UpdateHistogramData();
      SetModifiedFlag(TRUE);
      UpdateAllViews(NULL);
    }
    else
      AfxMessageBox(IDS_FAIL_ADJUST_RED);
  }
}


void CDibtestDoc::OnUpdateAdjustRed(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}


void CDibtestDoc::OnEditRedo() 
{
  CWaitCursor wait;
	if (m_Dib.Redo())
  {
    UpdateHistogramData();
    UpdateAllViews(NULL);
  }
  else
    AfxMessageBox(IDS_FAIL_REDO);
}


void CDibtestDoc::OnUpdateEditRedo(CCmdUI* pCmdUI) 
{
  if (m_Dib.RedoAvailable())
  {
    CString sText;
    AfxFormatString1(sText, IDS_REDO_DESCRIPTION, m_Dib.RedoDescription());
    pCmdUI->SetText(sText);
    pCmdUI->Enable(TRUE);
  }
  else
  {
    CString sText;
    sText.LoadString(IDS_REDO_NORMAL);
    pCmdUI->SetText(sText);
  	pCmdUI->Enable(FALSE);
  }
}


void CDibtestDoc::OnEditUndo() 
{
  CWaitCursor wait;
	if (m_Dib.Undo())
  {
    UpdateHistogramData();
    UpdateAllViews(NULL);
  }
  else
    AfxMessageBox(IDS_FAIL_UNDO);
}


void CDibtestDoc::OnUpdateEditUndo(CCmdUI* pCmdUI) 
{
  if (m_Dib.UndoAvailable())
  {
    CString sText;
    AfxFormatString1(sText, IDS_UNDO_DESCRIPTION, m_Dib.UndoDescription());
    pCmdUI->SetText(sText);
    pCmdUI->Enable(TRUE);
  }
  else
  {
    CString sText;
    sText.LoadString(IDS_UNDO_NORMAL);
    pCmdUI->SetText(sText);
  	pCmdUI->Enable(FALSE);
  }
}


void CDibtestDoc::OnColorNegative() 
{
  CWaitCursor wait;
  if (m_Dib.Negate())
  {
    UpdateHistogramData();
    SetModifiedFlag(TRUE);
    UpdateAllViews(NULL);
  }
  else
    AfxMessageBox(IDS_FAIL_NEGATIVE);
}


void CDibtestDoc::OnUpdateColorNegative(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}


void CDibtestDoc::OnEditCopy() 
{
  CWaitCursor wait;
  if (!m_Dib.CopyToClipboard())
    AfxMessageBox(IDS_FAIL_COPY);
}


void CDibtestDoc::OnEditPasteSelection() 
{
	CWaitCursor wait;
  m_Dib.SaveState(IDS_UNDO_PASTE);
  if (m_Dib.PasteFromClipboard())
  {
    UpdateHistogramData();
    SetModifiedFlag(TRUE);
    UpdateAllViews(NULL);
  }
  else
    m_Dib.Undo();
}


void CDibtestDoc::OnUpdateEditPasteSelection(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.PasteAvailable());
}


void CDibtestDoc::OnChannelSplit() 
{
  CApp* pApp = GetApp();
  CDibImage red;
  CDibImage green;
  CDibImage blue;
  CWaitCursor wait;
  if (m_Dib.SplitChannels(red, green, blue))
  {
    POSITION posTemplate = pApp->GetFirstDocTemplatePosition();
    CDocTemplate* pDocTemplate = pApp->GetNextDocTemplate(posTemplate);
    pApp->m_bNewFromPaste = TRUE;

    CDibtestDoc* pDocument = (CDibtestDoc*) pDocTemplate->OpenDocumentFile(NULL);
    pDocument->m_Dib = red;
    pDocument->UpdateHistogramData();
    pDocument->SetModifiedFlag(TRUE);
    CString sSplitCaption;
    AfxFormatString1(sSplitCaption, IDS_SPLIT_RED_CAPTION, GetTitle());
    pDocument->SetTitle(sSplitCaption);
    pDocument->UpdateAllViews(NULL);

    pDocument = (CDibtestDoc*) pDocTemplate->OpenDocumentFile(NULL);
    pDocument->m_Dib = green;
    pDocument->UpdateHistogramData();
    pDocument->SetModifiedFlag(TRUE);
    AfxFormatString1(sSplitCaption, IDS_SPLIT_GREEN_CAPTION, GetTitle());
    pDocument->SetTitle(sSplitCaption);
    pDocument->UpdateAllViews(NULL);

    pDocument = (CDibtestDoc*) pDocTemplate->OpenDocumentFile(NULL);
    pDocument->m_Dib = blue;
    pDocument->UpdateHistogramData();
    pDocument->SetModifiedFlag(TRUE);
    AfxFormatString1(sSplitCaption, IDS_SPLIT_BLUE_CAPTION, GetTitle());
    pDocument->SetTitle(sSplitCaption);
    pDocument->UpdateAllViews(NULL);

    pApp->m_bNewFromPaste = FALSE;
  }
  else
    AfxMessageBox(IDS_FAIL_SPLIT);
}


void CDibtestDoc::OnUpdateChannelSplit(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}


void CDibtestDoc::OnAdjustGreen() 
{
  COneValueDlg dlg;
  CString sCaption;
  sCaption.LoadString(IDS_ADJUST_GREEN);
  dlg.m_sCaption = sCaption;
  CString sPrompt;
  sPrompt.LoadString(IDS_ADJUST_GREEN_PERCENT);
  dlg.m_sPrompt = sPrompt;
  if (dlg.DoModal() == IDOK)
  {
    CWaitCursor wait;
    if (m_Dib.AdjustGreen(dlg.m_nValue))
    {
      UpdateHistogramData();
      SetModifiedFlag(TRUE);
      UpdateAllViews(NULL);
    }
    else
      AfxMessageBox(IDS_FAIL_ADJUST_GREEN);
  }
}


void CDibtestDoc::OnUpdateAdjustGreen(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}


void CDibtestDoc::OnAdjustBlue() 
{
  COneValueDlg dlg;
  CString sCaption;
  sCaption.LoadString(IDS_ADJUST_BLUE);
  dlg.m_sCaption = sCaption;
  CString sPrompt;
  sPrompt.LoadString(IDS_ADJUST_BLUE_PERCENT);
  dlg.m_sPrompt = sPrompt;
  if (dlg.DoModal() == IDOK)
  {
    CWaitCursor wait;
    if (m_Dib.AdjustBlue(dlg.m_nValue))
    {
      UpdateHistogramData();
      SetModifiedFlag(TRUE);
      UpdateAllViews(NULL);
    }
    else
      AfxMessageBox(IDS_FAIL_ADJUST_BLUE);
  }
}


void CDibtestDoc::OnUpdateAdjustBlue(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}


void CDibtestDoc::OnAdjustBrightness() 
{
  COneValueDlg dlg;
  CString sCaption;
  sCaption.LoadString(IDS_ADJUST_BRIGHTNESS);
  dlg.m_sCaption = sCaption;
  CString sPrompt;
  sPrompt.LoadString(IDS_ADJUST_BRIGHTNESS_PERCENT);
  dlg.m_sPrompt = sPrompt;
  if (dlg.DoModal() == IDOK)
  {
    CWaitCursor wait;
    if (m_Dib.AdjustBrightness(dlg.m_nValue))
    {
      UpdateHistogramData();
      SetModifiedFlag(TRUE);
      UpdateAllViews(NULL);
    }
    else
      AfxMessageBox(IDS_FAIL_ADJUST_BRIGHTNESS);
  }
}


void CDibtestDoc::OnUpdateAdjustBrightness(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}


void CDibtestDoc::OnUndoSize(UINT nID) 
{
  m_Dib.SetUndoSize(nID - ID_EDIT_UNDOSIZE_0);
}


void CDibtestDoc::OnUpdateUndoSize(CCmdUI* pCmdUI) 
{
  pCmdUI->SetCheck((pCmdUI->m_nID - ID_EDIT_UNDOSIZE_0) == (UINT) m_Dib.UndoSize());
}

void CDibtestDoc::OnImageFlip() 
{
  CWaitCursor wait;
  if (m_Dib.Flip())
  {
    UpdateHistogramData();
    SetModifiedFlag(TRUE);
    UpdateAllViews(NULL);
  }
  else
    AfxMessageBox(IDS_FAIL_ADJUST_FLIP);
}

void CDibtestDoc::OnUpdateImageFlip(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}


void CDibtestDoc::UpdateHistogramData()
{
  m_Dib.GetHistogram(m_RedChannel, 256, m_GreenChannel, 256, m_BlueChannel, 256);

  for (int i=0; i<256; i++)
  {
    if (m_RedChannel[i] > m_nMaxRed)
      m_nMaxRed = m_RedChannel[i];
    if (m_GreenChannel[i] > m_nMaxGreen)
      m_nMaxGreen = m_GreenChannel[i];
    if (m_BlueChannel[i] > m_nMaxBlue)
      m_nMaxBlue = m_BlueChannel[i];

    if (m_nMaxRed > m_nMaxColor)
      m_nMaxColor = m_nMaxRed;
    if (m_nMaxGreen > m_nMaxColor)
      m_nMaxColor = m_nMaxGreen;
    if (m_nMaxBlue > m_nMaxColor)
      m_nMaxColor = m_nMaxBlue;
  }
  GetMainFrame()->m_HistogramBar.Invalidate();
}

void CDibtestDoc::OnFilterUserdefined() 
{
  CUserFilterDlg dlg;
  if (dlg.DoModal() == IDOK)
  {
    CWaitCursor wait;
    C7By7Filter Filter = dlg.GetUserDefinedFilter();
    if (m_Dib.UserDefinedFilter(Filter))
    {
      UpdateHistogramData();
      SetModifiedFlag(TRUE);
      UpdateAllViews(NULL);
    }
    else
      AfxMessageBox(IDS_FAIL_FILTER);
  }
}

void CDibtestDoc::OnUpdateFilterUserdefined(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}

void CDibtestDoc::OnImageMirror() 
{
  CWaitCursor wait;
  if (m_Dib.Mirror())
  {
    UpdateHistogramData();
    SetModifiedFlag(TRUE);
    UpdateAllViews(NULL);
  }
  else
    AfxMessageBox(IDS_FAIL_ADJUST_MIRROR);
}

void CDibtestDoc::OnUpdateImageMirror(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}

void CDibtestDoc::OnAdjustGamma() 
{
  COneValueFloatDlg dlg;
  CString sCaption;
  sCaption.LoadString(IDS_ADJUST_GAMMA);
  dlg.m_sCaption = sCaption;
  CString sPrompt;
  sPrompt.LoadString(IDS_ADJUST_GAMMA_VALUE);
  dlg.m_sPrompt = sPrompt;
  if (dlg.DoModal() == IDOK)
  {
    CWaitCursor wait;
    if (m_Dib.AdjustGammaCorrection(dlg.m_Value))
    {
      UpdateHistogramData();
      SetModifiedFlag(TRUE);
      UpdateAllViews(NULL);
    }
    else
      AfxMessageBox(IDS_FAIL_ADJUST_GAMMA);
  }
}

void CDibtestDoc::OnUpdateAdjustGamma(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}

void CDibtestDoc::OnAdjustContrast() 
{
  COneValueDlg dlg;
  CString sCaption;
  sCaption.LoadString(IDS_ADJUST_CONTRAST);
  dlg.m_sCaption = sCaption;
  CString sPrompt;
  sPrompt.LoadString(IDS_ADJUST_CONTRAST_PERCENT);
  dlg.m_sPrompt = sPrompt;
  if (dlg.DoModal() == IDOK)
  {
    CWaitCursor wait;
    if (m_Dib.AdjustContrast(dlg.m_nValue))
    {
      UpdateHistogramData();
      SetModifiedFlag(TRUE);
      UpdateAllViews(NULL);
    }
    else
      AfxMessageBox(IDS_FAIL_ADJUST_CONTRAST);
  }
}

void CDibtestDoc::OnUpdateAdjustContrast(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}

void CDibtestDoc::OnAdjustMidtone() 
{
  COneValueDlg dlg;
  CString sCaption;
  sCaption.LoadString(IDS_ADJUST_MIDTONE);
  dlg.m_sCaption = sCaption;
  CString sPrompt;
  sPrompt.LoadString(IDS_ADJUST_MIDTONE_PERCENT);
  dlg.m_sPrompt = sPrompt;
  if (dlg.DoModal() == IDOK)
  {
    CWaitCursor wait;
    if (m_Dib.AdjustMidtone(dlg.m_nValue))
    {
      UpdateHistogramData();
      SetModifiedFlag(TRUE);
      UpdateAllViews(NULL);
    }
    else
      AfxMessageBox(IDS_FAIL_ADJUST_MIDTONE);
  }
}

void CDibtestDoc::OnUpdateAdjustMidtone(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}

void CDibtestDoc::OnFilterFindEdges() 
{
  CWaitCursor wait;
  if (m_Dib.FindEdgesFilter())
  {
    UpdateHistogramData();
    SetModifiedFlag(TRUE);
    UpdateAllViews(NULL);
  }
  else
    AfxMessageBox(IDS_FAIL_FIND_EDGES);
}

void CDibtestDoc::OnUpdateFilterFindEdges(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}

void CDibtestDoc::OnFilterBlur() 
{
  CWaitCursor wait;
  if (m_Dib.BlurFilter())
  {
    UpdateHistogramData();
    SetModifiedFlag(TRUE);
    UpdateAllViews(NULL);
  }
  else
    AfxMessageBox(IDS_FAIL_BLUR);
}

void CDibtestDoc::OnUpdateFilterBlur(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}

void CDibtestDoc::OnAdjustSaturation() 
{
  COneValueDlg dlg;
  CString sCaption;
  sCaption.LoadString(IDS_ADJUST_SATURATION);
  dlg.m_sCaption = sCaption;
  CString sPrompt;
  sPrompt.LoadString(IDS_ADJUST_SATURATION_PERCENT);
  dlg.m_sPrompt = sPrompt;
  if (dlg.DoModal() == IDOK)
  {
    CWaitCursor wait;
    if (m_Dib.AdjustSaturation(dlg.m_nValue))
    {
      UpdateHistogramData();
      SetModifiedFlag(TRUE);
      UpdateAllViews(NULL);
    }
    else
      AfxMessageBox(IDS_FAIL_ADJUST_SATURATION);
  }
}

void CDibtestDoc::OnUpdateAdjustSaturation(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}

void CDibtestDoc::OnAdjustHue() 
{
  COneValueDlg dlg;
  CString sCaption;
  sCaption.LoadString(IDS_ADJUST_HUE);
  dlg.m_sCaption = sCaption;
  CString sPrompt;
  sPrompt.LoadString(IDS_ADJUST_HUE_PERCENT);
  dlg.m_sPrompt = sPrompt;
  if (dlg.DoModal() == IDOK)
  {
    CWaitCursor wait;
    if (m_Dib.AdjustHue(dlg.m_nValue))
    {
      UpdateHistogramData();
      SetModifiedFlag(TRUE);
      UpdateAllViews(NULL);
    }
    else
      AfxMessageBox(IDS_FAIL_ADJUST_HUE);
  }
}

void CDibtestDoc::OnUpdateAdjustHue(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}



void CDibtestDoc::OnFilterAddNoise() 
{
  COneValueDlg dlg;
  CString sCaption;
  sCaption.LoadString(IDS_ADD_NOISE);
  dlg.m_sCaption = sCaption;
  CString sPrompt;
  sPrompt.LoadString(IDS_ADD_NOISE_PERCENT);
  dlg.m_sPrompt = sPrompt;
  if (dlg.DoModal() == IDOK)
  {
    CWaitCursor wait;
    if (m_Dib.AddNoiseFilter(dlg.m_nValue))
    {
      UpdateHistogramData();
      SetModifiedFlag(TRUE);
      UpdateAllViews(NULL);
    }
    else
      AfxMessageBox(IDS_FAIL_NOISE);
  }
}

void CDibtestDoc::OnUpdateFilterAddNoise(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}



void CDibtestDoc::OnFilterFindHorizontalEdges() 
{
  CWaitCursor wait;
  if (m_Dib.FindHorizontalEdgesFilter())
  {
    UpdateHistogramData();
    SetModifiedFlag(TRUE);
    UpdateAllViews(NULL);
  }
  else
    AfxMessageBox(IDS_FAIL_FIND_HORIZONTAL_EDGES);
}

void CDibtestDoc::OnUpdateFilterFindHorizontalEdges(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);	
}

void CDibtestDoc::OnFilterFindVerticalEdges() 
{
  CWaitCursor wait;
  if (m_Dib.FindVerticalEdgesFilter())
  {
    UpdateHistogramData();
    SetModifiedFlag(TRUE);
    UpdateAllViews(NULL);
  }
  else
    AfxMessageBox(IDS_FAIL_FIND_VERTICAL_EDGES);
}

void CDibtestDoc::OnUpdateFilterFindVerticalEdges(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}

void CDibtestDoc::OnFilterMedian() 
{
  CWaitCursor wait;
  if (m_Dib.MedianFilter())
  {
    UpdateHistogramData();
    SetModifiedFlag(TRUE);
    UpdateAllViews(NULL);
  }
  else
    AfxMessageBox(IDS_FAIL_MEDIAN_FILTER);
}

void CDibtestDoc::OnUpdateFilterMedian(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}

void CDibtestDoc::OnAdjustHighlight() 
{
  COneValueDlg dlg;
  CString sCaption;
  sCaption.LoadString(IDS_ADJUST_HIGHLIGHT);
  dlg.m_sCaption = sCaption;
  CString sPrompt;
  sPrompt.LoadString(IDS_ADJUST_HIGHLIGHT_PERCENT);
  dlg.m_sPrompt = sPrompt;
  if (dlg.DoModal() == IDOK)
  {
    CWaitCursor wait;
    if (m_Dib.AdjustHighLight(dlg.m_nValue))
    {
      UpdateHistogramData();
      SetModifiedFlag(TRUE);
      UpdateAllViews(NULL);
    }
    else
      AfxMessageBox(IDS_FAIL_ADJUST_HIGHLIGHT);
  }
}

void CDibtestDoc::OnUpdateAdjustHighlight(CCmdUI* pCmdUI) 
{
  pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}

void CDibtestDoc::OnAdjustShadow() 
{
  COneValueDlg dlg;
  CString sCaption;
  sCaption.LoadString(IDS_ADJUST_SHADOW);
  dlg.m_sCaption = sCaption;
  CString sPrompt;
  sPrompt.LoadString(IDS_ADJUST_SHADOW_PERCENT);
  dlg.m_sPrompt = sPrompt;
  if (dlg.DoModal() == IDOK)
  {
    CWaitCursor wait;
    if (m_Dib.AdjustShadow(dlg.m_nValue))
    {
      UpdateHistogramData();
      SetModifiedFlag(TRUE);
      UpdateAllViews(NULL);
    }
    else
      AfxMessageBox(IDS_FAIL_ADJUST_SHADOW);
  }
}

void CDibtestDoc::OnUpdateAdjustShadow(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Dib.BitsPerPixel() == 24);
}
