#ifndef __MAINFRM_H__
#define __MAINFRM_H__

#include "colorpalette.h"
#include "histogram.h"



enum ToolOption
{
  Magnify,
  RectangleSelection,
  ColorDropper,
};


class CMainFrame : public CMDIFrameWnd
{
	DECLARE_DYNAMIC(CMainFrame)
public:
	CMainFrame();

	//{{AFX_VIRTUAL(CMainFrame)
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

  ToolOption    m_ToolOption;
  CHistogramPalette m_HistogramBar;
  CColorPalette m_PaletteBar;



protected:  // control bar embedded members
	CStatusBar    m_wndStatusBar;
	CToolBar      m_wndToolBar;
  CToolBar      m_wndToolBar2;
  BOOL          m_bIsFullScreen;
  CMenu         m_Menu;
  BOOL          m_bHistogramVisible;
  BOOL          m_bPaletteVisible;
  BOOL          m_bToolbarVisible;
  BOOL          m_bToolbar2Visible;
  BOOL          m_bStatusbarVisible;


	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnPaletteChanged(CWnd* pFocusWnd);
	afx_msg BOOL OnQueryNewPalette();
	afx_msg void OnViewFullscreen();
	afx_msg void OnImageColordropper();
	afx_msg void OnUpdateImageColordropper(CCmdUI* pCmdUI);
	afx_msg void OnImageSelect();
	afx_msg void OnUpdateImageSelect(CCmdUI* pCmdUI);
	afx_msg void OnViewZoom();
	afx_msg void OnUpdateViewZoom(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif //__MAINFRM_H__
