#include "stdafx.h"
#include "app.h"
#include "CombineDlg.h"
#include "doc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CCombineDlg::CCombineDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCombineDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCombineDlg)
	//}}AFX_DATA_INIT

  m_pRedImage = NULL;
  m_pGreenImage = NULL;
  m_pBlueImage = NULL;
}


void CCombineDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCombineDlg)
	DDX_Control(pDX, IDC_RED_CHANNEL, m_ctrlRedChannel);
	DDX_Control(pDX, IDC_GREEN_CHANNEL, m_ctrlGreenChannel);
	DDX_Control(pDX, IDC_BLUE_CHANNEL, m_ctrlBlueChannel);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCombineDlg, CDialog)
	//{{AFX_MSG_MAP(CCombineDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CCombineDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
  POSITION posTemplate = AfxGetApp()->GetFirstDocTemplatePosition();
  while (posTemplate != NULL) 
  {
    CDocTemplate* pTemplate = AfxGetApp()->GetNextDocTemplate(posTemplate);
    ASSERT(pTemplate->IsKindOf(RUNTIME_CLASS(CDocTemplate)));
    POSITION posDoc = pTemplate->GetFirstDocPosition();
    while (posDoc != NULL) 
    {
      CDibtestDoc* pDoc = (CDibtestDoc*) pTemplate->GetNextDoc(posDoc);
      ASSERT(pDoc->IsKindOf(RUNTIME_CLASS(CDibtestDoc)));
      m_ctrlRedChannel.AddString(pDoc->GetTitle());
      m_ctrlRedChannel.SetItemData(m_ctrlRedChannel.GetCount()-1, (DWORD) pDoc);
      m_ctrlGreenChannel.AddString(pDoc->GetTitle());
      m_ctrlGreenChannel.SetItemData(m_ctrlGreenChannel.GetCount()-1, (DWORD) pDoc);
      m_ctrlBlueChannel.AddString(pDoc->GetTitle());
      m_ctrlBlueChannel.SetItemData(m_ctrlBlueChannel.GetCount()-1, (DWORD) pDoc);
    }
  }

  m_ctrlRedChannel.SetCurSel(0);
  m_ctrlGreenChannel.SetCurSel(0);
  m_ctrlBlueChannel.SetCurSel(0);
	
	return TRUE;
}

void CCombineDlg::OnOK() 
{
  CDibtestDoc* pRedDoc = (CDibtestDoc*) m_ctrlRedChannel.GetItemData(m_ctrlRedChannel.GetCurSel());
	m_pRedImage = &pRedDoc->m_Dib;

  CDibtestDoc* pGreenDoc = (CDibtestDoc*) m_ctrlGreenChannel.GetItemData(m_ctrlGreenChannel.GetCurSel());
	m_pGreenImage = &pGreenDoc->m_Dib;

  CDibtestDoc* pBlueDoc = (CDibtestDoc*) m_ctrlBlueChannel.GetItemData(m_ctrlBlueChannel.GetCurSel());
	m_pBlueImage = &pBlueDoc->m_Dib;

	CDialog::OnOK();
}
