/*
 * Project ReD DynDNS
 * dundns.java -- static and dynamic dyndns updater
 * Copyright (C) 1998 Filip Pizlo
 * This is under GPL/2.0
 * Read the README first!
 */

import java.io.*;
import java.net.*;

public class dyndns extends Thread {
 //static
  public static void main(String[] v) {
   dyndns blow=new dyndns(v[0],v[1],v[2]);
   blow.start();
  }
 //dynamic
  logbase log;
  String login,password,hostname;
  public dyndns(String login,String password,String hostname,logbase _log) {
   System.out.println("DynDNS/Red/0.0.3 Enabled\nDunDNS: Base64 routines originally written in C; (C)1997,1998 Artur Skawina");
   this.login=login;
   this.password=password;
   this.hostname=hostname;
   log=_log;
  }
  public dyndns(String login,String password,String hostname) {
   this(login,password,hostname,null);
  }
  public dyndns() {
   log=null;
  }
  public void run() {
   try {
//    URL nic=new URL("http://"+login+":"+password+"@members.ml.org/mis-bin/ms3/nic/dyndns?command=Update+Host&domain="+hostname+"act=act&do=mod&agree=agree");
    Socket sock=new Socket("members.ml.org",80);
    PrintStream fout=new PrintStream(sock.getOutputStream());
    BufferedReader fin=new BufferedReader(new InputStreamReader(sock.getInputStream()));
    fout.println("GET /mis-bin/ms3/nic/dyndns?command=Update+Host&domain="+hostname+"&act=act&do=mod&agree=agree HTTP/1.0");
    fout.println("Host: members.ml.org:80");
    fout.println("Authorization: Basic "+base64.enc(login+":"+password));
    fout.println("");
    if (log==null) {
     while (true) {
      String tmp=fin.readLine();
      if (tmp==null) break;
      System.out.println(tmp);
     }
    } else {
     while (true) {
      String tmp=fin.readLine();
      if (tmp==null) break;
      log.write_objlog(this,"response: "+tmp);
     }
    }
    fin.close();
   } catch (Throwable e) {
    try {
     log.write_objlog(this,"Error: "+e);
    } catch (Throwable e2) {
     System.err.println("Error: "+e);
    }
   }
   System.out.println("DynDNS: updated; as much as 10 minutes may pass before it takes effect.");
  }
}


