/*
 * Project ReD Visual Setup Proggie
 * vissetup.java -- static setup script
 * Copyright (C) 1997 Filip Pizlo
 * This code is protected by GPL/2.0
 * Read the README first!
 */

import java.io.*;
import java.util.*;
import java.net.*;
import java.awt.*;

public class vissetup extends Frame implements Runnable {
 //static
  static String lsep;
  public static void main(String[] v) {
   System.out.println("\n\nProject ReD Visual Setup\nIf this doesn't work, you are screwed\n\n");
   vissetup blow=new vissetup();
   blow.show();
  }
  public static void txtdownload(File local,URL ctx,String remote) throws Exception {
   PrintStream fout=new PrintStream(new FileOutputStream(local));
   URL udl=new URL(ctx,remote);
   DataInputStream fin=new DataInputStream(udl.openStream());
   while (true) {
    String tmp=fin.readLine();
    if (tmp==null) break;
    fout.print(tmp+lsep);
   }
   fout.close();
   fin.close();
  }
 //dynamic
  Panel main,nbar,pbar,p6cbr,p7jsdr,p7jpyn,p9stat,p12corr,p15st[];
  Button next,prev,quit,finish;
  CardLayout mainc,nbarc,pbarc,p6cbrc,p9statc,p12corrc,p15stc[];
  int page,ppage;
  Thread dostuff;
  Checkbox corr,incr,unix,windows,other,syes,sno,pyes,pno,corr2,incr2;
  CheckboxGroup corrc,osc,jsc,jpc,corr2c;
  boolean ufound;
  long lver,rver;
  URL ctx;
  TextField cpf,jvf,svf,osf,jhf,vmf,jh2f;
  TextField cpef,jsdkf,jvmf;
  String classpath="",dclasspath="",ddclasspath="",dd2classpath,javahome="",javabin="";
  boolean jdkgood=false,jsdkgood=false,allgood=false;
  int os=-1;
  Properties sysprops=null;
  public vissetup() {
   super("Project ReD Visual Setup");
   setFont(new Font("Serif",Font.PLAIN,14));
   setForeground(Color.black);
   setBackground(Color.lightGray);
   sysprops=System.getProperties();
   try {
    lsep=sysprops.getProperty("line.separator");
   } catch (Throwable e) {
    lsep="\r\n";
   }
   page=0;
   ppage=0;
   setLayout(new BorderLayout());
   mainc=new CardLayout();
   main=new Panel(mainc);
   next=new Button("Next >>");
   prev=new Button("<< Previous");
   quit=new Button("Quit!");
   finish=new Button("Finish!");
   nbarc=new CardLayout();
   nbar=new Panel(nbarc);
   pbarc=new CardLayout();
   pbar=new Panel(pbarc);
   Panel nb1=new Panel();
   nb1.add(next);
   Panel nb2=new Panel();
   nb2.add(finish);
   Panel pb1=new Panel();
   Panel pb2=new Panel();
   pb2.add(prev);
   nbar.add("one",nb1);
   nbar.add("two",nb2);
   pbar.add("one",pb1);
   pbar.add("two",pb2);
   Panel msbar=new Panel();
   Panel npbar=new Panel();
   npbar.add(pbar);
   npbar.add(nbar);
   Panel qbar=new Panel();
   qbar.add(quit);
   msbar.add(npbar);
   msbar.add(qbar);
   Panel page1=new Panel();
   Panel p1txt1=new Panel(new GridLayout(3,1));
   p1txt1.add(new Label("This program will identify what type of system you have,"));
   p1txt1.add(new Label("and attempt to create a script that you can use to run Red."));
   page1.add(p1txt1);
   Panel p1txt2=new Panel(new GridLayout(3,1));
   p1txt2.add(new Label("If you would like to continue, click on \"Next\""));
   p1txt2.add(new Label("Otherwise, click \"Quit\""));
   page1.add(p1txt2);
   main.add("one",page1);
   Panel page6=new Panel();
   Panel p6txt1=new Panel(new GridLayout(3,1));
   p6txt1.add(new Label("Now finding out about your system.  Stats will be available"));
   p6txt1.add(new Label("below."));
   page6.add(p6txt1);
   Panel p6sts=new Panel(new GridLayout(4,1));
   Panel p6st1=new Panel();
   p6st1.add("West",new Label("Classpath:"));
   cpf=new TextField("checking...",50);
   cpf.setEditable(false);
   p6st1.add("Center",(new Panel()).add(cpf));
   p6sts.add(p6st1);
   Panel p6st2=new Panel();
   p6st2.add("West",new Label("JDK Version:"));
   jvf=new TextField("checking...",50);
   jvf.setEditable(false);
   p6st2.add("Center",(new Panel()).add(jvf));
   p6sts.add(p6st2);
   Panel p6st3=new Panel();
   p6st3.add("West",new Label("JSDK Version:"));
   svf=new TextField("checking...",50);
   svf.setEditable(false);
   p6st3.add("Center",(new Panel()).add(svf));
   p6sts.add(p6st3);
   Panel p6st4=new Panel();
   p6st4.add("West",new Label("Platform:"));
   osf=new TextField("checking...",50);
   osf.setEditable(false);
   p6st4.add("Center",(new Panel()).add(osf));
   p6sts.add(p6st4);
   page6.add(p6sts);
   Panel p6cor=new Panel();
   p6cor.add(new Label("Is this correct?"));
   corrc=new CheckboxGroup();
   corr=new Checkbox("Yes, continue",true,corrc);
   incr=new Checkbox("No, I'll edit it",false,corrc);
   p6cor.add(corr);
   p6cor.add(incr);
   p6cbrc=new CardLayout();
   p6cbr=new Panel(p6cbrc);
   p6cbr.add("default",new Panel());
   p6cbr.add("check",p6cor);
   p6cbr.add("error",new Label("Errors while checking.  Cannot continue",Label.CENTER));
   page6.add(p6cbr);
   main.add("six",page6);
   Panel page7=new Panel();
   Panel p7txt1=new Panel(new GridLayout(2,1));
   p7txt1.add(new Label("You have chosen to edit your setup.  Here you go!"));
   page7.add(p7txt1);
   Panel p7cpe=new Panel();
   p7cpe.add(new Label("Classpath:"));
   cpef=new TextField("",50);
   p7cpe.add(cpef);
   page7.add(p7cpe);
   Panel p7js=new Panel(new BorderLayout());
   Panel p7jsynbb=new Panel(new GridLayout(2,1));
   Panel p7jsyn=new Panel();
   p7jsyn.add(new Label("Do you have JSDK 1.0?"));
   jsc=new CheckboxGroup();
   syes=new Checkbox("Yes",false,jsc);
   sno=new Checkbox("No",true,jsc);
   Panel p7jsynb=new Panel();
   p7jsynb.add(syes);
   p7jsynb.add(sno);
   p7jsyn.add(p7jsynb);
   p7jpyn=new Panel();
   p7jpyn.add(new Label("Is JSDK already in the classpath?"));
   jpc=new CheckboxGroup();
   pyes=new Checkbox("Yes",false,jpc);
   pno=new Checkbox("No",true,jpc);
   p7jpyn.add(pyes);
   p7jpyn.add(pno);
   p7jsynbb.add(p7jsyn);
   p7jsynbb.add(p7jpyn);
   p7js.add("North",p7jsynbb);
   p7jsdr=new Panel();
   p7jsdr.add(new Label("JSDK Path:"));
   jsdkf=new TextField("C:\\JSDK\\",50);
   p7jsdr.add(jsdkf);
   p7jsdr.disable();
   p7js.add("Center",p7jsdr);
   page7.add(p7js);
   Panel p7os=new Panel(new BorderLayout());
   p7os.add("West",new Label("What platform are you on?"));
   osc=new CheckboxGroup();
   unix=new Checkbox("UNIX",true,osc);
   windows=new Checkbox("Win32",false,osc);
   other=new Checkbox("Other",false,osc);
   Panel p7osb=new Panel();
   p7osb.add(unix);
   p7osb.add(windows);
   p7osb.add(other);
   p7os.add("Center",p7osb);
   page7.add(p7os);
   main.add("seven",page7);
   Panel page8=new Panel();
   Panel p8txt1=new Panel(new GridLayout(5,1));
   p8txt1.add(new Label("Since your system does not have JSDK, Red's servlet"));
   p8txt1.add(new Label("capabilities will have to be disabled.  This is going to"));
   p8txt1.add(new Label("be done by downloading an alternative configuration"));
   p8txt1.add(new Label("script."));
   page8.add(p8txt1);
   Panel p8txt2=new Panel(new GridLayout(3,1));
   p8txt2.add(new Label("Click on \"Next\" to continue."));
   p8txt2.add(new Label("Click on \"Quit\" not to."));
   page8.add(p8txt2);
   main.add("eight",page8);
   Panel page9=new Panel();
   Panel p9txt1=new Panel(new GridLayout(3,1));
   p9txt1.add(new Label("Now downloading the alternative config script to disable"));
   p9txt1.add(new Label("servlet support."));
   page9.add(p9txt1);
   p9statc=new CardLayout();
   p9stat=new Panel(p9statc);
   p9stat.add("default",new Panel());
   p9stat.add("dling",new Label("Downloading config"));
   p9stat.add("dlerr",new Label("Error downloading config"));
   p9stat.add("dled",new Label("config downloaded."));
   page9.add(p9stat);
   main.add("nine",page9);
   Panel page10=new Panel();
   Panel p10txt1=new Panel(new GridLayout(8,1));
   p10txt1.add(new Label("This program is not capable of setting up Red on platfroms"));
   p10txt1.add(new Label("other than UNIX or Win32."));
   p10txt1.add(new Label(""));
   p10txt1.add(new Label("Fortunetly, running Red manually is not that hard.  Be sure"));
   p10txt1.add(new Label("to specify a classpath which includes java.* classes,"));
   p10txt1.add(new Label("javax.servlet.* classes (if you said you have JSDK), and"));
   p10txt1.add(new Label("redstart.zip in this directory.  The class you want to run is"));
   p10txt1.add(new Label("called \"start\".  Have fun!"));
   page10.add(p10txt1);
   main.add("ten",page10);
   Panel page11=new Panel();
   Panel p11txt1=new Panel(new GridLayout(3,1));
   p11txt1.add(new Label("Now that everything else has been settled, this program will"));
   p11txt1.add(new Label("attempt to find out how to run Java on your computer."));
   page11.add(p11txt1);
   Panel p11txt2=new Panel(new GridLayout(2,1));
   p11txt2.add(new Label("Click on \"Next\" if you want to continue."));
   p11txt2.add(new Label("Otherwise, click on \"Quit\""));
   page11.add(p11txt2);
   main.add("eleven",page11);
   Panel page12=new Panel();
   Panel p12txt1=new Panel(new GridLayout(3,1));
   p12txt1.add(new Label("Now searching for the main Java VM binary in all likely"));
   p12txt1.add(new Label("places.  Please wait..."));
   page12.add(p12txt1);
   Panel p12stat=new Panel(new GridLayout(4,1));
   Panel p12cjh=new Panel();
   p12cjh.add(new Label("Java Home:"));
   jhf=new TextField("checking...",50);
   jhf.setEditable(false);
   p12cjh.add(jhf);
   p12stat.add(p12cjh);
   Panel p12cvm=new Panel();
   p12cvm.add(new Label("Java VM:"));
   vmf=new TextField("checking...",50);
   vmf.setEditable(false);
   p12cvm.add(vmf);
   p12stat.add(p12cvm);
   p12stat.add(new Panel());
   p12corrc=new CardLayout();
   p12corr=new Panel(p12corrc);
   p12corr.add("default",new Panel());
   p12corr.add("error",new Label("A fatal error occured while searching for the VM.  Click Finish."));
   p12corr.add("bad",new Label("Could not find the Java VM.  Click \"Next\""));
   Panel p12cryn=new Panel();
   p12cryn.add(new Label("Is this correct?"));
   corr2c=new CheckboxGroup();
   corr2=new Checkbox("Yes, this is fine.",true,corr2c);
   incr2=new Checkbox("No, I'll edit it.",false,corr2c);
   p12cryn.add(corr2);
   p12cryn.add(incr2);
   p12corr.add("ok",p12cryn);
   p12stat.add(p12corr);
   page12.add(p12stat);
   main.add("twelve",page12);
   Panel page13=new Panel();
   Panel p13txt1=new Panel(new GridLayout(6,1));
   p13txt1.add(new Label("You have chosen (or you have been forced to) manually select"));
   p13txt1.add(new Label("the location of the Java VM binary.  This will most likely"));
   p13txt1.add(new Label("be in the \"bin\" directory off of the Java directory.  The"));
   p13txt1.add(new Label("filename is usually something like \"java.exe\" (in Windos)"));
   p13txt1.add(new Label("or \"java\" (in UNIX).  Type in the path and click \"Next\"."));
   page13.add(p13txt1);
   Panel p13inpt=new Panel(new GridLayout(2,1));
   Panel p13jh=new Panel();
   p13jh.add(new Label("Known Java Home:"));
   jh2f=new TextField("unknown",40);
   jh2f.setEditable(false);
   p13jh.add(jh2f);
   p13inpt.add(p13jh);
   Panel p13vm=new Panel();
   p13vm.add(new Label("VM Location:"));
   jvmf=new TextField("",40);
   p13vm.add(jvmf);
   p13inpt.add(p13vm);
   page13.add(p13inpt);
   main.add("thirteen",page13);
   Panel page14=new Panel();
   Panel p14txt1=new Panel(new GridLayout(5,1));
   p14txt1.add(new Label("Almost done!  Now that all of the information is gathered,"));
   p14txt1.add(new Label("and all problems hopefully solved, this program will create"));
   p14txt1.add(new Label("batch files and shell scripts to help you run Red and its"));
   p14txt1.add(new Label("components."));
   page14.add(p14txt1);
   Panel p14txt2=new Panel(new GridLayout(2,1));
   p14txt2.add(new Label("Click on \"Next\" if you want to continue."));
   p14txt2.add(new Label("Otherwise, click \"Quit\""));
   page14.add(p14txt2);
   main.add("fourteen",page14);
   Panel page15=new Panel();
   Panel p15txt1=new Panel(new GridLayout(3,1));
   p15txt1.add(new Label("Congradulations!  You have made it this far!  Now writing"));
   p15txt1.add(new Label("a script..."));
   page15.add(p15txt1);
   Panel p15stat=new Panel(new GridLayout(4,1));
   p15st=new Panel[4];
   p15stc=new CardLayout[4];
   for (int i=0;i<4;i++) {
    p15stc[i]=new CardLayout();
    p15st[i]=new Panel(p15stc[i]);
    p15st[i].add("default",new Panel());
   }
   p15st[0].add("work",new Label("Creating scripts"));
   p15st[0].add("done",new Label("Scripts created."));
   p15st[0].add("error",new Label("Error creating scripts!"));
   p15st[1].add("workunix",new Label("Writing starter script to \"red\""));
   p15st[1].add("work2unix",new Label("\"red\" written; Writing config script to \"redconfig\""));
   p15st[1].add("doneunix",new Label("Scripts written."));
   p15st[1].add("workwin",new Label("Writing starter script to \"red.bat\""));
   p15st[1].add("work2win",new Label("\"red.bat\" written; Writing config script to \"config.bar\""));
   p15st[1].add("donewin",new Label("Scripts written."));
   p15st[1].add("error",new Label("Error writing scripts!"));
   p15st[2].add("work",new Label("Setting modes on \"red\""));
   p15st[2].add("work2",new Label("Setting modes on \"config\""));
   p15st[2].add("done",new Label("Modes set."));
   p15st[2].add("error",new Label("Error setting modes!"));
   p15st[2].add("alldone",new Label("All done!  Click \"Finish\"",Label.CENTER));
   p15st[2].add("allerror",new Label("Done with errors.  Click \"Finish\".",Label.CENTER));
   p15st[3].add("alldone",new Label("All done!  Click \"Finish\"",Label.CENTER));
   p15st[3].add("allerror",new Label("Done with errors.  Click \"Finish\".",Label.CENTER));
   for (int i=0;i<4;i++) p15stat.add(p15st[i]);
   page15.add(p15stat);
   main.add("fifteen",page15);
   add("Center",main);
   add("South",msbar);
   resize(500,400);
   try {
    ctx=new URL(distro.SOURCEURL);
   } catch (Throwable e) {}
  }
  public void run() {
   switch (page) {
    case 5:
     if (ppage==6) editstats();
     else checkstats();
     break;
    case 6:
     setupedit();
     break;
    case 8:
     dlconfig();
     break;
    case 9:
     nbarc.show(nbar,"two");
     break;
    case 11:
     if (ppage==12) editvm();
     else checkvm();
     break;
    case 12:
     setupedvm();
     break;
    case 14:
     writeee();
     break;
    default:
     break;
   }
  }
  void writeee() {
   next.disable();
   prev.disable();
   finish.disable();
   nbarc.show(nbar,"two");
   ddclasspath="redstart.zip"+File.pathSeparator+dclasspath;
   dd2classpath="redconfig.zip"+File.pathSeparator+dclasspath;
   String red,config;
   if (os==1) {
    p15stc[0].show(p15st[0],"work");
    try {
     red="#!/bin/sh\n# Generated by vissetup.class\necho \"Running Red!\"\ncd "+sysprops.getProperty("user.dir")+"\n\""+javabin+"\" -classpath \""+ddclasspath+"\" start $*\n";
     config="#!/bin/sh\n# Generated by vissetup.class\necho \"Running the Red Configuration\"\ncd "+sysprops.getProperty("user.dir")+"\n\""+javabin+"\" -classpath \""+dd2classpath+"\" visconfig $*\n";
    } catch (Throwable e) {
     p15stc[0].show(p15st[0],"error");
     p15stc[3].show(p15st[3],"allerror");
     System.err.println("Error "+e);
     finish.enable();
     return;
    }
    p15stc[0].show(p15st[0],"done");
    p15stc[1].show(p15st[1],"workunix");
    try {
     PrintStream fout=new PrintStream(new FileOutputStream("red"));
     fout.println(red);
     fout.close();
     p15stc[1].show(p15st[1],"work2unix");
     fout=new PrintStream(new FileOutputStream("redconfig"));
     fout.println(config);
     fout.close();
    } catch (Throwable e) {
     p15stc[1].show(p15st[1],"error");
     p15stc[3].show(p15st[3],"allerror");
     System.err.println("Error "+e);
     finish.enable();
     return;
    }
    p15stc[1].show(p15st[1],"doneunix");
    p15stc[2].show(p15st[2],"work");
    try {
     Runtime run=Runtime.getRuntime();
     String[] cmd=new String[3];
     cmd[0]="/bin/chmod";
     cmd[1]="u+x";
     cmd[2]="red";
     run.exec(cmd);
     p15stc[2].show(p15st[2],"work2");
     cmd[2]="redconfig";
     run.exec(cmd);
    } catch (Throwable e) {
     p15stc[2].show(p15st[2],"error");
     p15stc[3].show(p15st[3],"allerror");
     System.err.println("Error "+e);
     finish.enable();
     return;
    }
    p15stc[2].show(p15st[2],"done");
    p15stc[3].show(p15st[3],"alldone");
   } else {
    p15stc[0].show(p15st[0],"work");
    try {
     red="@echo off\r\nrem Generated by vissetup.class\r\necho Running Red\r\n"+sysprops.getProperty("user.dir").substring(0,2)+"\r\ncd "+sysprops.getProperty("user.dir")+"\r\n\""+javabin+"\" -classpath \""+ddclasspath+"\" start %1 %2 %3 %4 %5\r\n";
     config="@echo off\r\nrem Generated by vissetup.class\r\necho Running the Red Configuration\r\n"+sysprops.getProperty("user.dir").substring(0,2)+"\r\ncd "+sysprops.getProperty("user.dir")+"\r\n\""+javabin+"\" -classpath \""+dd2classpath+"\" visconfig %1 %2 %3 %4 %5\r\n";
    } catch (Throwable e) {
     p15stc[0].show(p15st[0],"error");
     p15stc[2].show(p15st[2],"allerror");
     System.err.println("Error "+e);
     finish.enable();
     return;
    }
    p15stc[0].show(p15st[0],"done");
    p15stc[1].show(p15st[1],"workwin");
    try {
     PrintStream fout=new PrintStream(new FileOutputStream("red.bat"));
     fout.println(red);
     fout.close();
     p15stc[1].show(p15st[1],"work2win");
     fout=new PrintStream(new FileOutputStream("config.bat"));
     fout.println(config);
     fout.close();
    } catch (Throwable e) {
     p15stc[1].show(p15st[1],"error");
     p15stc[2].show(p15st[2],"allerror");
     System.err.println("Error "+e);
     finish.enable();
     return;
    }
    p15stc[1].show(p15st[1],"donewin");
    p15stc[2].show(p15st[2],"alldone");
   }
   finish.enable();
   prev.enable();
  }
  void setupedvm() {
   jh2f.setText(javahome);
   jvmf.setText(javabin);
  }
  void editvm() {
   next.disable();
   prev.disable();
   corr2c.setCurrent(corr2);
   javabin=jvmf.getText();
   vmf.setText(javabin);
   p12corrc.show(p12corr,"ok");
   next.enable();
   prev.enable();
  }
  void checkvm() {
   next.disable();
   prev.disable();
   try {
    javahome=sysprops.getProperty("java.home");
    if (javahome==null) throw new Exception("No java.home!");
    jhf.setText(javahome);
   } catch (Throwable e) {
    System.err.println("Error in checking: "+e);
    jhf.setText("Error!");
    allgood=false;
    p12corrc.show(p12corr,"error");
    nbarc.show(nbar,"two");
    return;
   }
   if (os==1) {
    javabin=javahome+"/bin/java";
    vmf.setText(javabin);
    File tmp=new File(javabin);
    if (!tmp.exists()) {
     javabin=javahome+"/bin/jre";
     vmf.setText(javabin);
     tmp=new File(javabin);
     if (!tmp.exists()) {
      javabin="";
      vmf.setText("Not found");
      p12corrc.show(p12corr,"bad");
     }
    }
   } else {
    javabin=javahome+"\\bin\\java.exe";
    vmf.setText(javabin);
    File tmp=new File(javabin);
    if (!tmp.exists()) {
     javabin=javahome+"\\bin\\jre.exe";
     vmf.setText(javabin);
     tmp=new File(javabin);
     if (!tmp.exists()) {
      javabin="";
      vmf.setText("Not found");
      p12corrc.show(p12corr,"bad");
      corr2c.setCurrent(incr2);
     }
    }
   }
   if (!javabin.equals("")) p12corrc.show(p12corr,"ok");
   next.enable();
   prev.enable();
  }
  void dlconfig() {
   next.disable();
   prev.disable();
   try {
    p9statc.show(p9stat,"dling");
    txtdownload(new File("config"),new URL(distro.NOSERVURL),distro.NOSERVFL);
    p9statc.show(p9stat,"dled");
   } catch (Throwable e) {
    p9statc.show(p9stat,"dlerr");
    System.err.println("Error in download: "+e);
   }
   next.enable();
   prev.enable();
  }
  void setupedit() {
   if (os==1){
    osc.setCurrent(unix);
    jsdkf.setText("/usr/local/JSDK1.0.1/");
   } else if (os==2) {
    osc.setCurrent(windows);
    jsdkf.setText("C:\\JSDK\\");
   } else {
    osc.setCurrent(other);
   }
   if (jsdkgood) {
    jsc.setCurrent(syes);
    jpc.setCurrent(pyes);
    p7jsdr.disable();
   } else {
    jsc.setCurrent(sno);
    jpc.setCurrent(pno);
    p7jsdr.disable();
    p7jpyn.disable();
   }
   cpef.setText(classpath);
  }
  void editstats() {
   corrc.setCurrent(corr);
   if (syes.getState()&&pno.getState()) {
    String path2czip=null;
    path2czip=jsdkf.getText()+File.separatorChar+"lib"+File.separatorChar+"classes.zip";
    File tf=new File(path2czip);
    if (!tf.exists()) path2czip=jsdkf.getText()+File.separatorChar+"lib"+File.separatorChar+"jsdk.jar";
    dclasspath=path2czip+File.pathSeparator+classpath;
   } else dclasspath=""+classpath;
   if (unix.getState()) os=1;
   else if (windows.getState()) os=2;
   else os=3;
   cpf.setText(dclasspath);
   jvf.setText("JDK 1.1 or later");
   if (syes.getState()) {
    svf.setText("JSDK 1.0 or later");
    jsdkgood=true;
   } else {
    svf.setText("JSDK not found");
    jsdkgood=false;
   }
   if (os==1) osf.setText("UNIX or compatible");
   else if (os==2) osf.setText("Win32 system (Windows 95/98/NT)");
   else osf.setText("Other");
  }
  void checkstats() {
   classpath="";
   jdkgood=false;
   jsdkgood=false;
   os=-1;
   allgood=true;
   next.disable();
   prev.disable();
   try {
    classpath=sysprops.getProperty("java.class.path");
    dclasspath=""+classpath;
    cpf.setText(classpath);
   } catch (Throwable e) {
    System.err.println("Error in checking: "+e);
    cpf.setText("Error!");
    allgood=false;
    p6cbrc.show(p6cbr,"error");
    nbarc.show(nbar,"two");
    return;
   }
   try {
    Class c=Class.forName("java.io.Reader");
    jdkgood=true;
    jvf.setText("JDK 1.1 or later");
   } catch (Throwable e) {
    jdkgood=false;
    jvf.setText("Not yet JDK 1.1");
    allgood=false;
    p6cbrc.show(p6cbr,"error");
    nbarc.show(nbar,"two");
    return;
   }
   try {
    Class c=Class.forName("javax.servlet.http.HttpServlet");
    jsdkgood=true;
    svf.setText("JSDK 1.0 or later");
   } catch (Throwable e) {
    svf.setText("JSDK not found");
    jsdkgood=false;
   }
   if (File.separatorChar=='/') {
    os=1;
    osf.setText("UNIX or compatible");
   } else {
    os=2;
    osf.setText("Win32 system (Windows 95/98/NT)");
   }
   next.enable();
   prev.enable();
   p6cbrc.show(p6cbr,"check");
  }
  public boolean action(Event ev,Object arg) {
   if (ev.target==quit) {
    System.exit(0);
   }
   if (ev.target==next) {
    stopitall();
    ppage=page;
    switch (page) {
     case 0:
      page=5;
      pbarc.show(pbar,"two");
      mainc.show(main,"six");
      break;
     case 5:
      if (corr.getState()) {
       if (jsdkgood) {
        if (os==3) {
         page=9;
         mainc.show(main,"ten");
        } else {
         page=10;
         mainc.show(main,"eleven");
        }
       } else {
        page=7;
        mainc.show(main,"eight");
       }
      } else {
       page=6;
       mainc.show(main,"seven");
      }
      break;
     case 6:
      page=5;
      mainc.show(main,"six");
      break;
     case 7:
      page=8;
      mainc.show(main,"nine");
      break;
     case 8:
      if (os==3) {
       page=9;
       mainc.show(main,"ten");
      } else {
       page=10;
       mainc.show(main,"eleven");
      }
      break;
     case 10:
      page=11;
      mainc.show(main,"twelve");
      break;
     case 11:
      if (corr2.getState()) {
       page=13;
       mainc.show(main,"fourteen");
      } else {
       page=12;
       mainc.show(main,"thirteen");
      }
      break;
     case 12:
      page=11;
      mainc.show(main,"twelve");
      break;
     case 13:
      page=14;
      mainc.show(main,"fifteen");
      break;
     default:
      break;
    }
    dostuff=new Thread(this);
    dostuff.start();
    return true;
   }
   if (ev.target==prev) {
    stopitall();
    ppage=-1;
    switch (page) {
     case 5:
      page=0;
      mainc.show(main,"one");
      break;
     case 6:
      page=5;
      mainc.show(main,"five");
      break;
     case 7:
      page=5;
      mainc.show(main,"six");
      break;
     case 8:
      page=7;
      mainc.show(main,"eight");
      break;
     case 9:
      page=5;
      mainc.show(main,"six");
      break;
     case 10:
      page=5;
      mainc.show(main,"six");
      break;
     case 11:
      page=10;
      mainc.show(main,"eleven");
      break;
     case 12:
      page=11;
      mainc.show(main,"twelve");
      break;
     case 13:
      page=11;
      mainc.show(main,"twelve");
     case 14:
      page=13;
      mainc.show(main,"fourteen");
     default:
      break;
    }
    dostuff=new Thread(this);
    dostuff.start();
    return true;
   }
   if (ev.target==syes) {
    p7jpyn.enable();
    if (pno.getState()) {
     p7jsdr.enable();
    }
    return true;
   }
   if (ev.target==sno) {
    p7jsdr.disable();
    p7jpyn.disable();
    return true;
   }
   if (ev.target==pyes) {
    p7jsdr.disable();
    return true;
   }
   if (ev.target==pno) {
    p7jsdr.enable();
    return true;
   }
   if (ev.target==unix) {
    jsdkf.setText("/usr/local/JSDK1.0.1/");
    return true;
   }
   if (ev.target==windows) {
    jsdkf.setText("C:\\JSDK\\");
    return true;
   }
   if (ev.target==finish) {
    switch (page) {
     default:
      System.out.println("\nI have created some scripts to help you manage Red.\nType \"red\" in Windows to start Red\n     or, \"./red\" in UNIX\nType \"config\" in Windows to configure Red\n     or, \"./redconfig\" in UNIX\n\n\n");
      System.exit(0);
    }
    return true;
   }
   return false;
  }
  void stopitall() {
   try {
    dostuff.stop();
    dostuff=null;
   } catch (Throwable e) {}
  }
}

