/*
 * Project ReD
 * jssresp.java -- Javasoft Servlet response class
 * Copyright (C) 1997-1998 Filip Pizlo
 * This code is protected by GPL/2.0
 * Read the README first!
 */

import javax.servlet.http.*;
import javax.servlet.*;

import java.io.*;
import java.net.*;
import java.util.*;

public class jssresp implements HttpServletResponse {
 srdata data;
 centrale blow;
 int code;
 public jssresp(srdata _data,centrale _blow) {
  data=_data;
  blow=_blow;
  code=200;
 }
 public srdata getdata() {
  return data;
 }
 public int getcode() {
  return code;
 }
 public void setStatus(int _code) {
  code=_code;
 }
 public void setStatus(int _code,String msg) {
  code=_code;
  data.usecustmsg=true;
  data.custommsg="<h1>Error "+code+"</h1>"+msg;
 }
 public void setContentLength(int length) {
  setIntHeader("Content-length",length);
 }
 public void setContentType(String mime) {
  setHeader("Content-type",mime);
 }
 public void setHeader(String name,String value) {
  data.outheaders.put(name,value);
 }
 public void setIntHeader(String name,int value) {
  data.outheaders.put(name,String.valueOf(value));
 }
 public void setDateHeader(String name,long value) {
  data.outheaders.put(name,(new Date(value)).toGMTString());
 }
 public void sendError(int _code) {
  setStatus(_code);
 }
 public void sendError(int _code,String message) {
  setStatus(_code,message);
 }
 public void sendRedirect(String url) throws IOException {
  setStatus(302);
  data.redirect=true;
  data.redtarg=url;
 }
 public ServletOutputStream getOutputStream() {
  return new jssout(data.out);
 }
 public boolean containsHeader(String name) {
  return data.outheaders.containsKey(name);
 }
}



