/*
 * Project ReD Proxy Editor
 * iproxy.java -- main (and only) proxy editor class
 * Copyright (C) 1998 Filip Pizlo
 */

import java.io.*;
import java.awt.*;

public class iproxy extends Frame {
 //static
  public static void main(String[] v) {
   String name="proxy";
   if (v.length>0) name=v[0];
   iproxy fr=new iproxy(name);
   fr.show();
  }
 //dynamic
  pizlist allows;
  TextField name;
  Button add,sub,ok,cancel,apply;
  String fname;
  public iproxy(String _fname) {
   super("Proxy Allows Editor");
   setLayout(new FlowLayout());
   setFont(new Font("Serif",Font.PLAIN,14));
   setBackground(Color.lightGray);
   setForeground(Color.black);
   fname=""+_fname;
   allows=new pizlist();
   load();
   name=new TextField("",20);
   add=new Button("Add");
   sub=new Button("Remove");
   ok=new Button("OK");
   cancel=new Button("Cancel");
   apply=new Button("Apply");
   Panel txt=new Panel(new GridLayout(3,1));
   txt.add(new Label("This program allows you to edit"));
   txt.add(new Label("which IP addresses are allowed"));
   txt.add(new Label("to use the Red proxy."));
   Panel north=new Panel(new GridLayout(2,1));
   Panel field=new Panel();
   field.add(new Label("IP Address:"));
   field.add(name);
   north.add(field);
   Panel adrem=new Panel();
   adrem.add(add);
   adrem.add(sub);
   north.add(adrem);
   Panel south=new Panel();
   south.add(ok);
   south.add(cancel);
   south.add(apply);
   add(txt);
   add(north);
   add(allows);
   add(south);
   resize(300,350);
  }
  public void load() {
   String buf;
   try {
    File tfl=new File(fname);
    BufferedReader fin=new BufferedReader(new InputStreamReader(new FileInputStream(tfl)));
    while (true) {
     try {
      buf=fin.readLine();
      if (buf==null) break;
      if (buf.charAt(0)!='#') {
       allows.add(buf);
      }
     } catch (Exception e) {}
    }
   } catch (Exception e) {
    System.err.println("Error: "+e);
   }
  }
  public void save() {
   try {
    String[] items=allows.getItems();
    File tfl=new File(fname);
    PrintStream fout=new PrintStream(new FileOutputStream(tfl));
    fout.println("# Proxy Allows File\n# Generated by iproxy.class");
    for (int i=0;i<items.length;i++) fout.println(items[i]);
    fout.close();
   } catch (Throwable e) {
    System.err.println("Error: "+e);
   }
  }
  public boolean action(Event ev,Object arg) {
   if (ev.target==add) {
    allows.add(name.getText());
    return true;
   }
   if (ev.target==sub) {
    try {
     allows.remove(allows.getSelectedItem());
    } catch (Throwable e) {}
    return true;
   }
   if (ev.target==ok) {
    save();
    dispose();
    return true;
   }
   if (ev.target==cancel) {
    dispose();
    return true;
   }
   if (ev.target==apply) {
    save();
    return true;
   }
   return false;
  }
}

