/*
 * Project ReD Alias Editor
 * imimes.java -- main (and only) mimes editor class
 * Copyright (C) 1998 Filip Pizlo
 */

import java.io.*;
import java.awt.*;
import java.util.*;

public class imimes extends Frame {
 //static
  public static void main(String[] v) {
   String name="mimes";
   if (v.length>0) name=v[0];
   imimes fr=new imimes(name);
   fr.show();
  }
 //dynamic
  pizlist allows;
  TextField name,dir,dext,dmm,sext,cext,hmm,hext;
  Button add,sub,ok,cancel,apply;
  String fname;
  public imimes(String _fname) {
   super("MIMEs Editor");
   setLayout(new GridLayout(1,2));
   setFont(new Font("Serif",Font.PLAIN,14));
   setBackground(Color.lightGray);
   setForeground(Color.black);
   dext=new TextField(".txt",20);
   dmm=new TextField("text/plain",20);
   sext=new TextField(".srv",20);
   cext=new TextField(".cgi",20);
   hmm=new TextField("text/html",20);
   hext=new TextField(".html",20);
   fname=""+_fname;
   allows=new pizlist();
   load();
   name=new TextField("",20);
   dir=new TextField("",20);
   add=new Button("Add");
   sub=new Button("Remove");
   ok=new Button("OK");
   cancel=new Button("Cancel");
   apply=new Button("Apply");
   Panel txt=new Panel(new GridLayout(2,1));
   txt.add(new Label("This program allows you to edit"));
   txt.add(new Label("the MIMEs database."));
   Panel north=new Panel(new GridLayout(3,1));
   Panel field1=new Panel();
   field1.add(new Label("MIME:"));
   field1.add(name);
   north.add(field1);
   Panel field2=new Panel();
   field2.add(new Label("Extension:"));
   field2.add(dir);
   north.add(field2);
   Panel adrem=new Panel();
   adrem.add(add);
   adrem.add(sub);
   north.add(adrem);
   Panel south=new Panel();
   south.add(ok);
   south.add(cancel);
   south.add(apply);
   Panel left=new Panel();
   left.add(txt);
   left.add(north);
   left.add(allows);
   left.add(south);
   Panel right=new Panel(new GridLayout(6,1));
   Panel dextp=new Panel();
   dextp.add(new Label("Default Ext:"));
   dextp.add(dext);
   Panel dmmp=new Panel();
   dmmp.add(new Label("Default MIME:"));
   dmmp.add(dmm);
   Panel sextp=new Panel();
   sextp.add(new Label("Servlet Ext:"));
   sextp.add(sext);
   Panel cextp=new Panel();
   cextp.add(new Label("CGI Ext:"));
   cextp.add(cext);
   Panel hmmp=new Panel();
   hmmp.add(new Label("HTML MIME:"));
   hmmp.add(hmm);
   Panel hextp=new Panel();
   hextp.add(new Label("HTML Ext:"));
   hextp.add(hext);
   right.add(dmmp);
   right.add(hmmp);
   right.add(dextp);
   right.add(hextp);
   right.add(cextp);
   right.add(sextp);
   add(left);
   add(right);
   resize(600,400);
  }
  public void load() {
   String buf;
   try {
    File tfl=new File(fname);
    BufferedReader fin=new BufferedReader(new InputStreamReader(new FileInputStream(tfl)));
    while (true) {
     try {
      buf=fin.readLine();
      if (buf==null) break;
      StringTokenizer tox=new StringTokenizer(buf);
      if (tox.countTokens()>=3) {
       String cmd=tox.nextToken();
       if (cmd.equals("add")) {
        allows.add(tox.nextToken()+" with "+tox.nextToken());
       } else if (cmd.equals("filter")) {
        // not implemented
       } else if (cmd.equals("default")) {
        dmm.setText(tox.nextToken());
        dext.setText(tox.nextToken());
       } else if (cmd.equals("cgi")) {
        tox.nextToken();
        cext.setText(tox.nextToken());
       } else if (cmd.equals("srv")) {
        tox.nextToken();
        sext.setText(tox.nextToken());
       } else if (cmd.equals("html")) {
        hmm.setText(tox.nextToken());
        hext.setText(tox.nextToken());
       }
      }
     } catch (Exception e) {}
    }
   } catch (Exception e) {
    System.err.println("Error: "+e);
   }
  }
  public void save() {
   try {
    String[] items=allows.getItems();
    File tfl=new File(fname);
    PrintStream fout=new PrintStream(new FileOutputStream(tfl));
    fout.println("# Mimes File\n# Generated by imimes.class");
    fout.println("default "+dmm.getText()+" "+dext.getText());
    fout.println("html "+hmm.getText()+" "+hext.getText());
    fout.println("cgi "+hmm.getText()+" "+cext.getText());
    fout.println("srv "+dmm.getText()+" "+sext.getText());
    for (int i=0;i<items.length;i++) {
     StringTokenizer tox=new StringTokenizer(items[i]);
     String line=tox.nextToken();
     tox.nextToken();
     line+=" "+tox.nextToken();
     fout.println("add "+line);
    }
    fout.close();
   } catch (Throwable e) {
    System.err.println("Error: "+e);
   }
  }
  public boolean action(Event ev,Object arg) {
   if (ev.target==add) {
    allows.add(name.getText()+" to "+dir.getText());
    return true;
   }
   if (ev.target==sub) {
    try {
     allows.remove(allows.getSelectedItem());
    } catch (Throwable e) {}
    return true;
   }
   if (ev.target==ok) {
    save();
    dispose();
    return true;
   }
   if (ev.target==cancel) {
    dispose();
    return true;
   }
   if (ev.target==apply) {
    save();
    return true;
   }
   return false;
  }
}

