/*
 * Project ReD Alias Editor
 * ialias.java -- main (and only) alias editor class
 * Copyright (C) 1998 Filip Pizlo
 */

import java.io.*;
import java.awt.*;
import java.util.*;

public class ialias extends Frame {
 //static
  public static void main(String[] v) {
   String name="alias";
   if (v.length>0) name=v[0];
   ialias fr=new ialias(name);
   fr.show();
  }
 //dynamic
  pizlist allows;
  TextField name,dir;
  Checkbox redirect;
  Button add,sub,ok,cancel,apply;
  String fname;
  public ialias(String _fname) {
   super("Alias Editor");
   setLayout(new FlowLayout());
   setFont(new Font("Serif",Font.PLAIN,14));
   setBackground(Color.lightGray);
   setForeground(Color.black);
   fname=""+_fname;
   allows=new pizlist();
   load();
   name=new TextField("",20);
   dir=new TextField("",20);
   redirect=new Checkbox("302 Redirect",false);
   add=new Button("Add");
   sub=new Button("Remove");
   ok=new Button("OK");
   cancel=new Button("Cancel");
   apply=new Button("Apply");
   Panel txt=new Panel(new GridLayout(2,1));
   txt.add(new Label("This program allows you to edit"));
   txt.add(new Label("the alias database."));
   Panel north=new Panel(new GridLayout(4,1));
   Panel field1=new Panel();
   field1.add(new Label("Alias:"));
   field1.add(name);
   north.add(field1);
   Panel field2=new Panel();
   field2.add(new Label("To:"));
   field2.add(dir);
   north.add(field2);
   Panel field3=new Panel();
   field3.add(redirect);
   north.add(field3);
   Panel adrem=new Panel();
   adrem.add(add);
   adrem.add(sub);
   north.add(adrem);
   Panel south=new Panel();
   south.add(ok);
   south.add(cancel);
   south.add(apply);
   add(txt);
   add(north);
   add(allows);
   add(south);
   resize(300,420);
  }
  public void load() {
   String buf;
   try {
    File tfl=new File(fname);
    BufferedReader fin=new BufferedReader(new InputStreamReader(new FileInputStream(tfl)));
    while (true) {
     try {
      buf=fin.readLine();
      if (buf==null) break;
      if (buf.charAt(0)!='#') {
       StringTokenizer tox=new StringTokenizer(buf);
       String astr=tox.nextToken()+" to "+tox.nextToken();
       try {
        if (tox.nextToken().equals("redirect")) astr+=" (redirect)";
       } catch (Throwable e) {}
       allows.add(astr);
      }
     } catch (Exception e) {}
    }
   } catch (Exception e) {
    System.err.println("Error: "+e);
   }
  }
  public void save() {
   try {
    String[] items=allows.getItems();
    File tfl=new File(fname);
    PrintStream fout=new PrintStream(new FileOutputStream(tfl));
    fout.println("# Alias File\n# Generated by ialias.class");
    for (int i=0;i<items.length;i++) {
     StringTokenizer tox=new StringTokenizer(items[i]);
     String line=tox.nextToken();
     tox.nextToken();
     line+=" "+tox.nextToken();
     try {
      if (tox.nextToken().equals("(redirect)")) line+=" redirect";
     } catch (Throwable e) {}
     fout.println(line);
    }
    fout.close();
   } catch (Throwable e) {
    System.err.println("Error: "+e);
   }
  }
  public boolean action(Event ev,Object arg) {
   if (ev.target==add) {
    String astr=name.getText()+" to "+dir.getText();
    if (redirect.getState()) astr+=" (redirect)";
    allows.add(astr);
    return true;
   }
   if (ev.target==sub) {
    try {
     allows.remove(allows.getSelectedItem());
    } catch (Throwable e) {}
    return true;
   }
   if (ev.target==ok) {
    save();
    dispose();
    return true;
   }
   if (ev.target==cancel) {
    dispose();
    return true;
   }
   if (ev.target==apply) {
    save();
    return true;
   }
   return false;
  }
}

