/*
 * Project ReD
 * flexyload.java -- class loader
 * Copyright (C) 1997 Filip Pizlo
 * This code is under GPL/2.0
 * You must read the README before doing anything!
 */

import java.io.*;

public class flexyload extends ClassLoader {
 String path,ext;
 protected flexyload() {
 }
 public flexyload(String _path,String _ext) throws Exception {
  this();
  path=""+_path;
  ext=""+_ext;
 }
 protected Class lcpriv(String name) throws ClassNotFoundException {
  Class ret;
  try {
   ret=Class.forName(name);
   if (ret==null) throw new ClassNotFoundException("hehe");
   return ret;
  } catch (Exception e) {
   byte[] data=readclassdata(path+name+ext);
   ret=defineClass(data,0,data.length);
   if (ret==null) throw new ClassNotFoundException("hehe");
   return ret;
  }
 }
 public Class loadClass(String name,boolean resolve) throws ClassNotFoundException {
  Class ret=null;
  ret=lcpriv(name);
  if (resolve) resolveClass(ret);
  return ret;
 }
 protected byte[] readclassdata(String flnm) throws ClassNotFoundException {
  byte[] data=null;
  try {
   FileInputStream fin=new FileInputStream(flnm);
   data=new byte[fin.available()];
   int res=fin.read(data,0,data.length);
   fin.close();
  } catch (Exception e) {
   throw new ClassNotFoundException(flnm);
  }
  return data;
 }
 public static String file2name(String flnm) {
  int ls=flnm.lastIndexOf(File.separatorChar);
  if (ls<0) {
   ls=flnm.lastIndexOf('/');
   if (ls<0) ls=0;
   else ls++;
  } else ls++;
  int lp=flnm.lastIndexOf('.');
  if (lp<ls) lp=flnm.length();
  return flnm.substring(ls,lp);
 }
 public static String file2ext(String flnm) {
  int ls=flnm.lastIndexOf('.');
  if (ls<0) ls++;
  return flnm.substring(ls,flnm.length());
 }
 public static String file2path(String flnm) {
  int ls=flnm.lastIndexOf(File.separatorChar);
  if (ls<0) {
   ls=flnm.lastIndexOf('/');
   if (ls<0) return "."+File.separatorChar;
   else ls++;
  } else ls++;
  return flnm.substring(0,ls);
 }
}

