
class Parameter
{
    private String m_strName;
    private String m_strDefault;
    private boolean m_bIsDefault;
    private String m_strValue;
    
    private boolean m_bAllowDefault;
    
    private boolean m_bIsSetUp;
    
    public Parameter(String i_strName, String i_strDefault) {
        m_strName=i_strName;
        m_strDefault=i_strDefault;
        m_bIsDefault=true;
        m_strValue=m_strDefault;
        m_bAllowDefault=true;

        m_bIsSetUp=true;
    }
    public Parameter(String i_strName, String i_strDefault, boolean i_bAllowDefault) {
        m_strName=i_strName;
        m_strDefault=i_strDefault;
        m_bIsDefault=true;
        m_strValue=m_strDefault;
        m_bAllowDefault=i_bAllowDefault;

        m_bIsSetUp=true;
    }
    
    public Parameter() {
        m_bIsSetUp=false;
    }
    
	public String GetValue() {
		if (m_bIsSetUp)
			return m_strValue;
		else
			return "";
	}

    // returns value to be written to file
    public String GetWriteableValue() {
        if (m_bIsSetUp)
            if (m_bAllowDefault) {
                if (m_bIsDefault)
                    return "# "+m_strName+" "+m_strDefault;
                else
                    return (m_strName+" "+m_strValue);
            } else {
                return (m_strName+" "+m_strValue);
            }
        else
            return "";
    }
    
    public void SetValue(Object i_NewValue) {
        if (m_bIsSetUp) {
            m_bIsDefault=false;
            m_strValue=i_NewValue.toString();
//            if (!m_bAllowDefault && m_strValue=m_strDefault)
//                m_bIsDefault=true;
        }
    }
	// sets value using boolean argument
	public void SetValueB(boolean i_bNewValue) {
		if (m_bIsSetUp) {
			m_bIsDefault=false;
			if (i_bNewValue)
				m_strValue="true";
			else
				m_strValue="false";
		}
	}
    
    public boolean IsDefault() {
        if (m_bIsSetUp)
            return m_bIsDefault;
        else
            return false;
    }
    
    public void SetToDefault() {
        if (m_bIsSetUp) {
            m_bIsDefault=true;
            m_strValue=m_strDefault;
        }
    }
    
    public void Setup(String i_strName, String i_strDefault) {
        if (m_bIsSetUp) return;
        m_strName=i_strName;
        m_strDefault=i_strDefault;
        m_bIsDefault=true;
        m_strValue=m_strDefault;
        m_bAllowDefault=true;
        
        m_bIsSetUp=true;
    }       

    public void Setup(String i_strName, String i_strDefault, boolean i_bAllowDefault) {
        if (m_bIsSetUp) return;
        m_strName=i_strName;
        m_strDefault=i_strDefault;
        m_bIsDefault=true;
        m_strValue=m_strDefault;
        m_bAllowDefault=i_bAllowDefault;
        
        m_bIsSetUp=true;
    }       
    
    // checks a line for values
    // called from RedSetup.LoadConfigFile
    public boolean CheckLine(String i_TestLine) {
        if (i_TestLine.startsWith(m_strName)) {
            SetValue(i_TestLine.substring(m_strName.length()+1));
            return true;
        }
        return false;
    }
}

