/*
	A basic extension of the java.awt.Dialog class
 */

import java.awt.*;
import java.io.*;

public class AboutDialog extends Dialog {
	void okButton_Clicked(Event event) {
		//{{CONNECTION
		// Clicked from okButton Hide the Dialog
		hide();
		//}}
	}

	public AboutDialog(Frame parent, boolean modal) {

		super(parent, modal);
		int wspec=249;
		int bspec=221;
		if (File.separatorChar=='/') {
			wspec=280;
			bspec=240;
		}

		setLayout(null);
		addNotify();
		resize(insets().left + insets().right + wspec,insets().top + insets().bottom + 150);
		setBackground(new Color(12632256));
		label1 = new java.awt.Label("Project RED");
		label1.setBounds(insets().left + (wspec-166)/2,insets().top + 16,166,28);
		java.awt.Font f2=new Font("MS Sans Serif",Font.BOLD,26);
		label1.setFont(f2);
		add(label1);
		okButton = new java.awt.Button("OK");
		okButton.setBounds(insets().left + 168,insets().top + 116,66,27);
		add(okButton);
		label2 = new java.awt.Label("Created by Filip Pizlo and Scott Minster");
		label2.setBounds(insets().left + (wspec-bspec)/2,insets().top + 44,bspec,26);
		f2=new Font("MS Sans Serif",Font.BOLD,12);
		label2.setFont(f2);
		add(label2);
		setTitle("About");
		setResizable(false);
	}

	public AboutDialog(Frame parent, String title, boolean modal) {
		this(parent, modal);
		setTitle(title);
	}

	public synchronized void show() {
		Rectangle bounds = getParent().getBounds();
		Rectangle abounds = getBounds();

		setLocation(bounds.x + (bounds.width - abounds.width)/ 2, bounds.y + (bounds.height - abounds.height)/2);

		super.show();
	}

	public boolean handleEvent(Event event) {
		if(event.id == Event.WINDOW_DESTROY) {
			hide();
			return true;
		}
		if (event.target == okButton && event.id == Event.ACTION_EVENT) {
			okButton_Clicked(event);
		}
		return super.handleEvent(event);
	}

	//{{DECLARE_CONTROLS
	java.awt.Label label1;
	java.awt.Button okButton;
	java.awt.Label label2;
	//}}
}
