// SampleView.cpp : implementation of the CSampleView class
//

#include "stdafx.h"
#include "Sample.h"

#include "SampleDoc.h"
#include "SampleView.h"
#include "GeometryManager.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSampleView

IMPLEMENT_DYNCREATE(CSampleView, CFormView)

BEGIN_MESSAGE_MAP(CSampleView, CFormView)
	//{{AFX_MSG_MAP(CSampleView)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB, OnSelchangeTab)
	ON_NOTIFY(TCN_SELCHANGING, IDC_TAB, OnSelchangingTab)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampleView construction/destruction

CSampleView::CSampleView()
	: CFormView(CSampleView::IDD)
{
	//{{AFX_DATA_INIT(CSampleView)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CSampleView::~CSampleView()
{
}

void CSampleView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSampleView)
	DDX_Control(pDX, IDC_TAB, m_TabCtrl);
	//}}AFX_DATA_MAP
}

BOOL CSampleView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CSampleView diagnostics

#ifdef _DEBUG
void CSampleView::AssertValid() const
{
	CFormView::AssertValid();
}

void CSampleView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CSampleDoc* CSampleView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSampleDoc)));
	return (CSampleDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSampleView message handlers

void CSampleView::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();
	
	// we don't want any scroll bars
	SetScrollSizes(MM_TEXT, CSize(0, 0));

	// create the tab pages
	m_TabPage1.Create(IDD_TAB_PAGE1, &m_TabCtrl);
	m_TabPage2.Create(IDD_TAB_PAGE2, &m_TabCtrl);
	m_TabPage3.Create(IDD_TAB_PAGE3, &m_TabCtrl);

	TC_ITEM tcItem = {0};
	tcItem.mask = TCIF_TEXT;
	tcItem.pszText = "Page 1";
	m_TabCtrl.InsertItem(0, &tcItem);
	tcItem.pszText = "Page 2";
	m_TabCtrl.InsertItem(1, &tcItem);
	tcItem.pszText = "Page 3";
	m_TabCtrl.InsertItem(2, &tcItem);

	m_TabPage1.ShowWindow(SW_SHOW);

	// initialize the geometry manager
	//
	// the default behavior is fine
	//
	HGEOM hGeom = GmStartDefinition(0);
	ASSERT(hGeom);
	if (!hGeom)
		return;
	
	// add the top-level frame window group
	//
	// arrange its direct children vertically
	//
	// Notice that since this window are a CFormView, you need to
	// pass in the window handle of the parent frame window.
	//
	HGMGROUP hTopFrame = GmAddTopFrameWnd(hGeom, GetParentFrame()->m_hWnd, GM_VERTICAL);
	if (hTopFrame)
	{
		// add the generic group for the static text and edit field
		//
		// arrange its direct children horizontally
		// give it a weight of 0
		//
		HGMGROUP hGroup1 = GmAddGroup(hGeom, hTopFrame, GM_HORIZONTAL, 0);
		if (hGroup1)
		{
			// add the static text group
			//
			// left-align and vertically center it
			// give it a weight of 0
			//
			GmAddWnd(hGeom, hGroup1, ::GetDlgItem(m_hWnd, IDC_NAME_LABEL), GM_LEFT | GM_VCENTER, 0);
			
			// add the edit field group
			//
			// allow it to grow horizontally
			// give it a weight of 1
			//
			GmAddWnd(hGeom, hGroup1, ::GetDlgItem(m_hWnd, IDC_NAME), GM_GROW_X, 1);
		}
			
		// add the generic group for the rest of the controls
		//
		// arrange its direct children horizontally
		// give it a weight of 1
		//
		hGroup1 = GmAddGroup(hGeom, hTopFrame, GM_HORIZONTAL, 1);
		if (hGroup1)
		{
			// add the generic group for the controls on the left
			//
			// arrange its direct children vertically
			// give it a weight of 3
			//
			HGMGROUP hGroup2 = GmAddGroup(hGeom, hGroup1, GM_VERTICAL, 3);
			if (hGroup2)
			{
				// add the generic group for the static text and edit field
				//
				// arrange its direct children vertically
				// give it a weight of 1
				//
				HGMGROUP hGroup3 = GmAddGroup(hGeom, hGroup2, GM_VERTICAL, 1);
				if (hGroup3)
				{
					// add the static text group
					//
					// left-align and vertically center it
					// give it a weight of 0
					//
					GmAddWnd(hGeom, hGroup3, ::GetDlgItem(m_hWnd, IDC_ADDRESS_LABEL), GM_LEFT | GM_VCENTER, 0);
					
					// add the multiline edit field group
					//
					// allow it to grow (in both directions)
					// give it a weight of 1
					//
					GmAddWnd(hGeom, hGroup3, ::GetDlgItem(m_hWnd, IDC_ADDRESS), GM_GROW, 1);
				}
				
				// add the group box group
				//
				// arrange its direct children vertically
				// give it a weight of 0
				//
				hGroup3 = GmAddGroupBox(hGeom, hGroup2, ::GetDlgItem(m_hWnd, IDC_STUFF), GM_VERTICAL | GM_GROW, 0);
				if (hGroup3)
				{
					// add the radio button groups
					//
					// left-align and vertically center them
					// give them a weight of 0
					//
					GmAddWnd(hGeom, hGroup3, ::GetDlgItem(m_hWnd, IDC_STUFF_1), GM_LEFT | GM_VCENTER, 0);
					GmAddWnd(hGeom, hGroup3, ::GetDlgItem(m_hWnd, IDC_STUFF_2), GM_LEFT | GM_VCENTER, 0);
					GmAddWnd(hGeom, hGroup3, ::GetDlgItem(m_hWnd, IDC_STUFF_3), GM_LEFT | GM_VCENTER, 0);
				}
			}
			
			// add the generic group for the controls on the right
			//
			// arrange its direct children vertically
			// give it a weight of 1
			//
			hGroup2 = GmAddGroup(hGeom, hGroup1, GM_VERTICAL, 1);
			if (hGroup2)
			{
				// add the static text group
				//
				// left-align and vertically center it
				// give it a weight of 0
				//
				GmAddWnd(hGeom, hGroup2, ::GetDlgItem(m_hWnd, IDC_TAB_LABEL), GM_LEFT | GM_VCENTER, 0);
				
				// add the tab control group
				//
				// arrange its direct children overlapped
				// give it a weight of 1
				//
				HGMGROUP hGroup3 = GmAddTabControl(hGeom, hGroup2, m_TabCtrl.m_hWnd, GM_GROW | GM_OVERLAPPED, 1);
				if (hGroup3)
				{
					// add the first tab page
					//
					// arrange its direct children horizontally
					// allow it to grow in both directions
					// give it a weight of 1
					//
					HGMGROUP hGroup4 = GmAddChildDialog(hGeom, hGroup3, m_TabPage1.m_hWnd, GM_GROW | GM_HORIZONTAL, 1);
					if (hGroup4)
					{
						// add the static text group
						//
						// left-align and vertically center it
						// give it a weight of 0
						//
						GmAddWnd(hGeom, hGroup4, ::GetDlgItem(m_TabPage1.m_hWnd, IDC_NAME_LABEL), GM_LEFT | GM_VCENTER, 0);
					
						// add the edit field group
						//
						// vertically center it
						// allow it to grow horizontally
						// give it a weight of 1
						//
						GmAddWnd(hGeom, hGroup4, ::GetDlgItem(m_TabPage1.m_hWnd, IDC_NAME), GM_GROW_X | GM_VCENTER, 1);
					}

					// add the second tab page
					//
					// arrange its direct children vertically
					// allow it to grow in both directions
					// give it a weight of 1
					//
					hGroup4 = GmAddChildDialog(hGeom, hGroup3, m_TabPage2.m_hWnd, GM_GROW | GM_VERTICAL, 1);
					if (hGroup4)
					{
						// add the static text group
						//
						// left-align and vertically center it
						// give it a weight of 0
						//
						GmAddWnd(hGeom, hGroup4, ::GetDlgItem(m_TabPage2.m_hWnd, IDC_INFO_LABEL), GM_LEFT | GM_VCENTER, 0);
						
						// add the multiline edit field group
						//
						// allow it to grow (in both directions)
						// give it a weight of 1
						//
						GmAddWnd(hGeom, hGroup4, ::GetDlgItem(m_TabPage2.m_hWnd, IDC_INFO), GM_GROW, 1);
					}

					// add the third tab page
					//
					// arrange its direct children vertically
					// allow it to grow in both directions
					// give it a weight of 1
					//
					hGroup4 = GmAddChildDialog(hGeom, hGroup3, m_TabPage3.m_hWnd, GM_GROW | GM_VERTICAL, 1);
					if (hGroup4)
					{
						// add the generic group for the top two static frame controls
						//
						// arrange its direct children horizontally
						// give it a weight of 1
						//
						HGMGROUP hGroup5 = GmAddGroup(hGeom, hGroup4, GM_HORIZONTAL, 1);
						if (hGroup5)
						{
							// add the static frame groups
							//
							// allow them to grow (in both directions)
							// give them a weight of 1
							//
							GmAddStaticFrame(hGeom, hGroup5, ::GetDlgItem(m_TabPage3.m_hWnd, IDC_FRAME1), GM_GROW, 1);
							GmAddStaticFrame(hGeom, hGroup5, ::GetDlgItem(m_TabPage3.m_hWnd, IDC_FRAME2), GM_GROW, 1);
						}

						// add the bottom static frame group
						//
						// allow it to grow (in both directions)
						// give it a weight of 1
						//
						GmAddStaticFrame(hGeom, hGroup4, ::GetDlgItem(m_TabPage3.m_hWnd, IDC_FRAME3), GM_GROW, 1);
					}
				}
				
				// add the generic group for the buttons
				//
				// horizontally center it
				// arrange its direct children horizontally
				// give it a weight of 1
				//
				hGroup3 = GmAddGroup(hGeom, hGroup2, GM_HORIZONTAL | GM_HCENTER, 0);
				if (hGroup3)
				{
					// add the button groups
					//
					// give them a weight of 0
					//
					GmAddWnd(hGeom, hGroup3, ::GetDlgItem(m_hWnd, IDC_ADD), 0, 0);
					GmAddWnd(hGeom, hGroup3, ::GetDlgItem(m_hWnd, IDC_EDIT), 0, 0);
					GmAddWnd(hGeom, hGroup3, ::GetDlgItem(m_hWnd, IDC_DELETE), 0, 0);
				}
			}
		}
	}
	
	// end the definition and start the manager
	//
	VERIFY(GmEndDefinition(hGeom));
}

void CSampleView::OnSelchangingTab(NMHDR* /*pNMHDR*/, LRESULT* pResult) 
{
	int iSel = m_TabCtrl.GetCurSel();

	switch (iSel)
	{
	case 0:
		m_TabPage1.ShowWindow(SW_HIDE);
		break;
	case 1:
		m_TabPage2.ShowWindow(SW_HIDE);
		break;
	case 2:
		m_TabPage3.ShowWindow(SW_HIDE);
		break;
	}
	
	*pResult = 0;
}

void CSampleView::OnSelchangeTab(NMHDR* /*pNMHDR*/, LRESULT* pResult) 
{
	int iSel = m_TabCtrl.GetCurSel();

	switch (iSel)
	{
	case 0:
		m_TabPage1.ShowWindow(SW_SHOW);
		break;
	case 1:
		m_TabPage2.ShowWindow(SW_SHOW);
		break;
	case 2:
		m_TabPage3.ShowWindow(SW_SHOW);
		break;
	}

	*pResult = 0;
}
