////////////////////////////////////////////////////////////////////////////////
// TCimaShareware                                                             //
//                                                                            //
// Purpose:  Lets you know when either a time period has been                 //
//           reached (ie 30 trial), a certain date has been                   //
//           past, or when your application has been run a                    //
//           certain number of times.                                         //
//                                                                            //
// Usage:    Just place CimaShareware1->Execute() in your programs            //
//           main form constructor and select your options in the             //
//           Object Inspector.                                                //
//                                                                            //
//   If the ExpireType you choose uses the registry, it will place it in two  //
//  locations (of your choice), and compare the two as a check to see if the  //
//  registry has been "messed" with.  Try to make the ValueNames discrete     //
//  such as "Left" and "Top", and maybe use two different keys to make it hard /
//  for a 'would be cracker' to crack your shareware.  This check triggers the /
//  OnRegistryManipulated event.                                              //
//                                                                            //
//  If the ExpireType is set to " ltDate" it will check to see if the clock   //
//  on the users computer has been set back.  If so, the OnClockSetBack event //
//  is triggered.                                                             //
//                                                                            //
//  When the ZeroLengthOnRegManipulation property is set to true and ExpireType
//  is set to "ltRunTimes" it will update the registry so that an OnExpired   //
//  event is triggered the next time the program is run.                      //
//                                                                            //
//                                                                            //
// Methods:  InstallDate()          ...  ALL METHODS RETURN STRINGS   ...     //
//           DaysLeft()               You can convert them to Integers        //
//           DaysUsed()               or dates with StrToInt() if you         //
//           RunsUsed()               need to.  Depending on wich of          //
//           RunsLeft()               the three Types (ltDays,ltRunTimes,     //
//           GetExpirationDate()      ltDate) you choose, some Methods will   //
//                                    return "N/A" if they do not apply       //
//                                    to that "Type".                         //
//                                                                            //
//                                                                            //
// Events:  OnExpired                                                         //
//          OnRegistryManipulated                                             //
//          OnClockSetBack                                                    //
//                                                                            //
//  In the //Constants section below....                                      //
// Change the const String DefaultRegistry* expressions to your likeing to    //
// customize the components Default Settings when dropped on a form.          //
// You may also change the return string from "N/A" to something else, such   //
// as "-1", for easy conversion to an integer if you are using the methods in //
// calculations.                                                              //
//                                                                            //
//  Demo:                                                                     //
//     If your copy of this component did not come with a demo project you    //
//     can get one by sending e-mail to cimasoftware@usa.net                  //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// by Jarrid Cima                                                             //
//    cimasoftware@usa.net                                                    //
//    http://www.intrnet.net/~jacima/cbuilder                                 //
//                                                                            //
//  Copyright 1997                                                           //
////////////////////////////////////////////////////////////////////////////////
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef TcimaShareH
#define TcimaShareH
//Constants
const String DefaultCimaShareRegistryKey      = "\\Software\\Cima Software\\";
const String DefaultCimaShareRegistryKeyCheck = "\\Software\\Cima Software\\";
const String DefaultCimaShareRegistryValueName  = "FormLeft";
const String DefaultCimaShareRegistryValueName2 = "FormTop";
const String DefaultCimaShareRegistryValueNameCheck  = "FormRight";
const String DefaultCimaShareRegistryValueNameCheck2 = "FormBottom";
const String DefaultReturnNotApplicableString = "N/A";
//---------------------------------------------------------------------------
#include <vcl\SysUtils.hpp>
#include <vcl\Controls.hpp>
#include <vcl\Classes.hpp>
#include <vcl\Forms.hpp>
#include <vcl\registry.hpp>
#include <vcl\dsgnintf.hpp>
#include "CimaAboutBox.h"
#include "CimaShareRegBox.h"

#pragma link "CimaAboutBox.obj"
#pragma link "CimaShareRegBox.obj"
//---------------------------------------------------------------------------
enum TLengthType {ltDays,ltRunTimes,ltDate};
#ifndef _TRegRoot
#define _TRegRoot
enum TRegRoot {rrHKEY_CLASSES_ROOT, rrHKEY_CURRENT_USER, rrHKEY_LOCAL_MACHINE, rrHKEY_USERS};
#endif
//---------------------------------------------------------------------------
class TCimaAboutShare : public Dsgnintf::TPropertyEditor
{typedef Dsgnintf::TPropertyEditor inherited;
public:
	virtual void __fastcall Edit(void);
	virtual Dsgnintf::TPropertyAttributes __fastcall GetAttributes(void);
	virtual System::AnsiString __fastcall GetValue(void);
public:
   __fastcall virtual ~TCimaAboutShare(void) { }
public:
   __fastcall TCimaAboutShare(void) : Dsgnintf::TPropertyEditor() { }
};
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TCimaShareware : public TComponent
{
private:
   int          DoNothingCheck;
   int          FLength;
   int          FTimesLeft;
   TRegRoot     FRegistryRoot;
   String       FRegistryKey;
   String       FRegistryKeyCheck;
   String       FRegistryValueName;
   String       FRegistryValueName2;
   String       FRegistryValueNameCheck;
   String       FRegistryValueNameCheck2;
   TLengthType  FType;
   TDateTime    FExpireDate;

      TDateTime    DateStart;
      TDateTime    Installdate;

      int DaysElapsed;
     bool FZeroLength;

   // Event Stuff Below
   Classes::TNotifyEvent  FOnExpired;
   Classes::TNotifyEvent  FOnRegistryManipulated;
   Classes::TNotifyEvent  FOnClockSetBack;
//---------------------------------------------------------------------------
protected:
   void __fastcall DoNothing (String AValue);
   bool __fastcall RunTime(void);
   bool __fastcall DateLength(void);
   bool __fastcall DateNotify(void);
   void __fastcall DateCrackCheck();
   String NotA;
   // Setters
   void __fastcall SetLength (ALength);
   void __fastcall SetZeroLength (bool AZeroLength);
   // Triggers OnExpired Event
  virtual void __fastcall Expired();
  virtual void __fastcall RegistryManipulated();
  virtual void __fastcall ClockSetBack();
//---------------------------------------------------------------------------
public:
  __fastcall TCimaShareware(TComponent* Owner);
      bool __fastcall Execute(void);
    String __fastcall InstallDate(void);
    String __fastcall DaysLeft(void);
    String __fastcall DaysUsed(void);
    String __fastcall RunsUsed(void);
    String __fastcall RunsLeft(void);
    String __fastcall GetExpirationDate(void);
//---------------------------------------------------------------------------
__published:
  TCimaAboutShare*  FAbout;
     __property TCimaAboutShare* About = {read=FAbout, write=FAbout};
   //	__property About ;
    __property TRegRoot RegistryRoot = {read=FRegistryRoot, write=FRegistryRoot, default = HKEY_CURRENT_USER};
    __property String RegistryKey= {read=FRegistryKey, write = FRegistryKey};
    __property String RegistryValueName = {read=FRegistryValueName, write = FRegistryValueName};
    __property String RegistryValueName2 = {read=FRegistryValueName2, write = FRegistryValueName2};
    __property String RegistryValueNameCheck = {read=FRegistryValueNameCheck, write = FRegistryValueNameCheck};
    __property String RegistryValueNameCheck2 = {read=FRegistryValueNameCheck2, write = FRegistryValueNameCheck2};
    __property String RegistryKeyCheck = {read=FRegistryKeyCheck, write = FRegistryKeyCheck};
   	__property int ExpireLength = {read=FLength, write=SetLength, default = 30};
    __property TLengthType ExpireType = {read=FType, write=FType, default = ltRunTimes};
    __property TDateTime ExpireDate = {read=FExpireDate, write=FExpireDate};
    __property bool ZeroLengthOnRegManipulation = {read=FZeroLength, write=SetZeroLength, default = true};

// *******************************  EVENTS  *********************************
   __property Classes::TNotifyEvent OnExpired =	{read = FOnExpired, write=FOnExpired};
   __property Classes::TNotifyEvent OnRegistryManipulated =	{read = FOnRegistryManipulated, write=FOnRegistryManipulated};
   __property Classes::TNotifyEvent OnClockSetBack =	{read = FOnClockSetBack, write=FOnClockSetBack};
};
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

#endif
