

#define APPNAME "NetCPS"
#define VERSION "1.0"
#define COPYRIGHT APPNAME" v."VERSION" Copyright 1998 by Jarle Aase"

#include <stdio.h>
#include <time.h>
#include <windows.h>

LPCSTR myname;
void usage(LPCSTR Tag);
int Port = 4455;
int Mbytes = 100;
int Server;
void DoClient();
void DoServer();
DWORD GetAddr (const char *szHost) ;
BOOL GetCps(DWORD Bytes);
void PrintCPS(LPCSTR Tag, float& CPS);
float Peek;
DWORD StartTick;

WSADATA WSAData;
LPCSTR Host = "";

main(int argc, LPSTR*argv)
{
	LPCSTR p;
	myname = *argv;             
	FILE *InFp = NULL;

	if ((p = strrchr((LPCSTR)myname,'\\')) != NULL)
		myname = ++p;
	else
		myname = *argv;

	if (WSAStartup(MAKEWORD(1, 1), &WSAData) != 0)
	{
		printf("%s: WSAStartup() failed with error code %d", myname, WSAGetLastError());
		exit(-1);
	}

	while(--argc)
	{
		p = *++argv;
		if (*p == '-')
		{
			switch(*++p)
			{
				case 'm':
					Mbytes = atoi(++p);
					break;
				case 's':
					++Server;
					break;
				case 'p': 
					Port = atoi(++p); 
					break;
				case 'h':
				case '?':
					usage(NULL);
				default:
					usage(*argv);
			}
		}
		else
		{
			if (Host && *Host)
				usage(p);

			Host = p;
		}
	}

	if (Server)
		DoServer();
	else
	{
		if (Host && *Host)
			DoClient();
		else
			usage(NULL);
	}

	WSACleanup();
	return 0;
}


void usage(LPCSTR Tag)
{
	fprintf(stderr,"%s %s - donated into the Public Domain (almost) by Jarle Aase\n", APPNAME, VERSION);
	fprintf(stderr,"THIS PROGRAM IS NOT LISENCED TO GOVERNMENTAL OR MILITARY USE.\n");
		
	if (Tag)
	{
		fprintf(stderr,"%s: Unknown parameter\n%Use \"%s -help\" for options.", Tag, myname);
	}
	else
	{
		fprintf(stderr,"Usage: %s [options] [Remote host]\n", myname);

		fprintf(stderr,"  -Pn     Port number. Default port is %d\n", Port);
		fprintf(stderr,"  -server Server mode. (Default is client)\n");
		fprintf(stderr,"  -mn     Megabytes to transfer. Default is %d\n", Mbytes);
		fprintf(stderr,"Note: 'n' represents a number.\n");
	}

	exit(-1);
}


void DoServer()
{
	char buf[1024];

	SOCKET lSck, cSck;

	__int64 BytesSent;
	int Bytes;

	printf("%s %s - Entering server mode. Press ^C to quit\n", APPNAME, VERSION);

	if ((lSck = socket(PF_INET,SOCK_STREAM,0)) == INVALID_SOCKET)
	{
		printf("ERROR: Failed to create listening socket %d).\n", WSAGetLastError());
		exit(-1);
	}

	SOCKADDR_IN sin;

	memset(&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_port = htons(Port);
	sin.sin_addr.s_addr = INADDR_ANY;

	if (bind(lSck, (const struct sockaddr *)&sin, sizeof(sockaddr)) != 0)
	{
		printf("ERROR: Failed to bind() listening socket %d).\n", WSAGetLastError());
		exit(-1);
	}

	if (listen(lSck, 0) != 0)
	{
		printf("ERROR: Failed to listen() socket %d.\n", WSAGetLastError());
		exit(-1);
	}

	while(TRUE)
	{
		printf("Waiting for new connection...");
		int nlen = sizeof(sockaddr);
		if ((cSck = accept(lSck, (struct sockaddr *)&sin, &nlen)) == -1)
		{
			printf("\nERROR - accept() failed %d.\n", WSAGetLastError());
			exit(-1);
		}

		nlen = sizeof(sockaddr);
		getpeername(cSck, (struct sockaddr *)&sin, &nlen);
		printf("\nClient connected from %d.%d.%d.%d\n", 
			(unsigned)sin.sin_addr.S_un.S_un_b.s_b1,
			(unsigned)sin.sin_addr.S_un.S_un_b.s_b2,
			(unsigned)sin.sin_addr.S_un.S_un_b.s_b3,
			(unsigned)sin.sin_addr.S_un.S_un_b.s_b4);

		BytesSent = 0;

		GetCps(0);
		while((Bytes = recv (cSck, buf, sizeof(buf), 0)) > 0)
		{
			BytesSent += Bytes;
			GetCps(Bytes);
		}
		if (Bytes == -1)
		{
			printf("\nERROR - recv() failed %d.\n", WSAGetLastError());
		}

		closesocket(cSck);
		float CPS = ((float)BytesSent / ((float)(GetTickCount() - StartTick)) * (float)1000);
		PrintCPS("\nAvrg ", CPS);
		PrintCPS("\nPeek ", Peek);
		printf("\nClient disconnected. %I64d Kb transferred in %.2f seconds.\n", 
			BytesSent, ((float)(GetTickCount() - StartTick)) / (float)1000);
		printf("\n\n");
	}
}

void DoClient()
{
	char buf[1024];

	SOCKET cSck;

	DWORD KbytesToSend = Mbytes * 1024 *1024;
	__int64 BytesSent = 0;
	int Bytes;

	printf("%s %s - Entering client mode. Press ^C to quit\n", APPNAME, VERSION);

	if ((cSck = socket(PF_INET,SOCK_STREAM,0)) == INVALID_SOCKET)
	{
		printf("ERROR: Failed to create socket %d).\n", WSAGetLastError());
		exit(-1);
	}

	SOCKADDR_IN sin;

	memset(&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_port = htons(Port);
	sin.sin_addr.s_addr = GetAddr(Host);

	if ((sin.sin_addr.s_addr == INADDR_ANY)
		|| (sin.sin_addr.s_addr == INADDR_NONE))
	{
		printf("ERROR: Host lookup to '%s' failed %d).\n", 
			Host, WSAGetLastError());
		exit(-1);
	}

	printf("Connecting to %d.%d.%d.%d port %d...", 
		(unsigned)sin.sin_addr.S_un.S_un_b.s_b1,
		(unsigned)sin.sin_addr.S_un.S_un_b.s_b2,
		(unsigned)sin.sin_addr.S_un.S_un_b.s_b3,
		(unsigned)sin.sin_addr.S_un.S_un_b.s_b4,
		Port);

	int nlen = sizeof(sockaddr);
	if (connect(cSck, (struct sockaddr *)&sin, nlen) != 0)
	{
		printf("\nERROR: Failed to connect() socket %d).\n", WSAGetLastError());
		exit(-1);
	}

	printf(" Connected!\n");
	GetCps(0);

	while((Bytes = send(cSck, buf, min(KbytesToSend, sizeof(buf)), 0)) > 0)
	{
		BytesSent += Bytes;
		
		if (Bytes < 1)
		{
			printf("\nERROR - send() failed %d.\n", WSAGetLastError());
			exit(-1);
		}
		else
			GetCps(Bytes);

		if ((KbytesToSend -= Bytes) < 1)
			break; // Done
	}

	closesocket(cSck);
	float CPS = ((float)BytesSent / ((float)(GetTickCount() - StartTick)) * (float)1000);
	PrintCPS("\nAvrg ", CPS);
	PrintCPS("\nPeek ", Peek);
	printf("\nDone. %I64d Kb transferred in %.2f seconds.\n", 
		BytesSent, ((float)(GetTickCount() - StartTick)) / (float)1000);
	printf("\n\n");
}

BOOL GetCps(DWORD Bytes)
{
	static DWORD LastTick;
	static __int64 CountBytes;

	if (Bytes == 0)
	{
		LastTick = GetTickCount();
		CountBytes = 0;
		Peek = 0;
		StartTick = LastTick;
		return FALSE;
	}
	
	DWORD CurrTick = GetTickCount();

	CountBytes += Bytes;

	if ((CurrTick - LastTick) < 1000)
		return FALSE;

	float CPS = ((float)CountBytes / ((float)(CurrTick - LastTick)) * (float)1000);
	PrintCPS("\r---> ", CPS);
	if (CPS > Peek)
		Peek = CPS;
	
	CountBytes = 0;

	LastTick = CurrTick;
	return TRUE;
}

void PrintCPS(LPCSTR Tag, float& CPS)
{
	printf("%sCPS %12.02f  KPS: %8.02f  MPS: %4.02f    ", Tag, CPS,
		CPS / 1024, (CPS / 1024) / 1024);
}


// The following code is borrowed from the sample code at http://www.sockets.com
/*-----------------------------------------------------------
 * Function: GetAddr()
 *
 * Description: Given a string, it will return an IP address.
 *   - first it tries to convert the string directly
 *   - if that fails, it tries o resolve it as a hostname
 *
 * WARNING: gethostbyname() is a blocking function
 */
DWORD GetAddr (const char *szHost) 
{
  LPHOSTENT lpstHost;
  u_long lAddr = INADDR_ANY;
  
  /* check that we have a string */
  if (*szHost) {
  
    /* check for a dotted-IP address string */
    lAddr = inet_addr (szHost);
  
    /* If not an address, then try to resolve it as a hostname */
    if ((lAddr == INADDR_NONE) &&
        (strcmp(szHost, "255.255.255.255"))) {
      
      lpstHost = gethostbyname(szHost);
      if (lpstHost) {  /* success */
        lAddr = *((u_long FAR *) (lpstHost->h_addr));
      } else {  
        lAddr = INADDR_ANY;   /* failure */
      }
    }
  }
  return (lAddr); 
} /* end GetAddr() */

