unit Web1;

{
  Written by John E. McTaggart on January 7, 1999
  Written with Delphi 3.02

  This program is released into the public domain and you may use it in any
  way that you see fit. The author assumes no liability for this program's
  fitness for use. You use solely at your own risk.

  For programmers, this app uses RTTI information and the various component's
  tag property extensively.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, StdCtrls, ClipBrd, Menus;

type
  TwebForm = class(TForm)
    RedBar: TTrackBar;
    GreenBar: TTrackBar;
    BlueBar: TTrackBar;
    RedPanel: TPanel;
    GreenPanel: TPanel;
    BluePanel: TPanel;
    Combined: TPanel;
    clrNormal: TRadioButton;
    clrSafe: TRadioButton;
    MainMenu1: TMainMenu;
    Action1: TMenuItem;
    Copy1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    rHex: TLabel;
    gHex: TLabel;
    bHex: TLabel;
    rDec: TLabel;
    gDec: TLabel;
    bDec: TLabel;
    SB: TStatusBar;
    CreateJPeg1: TMenuItem;
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Shape1: TShape;
    Shape3: TShape;
    KillHints: TMenuItem;
    Shape2: TShape;
    Shape4: TShape;
    AboutWebColor1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure ExitClick(Sender: TObject);
    procedure CopyWebHex(Sender: TObject);
    procedure CopyClick(Sender: TObject);
    procedure RedBarChange(Sender: TObject);
    procedure GreenBarChange(Sender: TObject);
    procedure BlueBarChange(Sender: TObject);
    procedure CombineNormal(Sender: TObject);
    procedure CombineSafe(Sender: TObject);
    procedure DoRadioClick(Sender: TObject);
    procedure UpdateStatus(Sender: TObject);
    procedure CreateJPeg1Click(Sender: TObject);
    procedure DisplayHint(Sender: TObject);
    procedure KillHintsClick(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SBMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure AboutWebColor1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  WebColor : Array [0..5] Of Integer = (0, 51, 102, 153, 204, 255);

var
  webForm: TwebForm;

implementation

uses jpegForm, About;

{$R *.DFM}

procedure TwebForm.DisplayHint(Sender: TObject);
begin
  If Not KillHints.Checked Then
    SB.Panels[2].Text := Application.Hint;
end;

procedure TwebForm.CopyWebHex(Sender: TObject);
var
  Colr: LongInt;
  WebHex: String;
begin
  Colr := ColorToRGB(Combined.Color);
  WebHex := '#' + IntToHex(Word(GetRValue(Colr)), 2)
                + IntToHex(Word(GetGValue(Colr)), 2)
                + IntToHex(Word(GetBValue(Colr)), 2);
  Try
    ClipBoard.AsText := WebHex;
  Except
    Abort;
  End; { Try }
end;

procedure TwebForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := DisplayHint;
end;

procedure TwebForm.ExitClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TwebForm.CopyClick(Sender: TObject);
begin
  CopyWebHex(Self);
end;

procedure TwebForm.RedBarChange(Sender: TObject);
begin
  With RedPanel Do Begin
    If clrNormal.Checked Then Begin
      Color := TColor(RGB(RedBar.Position, 0, 0));
      CombineNormal(RedBar);
    End
    Else Begin
      Color := TColor(RGB(WebColor[RedBar.Position], 0, 0));
      CombineSafe(RedBar);
    End; { If }
  End; { With }
end;

procedure TwebForm.GreenBarChange(Sender: TObject);
begin
  With GreenPanel Do Begin
    If clrNormal.Checked Then Begin
      Color := TColor(RGB(0, GreenBar.Position, 0));
      CombineNormal(GreenBar);
    End
    Else Begin
      Color := TColor(RGB(0, WebColor[GreenBar.Position], 0));
      CombineSafe(GreenBar);
    End; { If }
  End; { With }
end;

procedure TwebForm.BlueBarChange(Sender: TObject);
begin
  With BluePanel Do Begin
    If clrNormal.Checked Then Begin
      Color := TColor(RGB(0, 0, BlueBar.Position));
      CombineNormal(BlueBar);
    End
    Else Begin
      Color := TColor(RGB(0, 0, WebColor[BlueBar.Position]));
      CombineSafe(BlueBar);
    End; { If }
  End; { With }
end;

procedure TwebForm.CombineNormal(Sender: TObject);
begin
  Combined.Color := TColor(RGB(RedBar.Position,
                               GreenBar.Position,
                               BlueBar.Position));
  Case TTrackBar(Sender).Tag Of
    1:
      Begin
        rHex.Caption := IntToHex(RedBar.Position, 2);
        rDec.Caption := IntToStr(RedBar.Position);
      End;
    2:
      Begin
        gHex.Caption := IntToHex(GreenBar.Position, 2);
        gDec.Caption := IntToStr(GreenBar.Position);
      End;
    3:
      Begin
        bHex.Caption := IntToHex(BlueBar.Position, 2);
        bDec.Caption := IntToStr(BlueBar.Position);
      End;
  End;
  UpdateStatus(Self);
end;

procedure TwebForm.CombineSafe(Sender: TObject);
begin
  Combined.Color := TColor(RGB(WebColor[RedBar.Position],
                                   WebColor[GreenBar.Position],
                                   WebColor[BlueBar.Position]));
  Case TTrackBar(Sender).Tag Of
    1:
      Begin
        rHex.Caption := IntToHex(WebColor[RedBar.Position], 2);
        rDec.Caption := IntToStr(WebColor[RedBar.Position]);
      End;
    2:
      Begin
        gHex.Caption := IntToHex(WebColor[GreenBar.Position], 2);
        gDec.Caption := IntToStr(WebColor[GreenBar.Position]);
      End;
    3:
      Begin
        bHex.Caption := IntToHex(WebColor[BlueBar.Position], 2);
        bDec.Caption := IntToStr(WebColor[BlueBar.Position]);
      End;
  End;
  UpdateStatus(Self);
end;

procedure TwebForm.UpdateStatus(Sender: TObject);
begin
  With SB Do Begin
    Panels[0].Text := rHex.Caption + gHex.Caption + bHex.Caption;
    Panels[1].Text := IntToStr(TColor(Combined.Color));
  End; { With }
end;

procedure TwebForm.DoRadioClick(Sender: TObject);
var
  I: Integer;
begin
  For I := 0 To ComponentCount - 1 Do Begin
    If Components[I] Is TTrackBar Then Begin
      With TTrackBar(Components[I]) Do Begin
        If clrNormal.Checked Then Begin
          TickStyle := tsNone;
          Max := 255;
        End
        Else Begin
          TickStyle := tsAuto;
          Max := 5;
        End; { If }
        Position := 0;
      End; { With }
    End { If }
    Else If Components[I] Is TPanel Then
      TPanel(Components[I]).Color := clBlack
    Else If (Components[I] Is TLabel) And (TLabel(Components[I]).Tag <> 5) Then
      TLabel(Components[I]).Caption := '00';
  End; { For }
  With SB Do Begin
    Panels[0].Text := '000000';
    Panels[1].Text := '0';
  End;
end;

procedure TwebForm.CreateJPeg1Click(Sender: TObject);
begin
  Try
    Application.CreateForm(TfrmJPeg, frmJPeg);
    frmJPeg.ShowModal;
  Finally
    frmJPeg.Free;
  End;
end;

procedure TwebForm.KillHintsClick(Sender: TObject);
begin
  KillHints.Checked := Not KillHints.Checked;
end;

procedure TwebForm.FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  SB.Panels[2].Text := '';
end;

procedure TwebForm.SBMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  { A hack to get hints from the status bar panels }
  If Not KillHints.Checked Then Begin
    If (X > 0) And (X < SB.Panels[0].Width) Then
      SB.Panels[2].Text := 'Combined hex value'
    Else If (X > SB.Panels[1].Width + 1) And (X < (SB.Panels[0].Width + SB.Panels[1].Width)) Then
      SB.Panels[2].Text := 'Combined decimal value'
    Else
      SB.Panels[2].Text := '';  
  End;
end;

procedure TwebForm.AboutWebColor1Click(Sender: TObject);
begin
  AboutForm.ShowModal;
end;

end.
