unit jpegForm;

{
  Written by John E. McTaggart on January 7, 1999
  Written with Delphi 3.02

  This program is released into the public domain and you may use it in any
  way that you see fit. The author assumes no liability for this program's
  fitness for use. You use it solely at your own risk.

  Not much to this unit, but it does show how to create and colorize a bitmap
  and then save it as a jpeg.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, JPeg, ExtCtrls;

type
  TfrmJPeg = class(TForm)
    jpgWidth: TSpinEdit;
    jpgHeight: TSpinEdit;
    WidthLabel: TLabel;
    HeightLabel: TLabel;
    Create: TButton;
    Close: TButton;
    SD: TSaveDialog;
    Image1: TImage;
    Label1: TLabel;
    procedure CreateClick(Sender: TObject);
    procedure jpgWidthKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmJPeg: TfrmJPeg;

implementation

uses Web1;

{$R *.DFM}

procedure TfrmJPeg.CreateClick(Sender: TObject);
var
  Bitmap: TBitmap;
  JPG: TJPegImage;
  Failed: Boolean;
begin
  { Default file name }
  SD.FileName := WebForm.SB.Panels[0].Text + '.jpg';
  If SD.Execute Then Begin
    Application.ProcessMessages;
    { Create a bitmap and a jpeg }
    Bitmap := TBitmap.Create;
    JPG := TJPegImage.Create;
    Failed := False;
    With Bitmap Do Try
      { Create the bitmap }
      Width := jpgWidth.Value;
      Height := jpgHeight.Value;
      Canvas.Brush.Color := WebForm.Combined.Color;
      Canvas.Brush.Style := bsSolid;
      Canvas.FillRect(Rect(0, 0, jpgWidth.Value, jpgHeight.Value));
      With JPG Do Try
        { Copy bitmap to jpeg }
        Assign(Bitmap);
        CompressionQuality := 100;
        SaveToFile(SD.FileName);
      Except
        ShowMessage('A file error occurred while creating the .jpg file.');
        Failed := True;
        Abort;
      End; { Try / Except }
    Finally
      JPG.Free;
      Bitmap.Free;
    End; { Try / Finally }
    If Not Failed Then
      ShowMessage(ExtractFileName(SD.FileName) + ' was created successfully.');
  End; { If }
end;

procedure TfrmJPeg.jpgWidthKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
const
  Valid = [48..57, VK_DELETE, VK_RETURN, VK_BACK];
begin
  If Not (Key In Valid) Then Begin
    ShowMessage('Only numbers 0-9 are valid in this field.');
    Key := 0;
  End;
end;

end.
