VERSION 5.00
Begin VB.Form frmError 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "An Error has occured"
   ClientHeight    =   6180
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   6615
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6180
   ScaleWidth      =   6615
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdHelp 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Help"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   5520
      TabIndex        =   26
      ToolTipText     =   "Help Information"
      Top             =   4920
      Width           =   1035
   End
   Begin VB.CommandButton cmdEnd 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&End "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   3360
      TabIndex        =   24
      ToolTipText     =   "End the program."
      Top             =   4920
      Width           =   1035
   End
   Begin VB.CommandButton cmdContinue 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Continue"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   2280
      TabIndex        =   23
      ToolTipText     =   "Continue program operation."
      Top             =   4920
      Width           =   1035
   End
   Begin VB.CommandButton cmdPrint 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Print Error"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   4440
      TabIndex        =   22
      ToolTipText     =   "Print the error data on your printer"
      Top             =   4920
      Width           =   1035
   End
   Begin VB.TextBox txtDesc 
      Height          =   855
      Left            =   2280
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   20
      Top             =   3900
      Width           =   4215
   End
   Begin VB.Label lblNote 
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Note: The information on this form is copied to the clipboard and saved in error.log file in the application's directory."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   735
      Left            =   60
      TabIndex        =   27
      Top             =   5400
      Width           =   6495
   End
   Begin VB.Line Line5 
      X1              =   540
      X2              =   6420
      Y1              =   4800
      Y2              =   4800
   End
   Begin VB.Line Line4 
      X1              =   540
      X2              =   6420
      Y1              =   3840
      Y2              =   3840
   End
   Begin VB.Label lblCmd 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Continue unless in an error loop."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   540
      TabIndex        =   25
      Top             =   4920
      Width           =   1695
   End
   Begin VB.Label lblDesc 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Please enter a description of the steps that produced the error."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   855
      Left            =   540
      TabIndex        =   21
      Top             =   3900
      Width           =   1695
   End
   Begin VB.Label lblProgVersTxt 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Version 1.00.0001"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2280
      TabIndex        =   19
      Top             =   120
      Width           =   4155
   End
   Begin VB.Label lblProgVers 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Program Version:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   540
      TabIndex        =   18
      Top             =   120
      Width           =   1695
   End
   Begin VB.Label lblFileTimeTxt 
      BackColor       =   &H00C0C0C0&
      Caption         =   "000"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2280
      TabIndex        =   17
      Top             =   480
      Width           =   4155
   End
   Begin VB.Label lblProgPathTxt 
      BackColor       =   &H00C0C0C0&
      Caption         =   "000"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2280
      TabIndex        =   16
      Top             =   780
      Width           =   4155
   End
   Begin VB.Label lblOSTxt 
      BackColor       =   &H00C0C0C0&
      Caption         =   "000"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2280
      TabIndex        =   15
      Top             =   1080
      Width           =   4155
   End
   Begin VB.Label lblFileTime 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "File Time:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   540
      TabIndex        =   14
      Top             =   480
      Width           =   1695
   End
   Begin VB.Label lblProgPath 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Program Path:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   540
      TabIndex        =   13
      Top             =   780
      Width           =   1695
   End
   Begin VB.Label lblOS 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Operating System:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   540
      TabIndex        =   12
      Top             =   1080
      Width           =   1695
   End
   Begin VB.Label lblLineNumTxt 
      BackColor       =   &H00FFFFC0&
      Caption         =   "000"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2280
      TabIndex        =   11
      Top             =   2040
      Width           =   4155
   End
   Begin VB.Label lblProcTxt 
      BackColor       =   &H00FFFFC0&
      Caption         =   "000"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2280
      TabIndex        =   10
      Top             =   1740
      Width           =   4155
   End
   Begin VB.Label lblModuleTxt 
      BackColor       =   &H00FFFFC0&
      Caption         =   "000"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2280
      TabIndex        =   9
      Top             =   1440
      Width           =   4155
   End
   Begin VB.Label lblErrDescTxt 
      BackColor       =   &H00FFFFC0&
      Caption         =   "000"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   795
      Left            =   2280
      TabIndex        =   8
      Top             =   3000
      Width           =   4155
   End
   Begin VB.Label lblErrCatTxt 
      BackColor       =   &H00FFFFC0&
      Caption         =   "000"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2280
      TabIndex        =   7
      Top             =   2700
      Width           =   4155
   End
   Begin VB.Label lblErrDesc 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Error Description:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   540
      TabIndex        =   6
      Top             =   3000
      Width           =   1695
   End
   Begin VB.Label lblErrCat 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Error Category:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   540
      TabIndex        =   5
      Top             =   2700
      Width           =   1695
   End
   Begin VB.Line Line3 
      X1              =   540
      X2              =   6420
      Y1              =   2340
      Y2              =   2340
   End
   Begin VB.Label lblLineNum 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Line Number:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   540
      TabIndex        =   4
      Top             =   2040
      Width           =   1695
   End
   Begin VB.Label lblProc 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Procedure:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   540
      TabIndex        =   3
      Top             =   1740
      Width           =   1695
   End
   Begin VB.Label lblModule 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Module:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   540
      TabIndex        =   2
      Top             =   1440
      Width           =   1695
   End
   Begin VB.Line Line2 
      X1              =   540
      X2              =   6420
      Y1              =   1380
      Y2              =   1380
   End
   Begin VB.Line Line1 
      X1              =   540
      X2              =   6420
      Y1              =   420
      Y2              =   420
   End
   Begin VB.Label lblErrNumTxt 
      BackColor       =   &H00FFFFC0&
      Caption         =   "000"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2280
      TabIndex        =   1
      Top             =   2400
      Width           =   4155
   End
   Begin VB.Label lblErrNum 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Error Number:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   540
      TabIndex        =   0
      Top             =   2400
      Width           =   1695
   End
   Begin VB.Image imgExclaim 
      Height          =   480
      Left            =   60
      Picture         =   "frmError.frx":0000
      Top             =   540
      Width           =   480
   End
End
Attribute VB_Name = "frmError"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'----------------------------------------------------------------------
' Name:        frmError (Code)
' Author:      George Lissauer
' Created:     Saturday, May 03,1997 @ 4:58:55 pm (Vers: 1.0.0001)
'
' Description: Generic Error Display Form
'
'  Uses the following custom error handler in VB DocuMentor:
'
'  frmError.ErrMsg [ProcName], [ModuleName], Erl, Err
'----------------------------------------------------------------------
' Disclaimer of Warranty:
'
' This software and the accompanying files are provided "as is"
' and without warranties as to performance of the software and
' the accompanying files or any other warranties whether expressed
' or implied.  No warranty of fitness for a particular purpose
' is offered.
'
' You MAY NOT sell this software or it's source code.
' You MAY use this code in any way you find useful.
'-----------------------------------------------------------------------
Option Explicit

#Const EXE_TYPE = True        'SET TO FALSE IF USED IN A DLL.
Private m_sExeType As String   'Type of exe: dll or exe - used to find timestamp of application

'these are available as long as form is loaded
Private m_lPlatform As Long
Private m_sPlatform As String
Private m_sVersion As String

Const EM_GETLINECOUNT = &HBA
Const EM_GETLINE = &HC4
Const iMAX_CHAR_PER_LINE = 65

Const VbLogToFile = 2            'Should be in VB Constants

Private Declare Function SendMessage Lib "User32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Any) As Long

'Win32 API calls
Private Type OSVERSIONINFO
    dwOSVersionInfoSize As Long
    dwMajorVersion As Long
    dwMinorVersion As Long
    dwBuildNumber As Long
    dwPlatformId As Long
    szCSDVersion As String * 128
End Type
Private lpVerInfo As OSVERSIONINFO
' dwPlatformId defines for OSVERSIONINFO structure...
Const VER_PLATFORM_WIN32s = 0
Const VER_PLATFORM_WIN32_WINDOWS = 1
Const VER_PLATFORM_WIN32_NT = 2
Private Declare Function GetVersionEx Lib "kernel32" Alias "GetVersionExA" (lpVersionInformation As OSVERSIONINFO) As Long


Private Declare Function SetWindowPos Lib "User32" _
 (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, _
 ByVal x As Long, ByVal y As Long, ByVal cx As Long, _
 ByVal cy As Long, ByVal wFlags As Long) As Long
' SetWindowPos() hwndInsertAfter values
Private Const HWND_TOPMOST = -1
Private Const HWND_NOTOPMOST = -2
' SetWindowPos Flags
Private Const SWP_NOSIZE = &H1
Private Const SWP_NOMOVE = &H2
Private Const SWP_NOACTIVATE = &H10

'----------------------------------------------------------------------
' Name:        FormatVersion
' Copyright:   (c) 1998 GridLinx Software
' Author:      George Lissauer
' Created:     Tuesday, June 30,1998 @ 10:43:35 pm (Vers: 3.0.0000)
'
' Description: Format Program Version Infomation
'----------------------------------------------------------------------

Private Function FormatVersion(Major&, Minor&, Optional Revision) As String
80    If IsMissing(Revision) Then
81       FormatVersion = Format(Major, "#0.") & Format(Minor, "00")
82    Else
83       FormatVersion = Format(Major, "#0.") & Format(Minor, "00.") & Format(Revision, "0000")
84    End If
End Function

'----------------------------------------------------------------------
' Name:        GetOSPlatform
' Copyright:   (c) 1998 GridLinx Software
' Author:      George Lissauer
' Created:     Tuesday, June 30,1998 @ 10:44:01 pm (Vers: 3.0.0000)
'
' Description: Get the OS Version
'----------------------------------------------------------------------
Private Function GetOSPlatform() As Long
96    lpVerInfo.dwOSVersionInfoSize = Len(lpVerInfo)
97    GetVersionEx lpVerInfo
98    m_lPlatform = lpVerInfo.dwPlatformId
99    If m_lPlatform = VER_PLATFORM_WIN32_NT Then
100      m_sPlatform = "Microsoft Windows NT"
101   Else
102      m_sPlatform = "Microsoft Windows 95"
103   End If
104   m_sVersion = FormatVersion(lpVerInfo.dwMajorVersion, lpVerInfo.dwMinorVersion)
105   GetOSPlatform = m_lPlatform
End Function

'----------------------------------------------------------------------
' Name:        cmdContinue_Click
' Copyright:   (c) 1998 GridLinx Software
' Author:      George Lissauer
' Created:     Tuesday, June 30,1998 @ 10:40:25 pm (Vers: 3.0.0000)
'
' Description: If the user selects Continue, Log the error
'              information and unload.
'----------------------------------------------------------------------
Private Sub cmdContinue_Click()
Dim s As String
Dim sPath As String
120   If Right(App.Path, 1) = "\" Then
121      sPath = App.Path
122   Else
123      sPath = App.Path & "\"
124   End If

126   App.StartLogging sPath & "Error.log", VbLogToFile

128   s = FormatError()
129   App.LogEvent s, vbLogEventTypeInformation
130   Clipboard.SetText s  'save in clipboard
131   Unload Me
132   Set frmError = Nothing
End Sub

'----------------------------------------------------------------------
' Name:        cmdEnd_Click
' Author:      George Lissauer
' Created:     Saturday, May 03,1997 @ 11:44:05 pm (Vers: 1.0.0002)
'
' Description: End Application after writing out data
'              NOTE: IF THIS FORM IS USED IN A DLL, COMMENT OUT
'              THE END STATEMENT.
'
'----------------------------------------------------------------------
Private Sub cmdEnd_Click()
Dim s As String
Dim sPath As String
148   If Right(App.Path, 1) = "\" Then
149      sPath = App.Path
150   Else
151      sPath = App.Path & "\"
152   End If

154   App.StartLogging sPath & "Error.log", VbLogToFile
155   s = FormatError()
156   App.LogEvent s, vbLogEventTypeInformation
157   Clipboard.SetText s  'save in clipboard
158   Unload Me
#If EXE_TYPE = True Then
160   End      'COMMENT OUT THE END STATEMENT FOR USE IN DLL
#End If
162   Set frmError = Nothing
End Sub

'----------------------------------------------------------------------
' Name:        cmdHelp_Click
' Author:      George Lissauer
' Created:     Sunday, May 04,1997 @ 8:52:48 am (Vers: 1.0.0002)
'
' Description: Display Help in a message box
'
'----------------------------------------------------------------------
Private Sub cmdHelp_Click()
Dim s As String
175   s = "Please provide Customer Service with the information displayed."
176   s = s & vbCrLf & vbCrLf
177   s = s & "This infomation is copied to the clipboard and logged to " & vbCrLf
178   s = s & "the file: ERROR.LOG in the:" & vbCrLf & App.Path & " directory."
179   s = s & vbCrLf & vbCrLf
180   s = s & "Please enter any additional information in the text box."
181   s = s & vbCrLf & vbCrLf
182   s = s & "If you have a printer connected to your computer, you can " & vbCrLf
183   s = s & "print out the information using the Print Error button."
184   s = s & vbCrLf & vbCrLf
185   s = s & "Continue program operation using the the Continue button."
186   s = s & vbCrLf & vbCrLf
187   s = s & "If this same error repeats, exit the program with the End button."
188   MsgBox s, vbInformation, "An Error Occured in Your Program ..."
End Sub

'----------------------------------------------------------------------
' Name:        cmdPrint_Click
' Author:      George Lissauer
' Created:     Saturday, May 03,1997 @ 8:52:23 pm (Vers: 1.0.0001)
'
' Description: Print error info on the default printer
'
'----------------------------------------------------------------------
Private Sub cmdPrint_Click()
Dim s As String
201   s = FormatError()
202   Printer.ScaleMode = vbInches
203   Printer.ScaleLeft = -0.5
204   Printer.Print s
205   Printer.EndDoc
End Sub

'----------------------------------------------------------------------
' Name:        Form_Activate
' Copyright:   Gridlinx Software
' Author:      George Lissauer
' Created:     Tuesday, June 02,1998 @ 10:20:20 pm (Vers: 1.0.0003)
'
' Description: Display the applications path & version.
' Assumptions: Test for error 53 then change app.type to exe or dll
'----------------------------------------------------------------------
Private Sub Form_Activate()
'Get current Windows configuration
219   On Error GoTo ActError
#If EXE_TYPE Then
221   m_sExeType = ".exe"
#Else
223   m_sExeType = ".dll"
#End If

226   lblFileTimeTxt = FileDateTime(App.Path & "\" & App.EXEName & m_sExeType)
227   lblProgPathTxt = ShortPath(App.Path & "\" & App.EXEName & m_sExeType, 45)
228   lblProgPathTxt.ToolTipText = App.Path & "\" & App.EXEName & m_sExeType
229   lblOSTxt = m_sPlatform & " Vers: " & m_sVersion
230   lblOSTxt = lblOSTxt & " Build: "
231   lblOSTxt = lblOSTxt & CStr(lpVerInfo.dwBuildNumber Mod 65536)
232 ActError:

234   If Err.Number = 53 Then
235      m_sExeType = ".dll"
236      DoEvents              'Avoid a locked loop if no exe yet.
237      Resume
238   Else
239      Exit Sub
240   End If
End Sub

'----------------------------------------------------------------------
' Name:        Form_Load
' Copyright:   (c) 1998 GridLinx Software
' Author:      George Lissauer
' Created:     Tuesday, June 02,1998 @ 10:48:56 pm (Vers: 1.0.0000)
'
' Description: Center form & Put on Top
'----------------------------------------------------------------------

Private Sub Form_Load()
253   Call SetWindowPos(Me.hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE Or SWP_NOMOVE Or SWP_NOACTIVATE)

' Center the form
256   Me.Move ((Screen.Width - Me.Width) / 2), ((Screen.Height - Me.Height) / 2)

258   lblProgVersTxt = FormatVersion(App.Major, App.Minor, App.Revision)
259   GetOSPlatform
'GetSystemInfo lpSysInfo
'm_lProcessor = lpSysInfo.dwProcessorType
262   Me.Caption = "An Error Occured in: " & App.Title _
   & " " & Format$(Now, "dddd mmm dd,yyyy @ hh:mm:ss")
264   lblErrDescTxt.Caption = "A value has been assigned to a property, that is outside its permissible range."
265   lblErrDescTxt.Caption = lblErrDescTxt.Caption & "A value has been assigned to a property, that is outside its permissible range."
266   lblNote.Caption = "Note: The infomation on this form is copied to the clipboard and logged to " & _
   "the file: ERROR.LOG in the: " & App.Path & " directory when you click the Continue or End buttons."

End Sub

'----------------------------------------------------------------------
' Name:        FormatError
' Copyright:   (c) 1998 GridLinx Software
' Author:      George Lissauer
' Created:     Saturday, June 20,1998 @ 10:42:24 pm (Vers: 3.0.0000)
'
' Description: Format the error information in the form's labels and
'              text box for printing and logging.
' Results:     The formatted error information.
'----------------------------------------------------------------------

Private Function FormatError() As String
Dim s As String
284   s = vbCrLf
285   s = s & "'" & String(70, "-") & vbCrLf
286   s = s & "Error in: " & vbTab & App.Title & vbCrLf
287   s = s & "Time: " & vbTab & Format$(Now, "dddd mmm dd,yyyy @ hh:mm:ss") & vbCrLf
288   s = s & "Version: " & vbTab & lblProgVersTxt.Caption & vbCrLf
289   s = s & "File Time: " & vbTab & lblFileTimeTxt.Caption & vbCrLf
290   s = s & "Program Path: " & vbTab & lblProgPathTxt.ToolTipText & vbCrLf
291   s = s & "Operating System: " & vbTab & lblOSTxt.Caption & vbCrLf
292   s = s & "Module: " & vbTab & lblModuleTxt.Caption & vbCrLf
293   s = s & "Procedure: " & vbTab & lblProcTxt.Caption & vbCrLf
294   s = s & "Line Number: " & vbTab & lblLineNumTxt.Caption & vbCrLf
295   s = s & "Error Number: " & vbTab & lblErrNumTxt.Caption & vbCrLf
296   s = s & "Error Category: " & vbTab & lblErrCatTxt.Caption & vbCrLf
297   s = s & "Error Description: " & vbCrLf & lblErrDescTxt.Caption & vbCrLf
298   If Len(Trim$(txtDesc.Text)) > 0 Then
299      s = s & "User Description: " & vbCrLf
300      s = s & sCommentBlock(txtDesc) & vbCrLf
301   End If
302   s = s & "'" & String(70, "-") & vbCrLf

304   FormatError = s

End Function

'----------------------------------------------------------------------
' Name:        fGetLine
' Copyright:   (c) 1998 GridLinx Software
' Author:      George Lissauer
' Created:     Saturday, June 20,1998 @ 10:40:45 pm (Vers: 3.0.0000)
'
' Description: Get a single line or text from a text box or label
'              control.
' Inputs:      lLine - line number of text to return
'              ctl - label or text box control
' Assumptions: ctl must be a label or text box
' Results:     Returns the text specified by the line number
'----------------------------------------------------------------------
Private Function fGetLine(lLine As Long, ctl As Control) As String
Dim iByteLo As Integer
Dim iByteHi As Integer
Dim sBuffer As String
Dim iChrs As Integer
326   iByteLo = iMAX_CHAR_PER_LINE And (255)
327   iByteHi = Int(iMAX_CHAR_PER_LINE / 256)
328   sBuffer = Chr$(iByteLo) & Chr$(iByteHi) + Space$(iMAX_CHAR_PER_LINE - 2)
329   iChrs = SendMessage(ctl.hwnd, EM_GETLINE, lLine, sBuffer)
330   fGetLine = Left$(sBuffer, iChrs)


End Function

'----------------------------------------------------------------------
' Name:        fGetLineCount
' Copyright:   (c) 1998 GridLinx Software
' Author:      George Lissauer
' Created:     Saturday, June 20,1998 @ 10:38:52 pm (Vers: 3.0.0000)
'
' Description: Determine the number of text lines in a label or text
'              box.
' Inputs:      ctl - label or text box control
' Assumptions: ctl must be a label or text box
' Results:     returns the number of text lines.
'----------------------------------------------------------------------
Private Function fGetLineCount(ctl As Control) As Long
Dim lCount As Long
349   lCount = SendMessage(ctl.hwnd, EM_GETLINECOUNT, 0&, 0&)
350   fGetLineCount = lCount

End Function

'----------------------------------------------------------------------
' Name:        sCommentBlock
' Copyright:   (c) 1998 GridLinx Software
' Author:      George Lissauer
' Created:     Saturday, June 20,1998 @ 10:31:41 pm (Vers: 3.0.0000)
'
' Description: Extract text from a label or text box line by line and
'              format as a VB Comment Block
' Inputs:      ctl - label or text box control
' Assumptions: ctl must be a label or text box
' Results:     Word wrap VB formatted comment blocK
'----------------------------------------------------------------------

Private Function sCommentBlock(ctl As Control) As String
Dim sText As String
Dim lLines As Long
Dim lLine As Long

372   lLines = fGetLineCount(ctl)
373   sText = ""
374   If lLines > 0 Then
375      sText = sText & "'" & vbCrLf
376      For lLine = 0 To lLines - 1
377         sText = sText & "'" & vbTab & fGetLine(lLine, ctl) & vbCrLf
378      Next lLine
379   End If
380   sText = sText & "'"
381   sCommentBlock = sText
End Function

'----------------------------------------------------------------------
' Name:        ErrMsg
' Copyright:   (c) 1998 GridLinx Software
' Author:      George Lissauer
' Created:     Saturday, June 20,1998 @ 10:25:15 pm (Vers: 3.0.0000)
'
' Description: Public Interface to Display the Error Message
' Inputs:      sMN - Module Name
'              sPN - Procedure Name
'              iLine - Line Number of Error
'              lErr - Error Number
'              vErrCat - [Optional] User Defined Error Category
' Results:     Err Form's labels are filled and Form Displayed
'----------------------------------------------------------------------

Public Sub ErrMsg(sMN As String, sPN As String, iLine As Integer, lErr As Long, Optional vErrCat)
400   lblModuleTxt.Caption = sMN
401   lblProcTxt.Caption = sPN
402   lblLineNumTxt.Caption = Str$(iLine)
403   lblErrNumTxt.Caption = Str$(lErr)
404   If IsMissing(vErrCat) Then
405      lblErrCatTxt.Caption = "Visual Basic Error"
406   Else
407      lblErrCatTxt.Caption = vErrCat
408   End If
409   lblErrDescTxt.Caption = Error$(lErr)
410   Me.Show vbModal
End Sub

'----------------------------------------------------------------------
' Name:        ShortPath
' Copyright:   (c) 1998 GridLinx Software
' Author:      George Lissauer
' Created:     Saturday, June 20,1998 @ 7:11:28 pm (Vers: 3.0.0000)
'
' Description: Fit a long file path into a limited number of chars.
'              "C:\Program Files\My Very Long Program Name -->
'              "C:\...\My Very Long Program Name
'
' Inputs:      sPath - The long full path name
'              iMaxLen - Maximum number of characters in resulting short path
' Assumptions: For most effective results, put full path in tool tip of control
' Results:     The short path <= iMaxLen characters
'----------------------------------------------------------------------
Private Function ShortPath(sPath As String, iMaxLen As Integer) As String
429   Const DRIVE_LENGTH = 3         'Length of Drive, colon & slash in path
Dim sLeft As String            'Left part of Path
Dim sRight As String           'Right part of Path
Dim iNextPos As Integer        'Position of Next "\"
Dim iStart As Integer          'Position to start from
434   If Len(sPath) <= iMaxLen Then
435      ShortPath = sPath
436      Exit Function
437   End If
438   iStart = DRIVE_LENGTH + 1                 'Start looking after Drive:\
439   sLeft = Left$(sPath, DRIVE_LENGTH)        'Extract the drive from full path
440   sRight = Right$(sPath, Len(sPath) - 3)    'Remove drive from right part
441   Do While Len(sLeft & sRight) > iMaxLen    'Do until path shorter than Max Length
442      iNextPos = InStr(iStart, sPath, "\")   'Find next "\" in path
443      If iNextPos = 0 Then Exit Do           'Exit if no more "\" in path
444      sLeft = sLeft & "...\"                 'Add another ...\ to short path
445      sRight = Right$(sPath, Len(sPath) - iNextPos)   '
446      iStart = iNextPos + 1
447   Loop
448   ShortPath = sLeft & sRight
End Function
