Attribute VB_Name = "mExecCmd"
'----------------------------------------------------------------------
' Module Name: mExecCmd
' Author:      George Lissauer
' Created:     Saturday, June 20,1998 @ 5:17:14 pm (Vers: 1.0.0000)
'
' Description: Exec Command Implementation. This code is from
'              http://www.jelsoft.com/vbw/ Tips.
'
'----------------------------------------------------------------------
' Disclaimer of Warranty:
'
' This software and the accompanying files are provided "as is"
' and without warranties as to performance of the software and
' the accompanying files or any other warranties whether expressed
' or implied.  No warranty of fitness for a particular purpose
' is offered.
'
' You MAY NOT sell this software or it's source code.
' You MAY use this code in any way you find useful.
'------------------------------------------------------------------------
Option Explicit

Private Type STARTUPINFO
    cb As Long
    lpReserved As String
    lpDesktop As String
    lpTitle As String
    dwX As Long
    dwY As Long
    dwXSize As Long
    dwYSize As Long
    dwXCountChars As Long
    dwYCountChars As Long
    dwFillAttribute As Long
    dwFlags As Long
    wShowWindow As Integer
    cbReserved2 As Integer
    lpReserved2 As Long
    hStdInput As Long
    hStdOutput As Long
    hStdError As Long
End Type

Private Type PROCESS_INFORMATION
    hProcess As Long
    hThread As Long
    dwProcessID As Long
    dwThreadID As Long
End Type

Declare Function WaitForSingleObject Lib _
"kernel32" (ByVal hHandle As Long, ByVal dwMilliseconds _
As Long) As Long

Declare Function CreateProcessA Lib "kernel32" _
   (ByVal lpApplicationName As Long, ByVal lpCommandLine As _
   String, ByVal lpProcessAttributes As Long, ByVal _
   lpThreadAttributes As Long, ByVal bInheritHandles As Long, _
   ByVal dwCreationFlags As Long, ByVal lpEnvironment As Long, _
   ByVal lpCurrentDirectory As Long, lpStartupInfo As _
   STARTUPINFO, lpProcessInformation As PROCESS_INFORMATION) _
   As Long

Declare Function CloseHandle Lib "kernel32" (ByVal hObject _
As Long) As Long

Private Const NORMAL_PRIORITY_CLASS = &H20&
Private Const INFINITE = -1&

'----------------------------------------------------------------------
' Name:        ExecCmd
' Author:      George Lissauer
' Created:     Saturday, June 20,1998 @ 5:20:06 pm (Vers: 1.0.0000)
'
' Description: Shell an application and wait for it to finish
' Inputs:      sCmdLine - Application Start Command
' Results:     Returns when the application finishes.
'----------------------------------------------------------------------

Public Sub ExecCmd(sCmdLine As String)
Dim lRet As Long        'Return
Dim proc As PROCESS_INFORMATION
Dim start As STARTUPINFO

' Initialize the STARTUPINFO structure:
start.cb = Len(start)

' Start the shelled application:
lRet = CreateProcessA(0&, sCmdLine, 0&, 0&, 1&, _
NORMAL_PRIORITY_CLASS, 0&, 0&, start, proc)

' Wait for the shelled application to finish:
lRet = WaitForSingleObject(proc.hProcess, INFINITE)
lRet = CloseHandle(proc.hProcess)
End Sub

