#include <stdio.h>

#import "YSock.tlb"
using namespace YuriSock;


struct StartUpCom {
    StartUpCom() { CoInitialize(NULL); }
    ~StartUpCom() { CoUninitialize(); }
} _global_com_inst;

void dump_com_error(_com_error &e)
{
    printf("COM error\n");
    printf("\tCode = %08lx\n", e.Error());
    printf("\tCode meaning = %s\n", e.ErrorMessage());
    _bstr_t bstrSource(e.Source());
    _bstr_t bstrDescription(e.Description());
    printf("\tSource = %s\n", (LPCTSTR) bstrSource);
    printf("\tDescription = %s\n", (LPCTSTR) bstrDescription);
}

void main(int argc, char **argv)
{
	if (argc < 2) {
		printf("Use: whois <domain>\n\n");
		return;
	}

	ISSockPtr pSock;

    try {
		HRESULT hr = pSock.CreateInstance(__uuidof(SSock));
		if (FAILED(hr)) _com_issue_error(hr);

		if (!pSock->Connect("rs.internic.net", 43)) {
			printf("Can not connect to internic.net\n");
			return;
		}
		pSock->WriteLn(argv[1]);
		_bstr_t bstr;
		do {
			bstr = pSock->Read(30);
			printf(bstr);
		} while (bstr.length() > 0);
		pSock->Close();
    } 
	catch(_com_error& e) {
		dump_com_error(e);
		return;
	}
}
