VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Begin VB.Form frmVINDecoder 
   Caption         =   "ESP Data Solutions"
   ClientHeight    =   6555
   ClientLeft      =   2280
   ClientTop       =   1845
   ClientWidth     =   5295
   Icon            =   "VDActiveXTest.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   Picture         =   "VDActiveXTest.frx":000C
   ScaleHeight     =   6555
   ScaleWidth      =   5295
   Begin VB.Frame frmMessage 
      Height          =   855
      Left            =   1080
      TabIndex        =   9
      Top             =   60
      Width           =   4095
      Begin VB.Label lblMessage 
         Caption         =   $"VDActiveXTest.frx":135AE
         Height          =   615
         Left            =   120
         TabIndex        =   10
         Top             =   180
         Width           =   3855
      End
   End
   Begin ComctlLib.ListView lvwValues 
      Height          =   2775
      Left            =   1080
      TabIndex        =   8
      Top             =   1920
      Width           =   4095
      _ExtentX        =   7223
      _ExtentY        =   4895
      View            =   3
      LabelEdit       =   1
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327682
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   2
      BeginProperty ColumnHeader(1) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Data"
         Object.Width           =   2117
      EndProperty
      BeginProperty ColumnHeader(2) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   1
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Value"
         Object.Width           =   3599
      EndProperty
   End
   Begin VB.CommandButton cmdClear 
      Caption         =   "&Clear"
      Height          =   315
      Left            =   1140
      TabIndex        =   2
      Top             =   6120
      Width           =   1275
   End
   Begin VB.ListBox lstVDReturnValues 
      Height          =   840
      ItemData        =   "VDActiveXTest.frx":1364C
      Left            =   1080
      List            =   "VDActiveXTest.frx":1364E
      TabIndex        =   1
      Top             =   5100
      Width           =   4095
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "&Exit"
      Height          =   315
      Left            =   3900
      TabIndex        =   4
      Top             =   6120
      Width           =   1275
   End
   Begin VB.TextBox tbVIN 
      Height          =   285
      Left            =   1080
      TabIndex        =   0
      Text            =   "1G1YY23P0N5116446"
      Top             =   1260
      Width           =   2655
   End
   Begin VB.CommandButton cmdDecode 
      Caption         =   "&Decode VIN"
      Height          =   315
      Left            =   2520
      TabIndex        =   3
      Top             =   6120
      Width           =   1275
   End
   Begin VB.Label lblField 
      BackStyle       =   0  'Transparent
      Caption         =   "Decoded Data"
      Height          =   195
      Index           =   1
      Left            =   1080
      TabIndex        =   7
      Top             =   1680
      Width           =   2175
   End
   Begin VB.Label lblField 
      BackStyle       =   0  'Transparent
      Caption         =   "VIN Decoder return values"
      Height          =   195
      Index           =   7
      Left            =   1080
      TabIndex        =   6
      Top             =   4860
      Width           =   2175
   End
   Begin VB.Label lblField 
      BackStyle       =   0  'Transparent
      Caption         =   "Vehicle Identification Number"
      Height          =   195
      Index           =   0
      Left            =   1080
      TabIndex        =   5
      Top             =   1020
      Width           =   2175
   End
End
Attribute VB_Name = "frmVINDecoder"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'
'
 Private vd As VINDecoderDemo
'

'
'
 Private stdValues(10) As String
 Private Const vdStdValueCount = 9
'

' VIN Decoder Constants
'
 Private Const vdDecodeOK = 0
 Private Const vdIllegalChar = 1
 Private Const vdLenToShort = 2
 Private Const vdLenToLong = 3
 Private Const vdBadCheckDigit = 4
 Private Const vdVehicleUnavailable = 5
 Private Const vdYearUnavailable = 6
 Private Const vdError = 7
 Private Const vdInitError = 8
 Private Const vdErrorShutdown = 10
 Private Const vdUserDisabled = 11
'

Sub decodeVin()
 
 Dim n  As Integer
 Dim rv As Long
 
 Dim li As ListItem

 ' case out VIN decoders return value
 '
  clearControls
  rv = vd.decodeVin(tbVIN.Text)
       
   Select Case rv

    Case vdDecodeOK           ' VIN decoded successfully
     
     lstVDReturnValues.AddItem "VIN Decoded successfully"
         
     For n = 1 To vdStdValueCount
       Set li = lvwValues.ListItems.Add(, , stdValues(n))
       li.SubItems(1) = vd.QueryStdValue(LCase(stdValues(n)))
     Next n
         
     getNonStdValues
       
    Case vdIllegalChar        ' VIN contains an illegal character
     lstVDReturnValues.AddItem "VIN Number contains illegal characters"
     
    Case vdLenToShort         ' VIN to Short  < 10
     lstVDReturnValues.AddItem "VIN to short to decode"
     
    Case vdLenToLong          ' VIN to long   > 17
     lstVDReturnValues.AddItem "VIN Execeds 17 characters"
     
    Case vdBadCheckDigit      ' Bad check digit
     lstVDReturnValues.AddItem "VIN is incorrect"
     
    Case vdVehicleUnavailable ' vehicle is unavailable
     lstVDReturnValues.AddItem "This vehicle is unavailable in the demo database"
    
    Case vdYearUnavailable    ' unavailable year for vehicle
     lstVDReturnValues.AddItem "The model year for this vehicle is unavailable"
     
    Case vdInitError          ' previously an initialization error
     lstVDReturnValues.AddItem "Initialization Failure"
     showError
     
    Case vdErrorShutdown      ' a fatal error occured and object is shutdown
     lstVDReturnValues.AddItem "Fatal error - shutdown flag set"
     showError
        
    Case vdUserDisabled       ' user disabled
     lstVDReturnValues.AddItem "User disabled"
         
    Case vdError              ' a runtime error occured
     lstVDReturnValues.AddItem "An error occured"
     showError
     
   End Select
    
 'Debug.Assert Not vd.IsError

End Sub

Private Sub getNonStdValues()

 Dim description As String
 Dim value       As String
 Dim rv          As Boolean
 Dim li          As ListItem
   
 ' query non standard values and add to list
 '
  If vd.QueryFirstNonStd(description, value) Then
   
   Set li = lvwValues.ListItems.Add(, , description)
   li.SubItems(1) = value
        
    Do
     
     rv = vd.QueryNextNonStd(description, value)
     
     If rv Then
       Set li = lvwValues.ListItems.Add(, , description)
       li.SubItems(1) = value
     End If
     
    Loop While rv
    
  End If
 '

End Sub

Private Sub loadStdValuesArray()
 
 ' fill array with standard value types for later use
 '
  stdValues(1) = "Year"
  stdValues(2) = "Make"
  stdValues(3) = "Model"
  stdValues(4) = "Body"
  stdValues(5) = "Engine"
  stdValues(6) = "Assembly"
  stdValues(7) = "ProductionID"
  stdValues(8) = "Country"
  stdValues(9) = "CheckDigit"
 '
 
End Sub

Private Sub showError()
 
 Dim err_no     As Long
 Dim err_origin As Long
 Dim err_type   As String
 
 ' get the last error that occured and dump to listbox
 '
  vd.GetLastError err_no, err_type, err_origin
  
  lstVDReturnValues.AddItem "Error Type   -> " & err_type & "   " & _
                            "Error Number -> " & err_no & "   " & _
                            "Error Origin -> " & err_origin
 '
 
End Sub

Private Sub cmdClear_Click()
  clearControls
End Sub

Private Sub cmdDecode_Click()
  decodeVin
End Sub

Private Sub cmdExit_Click()
  Unload Me
End Sub

Private Sub Form_Load()
 
 Dim rv As Long
 
 ' create a new instance of VIN Decoder and initialize
 '
 '  initialize returns false on fail, true on ok
 '
  Set vd = New VINDecoderDemo
 
   If vd.Initialize Then
     lstVDReturnValues.AddItem "VIN Decoder Initialized Ok"
    Else
       lstVDReturnValues.AddItem "Initialization Error"
       lstVDReturnValues.AddItem "Shutdown flag set"
   End If
 
  loadStdValuesArray
 '
 
End Sub

Private Sub Form_Unload(Cancel As Integer)
 
 ' destroy VIN Decoder
 '
  Set vd = Nothing
 '
 
End Sub

Private Sub tbVIN_KeyPress(KeyAscii As Integer)
 
 ' if user hit enter the enter key
 '
  If KeyAscii = 13 Then
    decodeVin
    KeyAscii = 0
  End If
 '
 
End Sub

Private Sub clearControls()
 
 ' clear lists
 '
  lvwValues.ListItems.Clear
  lstVDReturnValues.Clear
 '
 
End Sub
