Attribute VB_Name = "VBCGIModule"
' -------------------------------------------------------------------
' | VB CGI Module v1.12                                             |
' | Copyright (C) 1998-99 Aran Meuser                               |
' | All Rights Reserved                                             |
' |                                                                 |
' | WWW Address: www.northcoast.com/~aran/                          |
' | E-Mail Address: aran@northcoast.com                             |
' -------------------------------------------------------------------
Option Explicit

Public CGI_Cookies As SimpleArray
Public CGI_Inputs As SimpleArray
Public CGI_WriteLog As Boolean

Private InPipe As Long
Private OutPipe As Long
Private i As Integer
Private j As Integer
Private LogFileNum As Integer

' Environment Variables:
Public CGI_Accept            As String
Public CGI_AuthType          As String
Public CGI_ContentLength     As String
Public CGI_ContentType       As String
Public CGI_Cookie            As String
Public CGI_GatewayInterface  As String
Public CGI_PathInfo          As String
Public CGI_PathTranslated    As String
Public CGI_QueryString       As String
Public CGI_Referer           As String
Public CGI_RemoteAddr        As String
Public CGI_RemoteHost        As String
Public CGI_RemoteIdent       As String
Public CGI_RemoteUser        As String
Public CGI_RequestMethod     As String
Public CGI_ScriptName        As String
Public CGI_ServerSoftware    As String
Public CGI_ServerName        As String
Public CGI_ServerPort        As String
Public CGI_ServerProtocol    As String
Public CGI_UserAgent         As String

' STD API Stuff:
Private Const STD_INPUT_HANDLE = -10&
Private Const STD_OUTPUT_HANDLE = -11&

Private Declare Function GetStdHandle Lib "kernel32" ( _
    ByVal nStdHandle As Long _
) As Long

Private Declare Function WriteFile Lib "kernel32" ( _
    ByVal hFile As Long, _
    lpBuffer As Any, _
    ByVal nNumberOfBytesToWrite As Long, _
    lpNumberOfBytesWritten As Long, _
    ByVal lpOverlapped As Long _
) As Long

Private Declare Function ReadFile Lib "kernel32" ( _
    ByVal hFile As Long, _
    lpBuffer As Any, _
    ByVal nNumberOfBytesToRead As Long, _
    lpNumberOfBytesRead As Long, _
    ByVal lpOverlapped As Long _
) As Long
Public Sub CGI_AddLog(LogLine As String)
    ' ---------------------------------------------------
    ' | PURPOSE: Appends a string to the bottom of the  |
    ' |   log file.                                     |
    ' | ASSUMPTIONS: LofFileNum is set in CGIInit(),    |
    ' |   CGI_WriteLog defines whether or not to write  |
    ' |   to a log file and should be set befire        |
    ' |   calling any other function in this module.    |
    ' | INPUTS: LogLine: A single line of text.         |
    ' ---------------------------------------------------
    
    If CGI_WriteLog Then
        Print #LogFileNum, LogLine
    End If
End Sub

Public Sub CGISendBinary( _
    ByVal ByteArray As Variant, _
    ByVal ContentType As String _
)
    Dim Bytes() As Byte
    Dim NumBytes As Long
    Dim NumWritten As Long
    Dim Header As String
    
    CGI_AddLog "Start CGISendBinary()"
    CGI_AddLog "  ContentType=" & ContentType
    
    NumBytes = UBound(ByteArray) - LBound(ByteArray) + 1
    CGI_AddLog "  NumBytes=" & NumBytes
    
    Header = "Status: 200 OK" & vbCrLf & _
    "Content-type: " & ContentType & vbCrLf & vbCrLf & vbCrLf
    
    j = LBound(ByteArray)
    
    ReDim Bytes(1 To NumBytes + Len(Header))
    For i = 1 To NumBytes + Len(Header)
        If i > Len(Header) Then
            Bytes(i) = ByteArray(j)
            j = j + 1
        Else
            Bytes(i) = Asc(Mid(Header, i, 1))
        End If
    Next i
    WriteFile OutPipe, Bytes(1), NumBytes, NumWritten, 0
    CGI_AddLog "End CGISendBinary()"
End Sub

Public Sub CGISendNoContent()
    Dim Header As String
    Dim Bytes() As Byte
    Dim NumWritten As Long
    
    CGI_AddLog "Start CGISendNoContent()"
    
    Header = "Status: 204 No Content" & vbCrLf
    
    ReDim Bytes(1 To Len(Header))
    For i = 1 To Len(Header)
        Bytes(i) = Asc(Mid(Header, i, 1))
    Next i
    WriteFile OutPipe, Bytes(1), CLng(Len(Header)), NumWritten, 0

    CGI_AddLog "End CGISendNoContent()"
End Sub

Public Sub CGIInit()
    If CGI_WriteLog Then
        LogFileNum = FreeFile
        On Error Resume Next
            Kill App.Path & "\" & App.EXEName & ".log"
        On Error GoTo 0
        Open App.Path & "\" & App.EXEName & ".log" For Append As LogFileNum
    End If
    
    CGI_AddLog "Start CGIInit()"
    InPipe = GetStdHandle(STD_INPUT_HANDLE)
    CGI_AddLog "  InPipe=" & InPipe
    OutPipe = GetStdHandle(STD_OUTPUT_HANDLE)
    CGI_AddLog "  OutPipe=" & OutPipe
    
    CGI_Accept = Environ("HTTP_ACCEPT")
    CGI_AuthType = Environ("AUTH_TYPE")
    CGI_ContentLength = Environ("CONTENT_LENGTH")
    CGI_ContentType = Environ("CONTENT_TYPE")
    CGI_Cookie = Environ("HTTP_COOKIE")
    CGI_GatewayInterface = Environ("GATEWAY_INTERFACE")
    CGI_PathInfo = Environ("PATH_INFO")
    CGI_PathTranslated = Environ("PATH_TRANSLATED")
    CGI_QueryString = Environ("QUERY_STRING")
    CGI_Referer = Environ("HTTP_REFERER")
    CGI_RemoteAddr = Environ("REMOTE_ADDR")
    CGI_RemoteHost = Environ("REMOTE_HOST")
    CGI_RemoteIdent = Environ("REMOTE_IDENT")
    CGI_RemoteUser = Environ("REMOTE_USER")
    CGI_RequestMethod = Environ("REQUEST_METHOD")
    CGI_ScriptName = Environ("SCRIPT_NAME")
    CGI_ServerSoftware = Environ("SERVER_SOFTWARE")
    CGI_ServerName = Environ("SERVER_NAME")
    CGI_ServerPort = Environ("SERVER_PORT")
    CGI_ServerProtocol = Environ("SERVER_PROTOCOL")
    CGI_UserAgent = Environ("HTTP_USER_AGENT")
    CGI_AddLog "  Environment Variables Read."
    
    Set CGI_Cookies = New SimpleArray
    Set CGI_Inputs = New SimpleArray
    
    ReadForm
    ReadCookie
    CGI_AddLog "End CGIInit()"
End Sub

Private Sub ReadForm()
    Dim Query As String
    Dim NumRead As Long
    Dim Bytes() As Byte
    Set CGI_Inputs = New SimpleArray
    
    CGI_AddLog "  Start ReadForm()"
    If CGI_RequestMethod = "GET" Then
        Query = CGI_QueryString
    ElseIf CGI_RequestMethod = "POST" Then
        ReDim Bytes(1 To Val(CGI_ContentLength))
        ReadFile InPipe, Bytes(1), Val(CGI_ContentLength), NumRead, 0
        For i = 1 To Val(CGI_ContentLength)
            Query = Query & Chr(Bytes(i))
        Next i
    Else
        CGI_AddLog "    Exiting, CGI_RequestMethod is empty."
        Exit Sub
    End If
    CGI_AddLog "    CGI_RequestMethod=" & CGI_RequestMethod
    CGI_AddLog "    Query=" & Query

    Dim InVal As Boolean
    Dim Name As String
    Dim Value As String

    For i = 1 To Len(Query) + 1
        If Mid(Query, i, 1) = "&" Or i = Len(Query) + 1 Then
            Name = UrlDecode(Name)
            Value = UrlDecode(Value)
            CGI_Inputs.Add Value, Name
            CGI_AddLog "    " & Name & "=" & Value & " Added to CGI_Inputs SimpleArray."
            InVal = False
            Name = ""
            Value = ""
        ElseIf Mid(Query, i, 1) = "=" Then
            InVal = True
        ElseIf InVal Then
            Value = Value & Mid(Query, i, 1)
        Else
            Name = Name & Mid(Query, i, 1)
        End If
    Next i
    CGI_AddLog "  End ReadForm()"
End Sub

Private Sub ReadCookie()
    If CGI_Cookie > "" Then
        Dim Name As String
        Dim Value As String
        Dim InVal As Boolean
        
        CGI_AddLog "  Start ReadCookie()"
        CGI_AddLog "    CGI_Cookie=" & CGI_Cookie
        For i = 1 To Len(CGI_Cookie) + 1
            If Mid(CGI_Cookie, i, 1) = ";" Or _
            i = Len(CGI_Cookie) + 1 Then
                Name = UrlDecode(Name)
                Value = UrlDecode(Value)
                CGI_Cookies.Add Value, Name, "/"
                CGI_AddLog "    " & Name & "=" & Value & " Added to CGI_Cookies SimpleArray."
                Name = ""
                Value = ""
                InVal = False
            ElseIf Mid(CGI_Cookie, i, 1) = "=" Then
                InVal = True
            ElseIf InVal Then
                Value = Value & Mid(CGI_Cookie, i, 1)
            Else
                Name = Name & Mid(CGI_Cookie, i, 1)
            End If
        Next i
        CGI_AddLog "  End ReadCookie()"
    End If
End Sub


Public Sub CGISendRedirect( _
    ByVal Location As String _
)
    Dim Bytes() As Byte
    Dim NumWritten As Long
    
    CGI_AddLog "Start CGISendRedirect()"
    CGI_AddLog "  Location=" & Location
    
    Location = "Status: 302 redirection" & vbCrLf & _
    "Location: " & Location & vbCrLf
    
    ReDim Bytes(1 To Len(Location))
    For i = 1 To Len(Location)
        Bytes(i) = Asc(Mid(Location, i, 1))
    Next i
    WriteFile OutPipe, Bytes(1), CLng(Len(Location)), NumWritten, 0
    
    CGI_AddLog "End CGISendRedirect()"
End Sub

Private Function URLEncode( _
    InString As String _
) As String
    Dim ThisChar As String
    
    For j = 1 To Len(InString)
        ThisChar = Mid(InString, j, 1)
        If Not InStr(1, "abcdefghijklmnopqrstuvwxyz0123456789.-_* ", LCase(ThisChar), vbTextCompare) Then
            ThisChar = Hex(Asc(ThisChar))
            If Len(ThisChar) = 1 Then ThisChar = "0" & ThisChar
            ThisChar = "%" & ThisChar
        ElseIf ThisChar = " " Then
            ThisChar = "+"
        End If
        URLEncode = URLEncode & ThisChar
    Next j
End Function

Private Function UrlDecode( _
    InString As String _
) As String
    Dim InCode As Boolean
    Dim ThisCode As String

    For j = 1 To Len(InString)
        If InCode Then
            ThisCode = ThisCode & Mid(InString, j, 1)
        ElseIf Mid(InString, j, 1) = "+" Then
            UrlDecode = UrlDecode & " "
        ElseIf Mid(InString, j, 1) = "%" Then
            InCode = True
        Else
            UrlDecode = UrlDecode & Mid(InString, j, 1)
        End If
    
        If Len(ThisCode) = 2 Then
            UrlDecode = UrlDecode & Chr("&H" & ThisCode)
            InCode = False
            ThisCode = ""
        End If
    Next j
End Function

Public Sub CGISendText( _
    ByVal OutString As String, _
    Optional ByVal WriteCookie As Boolean = False, _
    Optional ByVal CookieDate As Date = #1/1/1980#, _
    Optional ByVal CookieDomain As String = "127.0.0.1", _
    Optional ByVal ContentType As String = "text/html" _
)
    Dim Bytes() As Byte
    Dim NumWritten As Long
    Dim Header As String
    
    CGI_AddLog "Start CGISendText()"
    CGI_AddLog "  len(OutString)=" & Len(OutString)
    CGI_AddLog "  WriteCookie=" & WriteCookie
    CGI_AddLog "  CookieDate=" & Format(CookieDate, "dddd, dd-mmm-yy hh:mm:ss")
    CGI_AddLog "  CookieDomain=" & CookieDomain
    CGI_AddLog "  ContentType=" & ContentType
    
    Header = "Status: 200 OK" & vbCrLf & _
    "Content-type: " & ContentType & vbCrLf
    If CGI_Cookies.Count > 0 And WriteCookie Then
        For i = 1 To CGI_Cookies.Count
        Header = Header & "Set-Cookie: " & URLEncode(CGI_Cookies.Key(i)) & "=" & URLEncode(CGI_Cookies(i)) & "; " & _
        "expires=" & Format(CookieDate, "dddd, dd-mmm-yy hh:mm:ss") & "GMT; " & _
        "path=" & CGI_Cookies.Tag(i) & "; " & _
        "domain=" & CookieDomain & vbCrLf
        Next i
    End If
    CGI_AddLog "  Header=" & Replace(Header, vbCrLf, "|")
    Header = Header & vbCrLf
    OutString = Header & vbCrLf & OutString
    
    ReDim Bytes(1 To Len(OutString))
    For i = 1 To Len(OutString)
        Bytes(i) = Asc(Mid(OutString, i, 1))
    Next i
    WriteFile OutPipe, Bytes(1), CLng(Len(OutString)), NumWritten, 0

    CGI_AddLog "End CGISendText()"
End Sub

