VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Object = "{98EE8BF5-5C7A-11D2-AD63-004005448951}#4.1#0"; "SWBTOOLBAR.OCX"
Begin VB.Form TestForm 
   Caption         =   "SWBCoolbar Demonstration"
   ClientHeight    =   5115
   ClientLeft      =   165
   ClientTop       =   450
   ClientWidth     =   7395
   LinkTopic       =   "Form1"
   ScaleHeight     =   5115
   ScaleWidth      =   7395
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame CaptionPosFrame 
      Caption         =   "Caption Position"
      Enabled         =   0   'False
      Height          =   690
      Left            =   4230
      TabIndex        =   19
      Top             =   3195
      Width           =   1815
      Begin VB.OptionButton CaptionRightOpt 
         Caption         =   "Right"
         Enabled         =   0   'False
         Height          =   195
         Left            =   1035
         TabIndex        =   21
         Top             =   315
         Width           =   735
      End
      Begin VB.OptionButton CaptionBottomOpt 
         Caption         =   "Bottom"
         Enabled         =   0   'False
         Height          =   195
         Left            =   90
         TabIndex        =   20
         Top             =   315
         Value           =   -1  'True
         Width           =   915
      End
   End
   Begin SWBCoolbarCtl.SWBCoolbar SWBCoolbar1 
      Align           =   1  'Align Top
      Height          =   555
      Left            =   0
      TabIndex        =   2
      Top             =   0
      Width           =   7395
      _ExtentX        =   13044
      _ExtentY        =   979
      ShowCaptions    =   0   'False
      MaskColor       =   0
      DockingGap      =   300
      Dockable        =   0   'False
      BarHeight       =   555
      Object.Width           =   7395
      Object.Height          =   555
      ShowTips        =   0   'False
   End
   Begin VB.Frame CoolbarOptionsFrame 
      Caption         =   "Properties"
      Height          =   2850
      Left            =   1260
      TabIndex        =   8
      Top             =   1035
      Width           =   2850
      Begin VB.CheckBox Grip 
         Caption         =   "Show &Grip"
         Height          =   195
         Left            =   270
         TabIndex        =   16
         Top             =   315
         Value           =   1  'Checked
         Width           =   2200
      End
      Begin VB.CheckBox Disable 
         Caption         =   "Disable/Hide Some &Buttons"
         Height          =   285
         Left            =   270
         TabIndex        =   15
         Top             =   585
         Width           =   2445
      End
      Begin VB.CheckBox Dockable 
         Caption         =   "Doc&kable"
         Height          =   240
         Left            =   270
         TabIndex        =   14
         Top             =   900
         Value           =   1  'Checked
         Width           =   2535
      End
      Begin VB.CheckBox Background 
         Caption         =   "Use Background &Bitmap"
         Height          =   240
         Left            =   270
         TabIndex        =   13
         Top             =   1215
         Width           =   2200
      End
      Begin VB.CheckBox Captions 
         Caption         =   "Show &Captions"
         Height          =   195
         Left            =   270
         TabIndex        =   12
         Top             =   1530
         Width           =   2000
      End
      Begin VB.CheckBox ShowTopLine 
         Caption         =   "Show &Top Line"
         Height          =   285
         Left            =   270
         TabIndex        =   11
         Top             =   1755
         Value           =   1  'Checked
         Width           =   1725
      End
      Begin VB.CheckBox ShowBottomLine 
         Caption         =   "Sh&ow Bottom Line"
         Height          =   330
         Left            =   270
         TabIndex        =   10
         Top             =   2025
         Value           =   1  'Checked
         Width           =   1635
      End
      Begin VB.CheckBox ShowTips 
         Caption         =   "Show T&oolTips"
         Height          =   240
         Left            =   270
         TabIndex        =   9
         Top             =   2385
         Value           =   1  'Checked
         Width           =   1500
      End
   End
   Begin VB.Frame DockingFrame 
      Caption         =   "Docking"
      Height          =   1410
      Left            =   4230
      TabIndex        =   3
      Top             =   1035
      Width           =   1815
      Begin VB.OptionButton DockOpt 
         Caption         =   "Dock Right"
         Height          =   240
         Index           =   3
         Left            =   270
         TabIndex        =   7
         Top             =   1080
         Width           =   1410
      End
      Begin VB.OptionButton DockOpt 
         Caption         =   "Dock Bottom"
         Height          =   240
         Index           =   2
         Left            =   270
         TabIndex        =   6
         Top             =   810
         Width           =   1410
      End
      Begin VB.OptionButton DockOpt 
         Caption         =   "Dock Top"
         Height          =   240
         Index           =   0
         Left            =   270
         TabIndex        =   5
         Top             =   270
         Value           =   -1  'True
         Width           =   1410
      End
      Begin VB.OptionButton DockOpt 
         Caption         =   "Dock Left"
         Height          =   240
         Index           =   1
         Left            =   270
         TabIndex        =   4
         Top             =   540
         Width           =   1410
      End
   End
   Begin VB.PictureBox BackPic 
      Height          =   465
      Left            =   2025
      Picture         =   "TestForm.frx":0000
      ScaleHeight     =   405
      ScaleWidth      =   2160
      TabIndex        =   1
      Top             =   4050
      Visible         =   0   'False
      Width           =   2220
   End
   Begin ComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   330
      Left            =   0
      TabIndex        =   0
      Top             =   4785
      Width           =   7395
      _ExtentX        =   13044
      _ExtentY        =   582
      Style           =   1
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   1
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Object.Width           =   8819
            MinWidth        =   8819
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.Label OrientationLbl 
      Alignment       =   2  'Center
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Horizontal"
      Height          =   285
      Left            =   4230
      TabIndex        =   18
      Top             =   2790
      Width           =   1815
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Current Orientation:"
      Height          =   195
      Left            =   4230
      TabIndex        =   17
      Top             =   2565
      Width           =   1365
   End
   Begin ComctlLib.ImageList ImageList1 
      Left            =   1260
      Top             =   4050
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483633
      ImageWidth      =   16
      ImageHeight     =   15
      MaskColor       =   12632256
      _Version        =   327682
      BeginProperty Images {0713E8C2-850A-101B-AFC0-4210102A8DA7} 
         NumListImages   =   12
         BeginProperty ListImage1 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "TestForm.frx":B178
            Key             =   "New"
            Object.Tag             =   "1"
         EndProperty
         BeginProperty ListImage2 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "TestForm.frx":B6BA
            Key             =   "Open "
            Object.Tag             =   "1"
         EndProperty
         BeginProperty ListImage3 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "TestForm.frx":BBFC
            Key             =   "Save"
            Object.Tag             =   "1"
         EndProperty
         BeginProperty ListImage4 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "TestForm.frx":C13E
            Key             =   "Cut"
            Object.Tag             =   "1"
         EndProperty
         BeginProperty ListImage5 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "TestForm.frx":C680
            Key             =   "Copy "
            Object.Tag             =   "1"
         EndProperty
         BeginProperty ListImage6 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "TestForm.frx":CBC2
            Key             =   "Paste"
            Object.Tag             =   "1"
         EndProperty
         BeginProperty ListImage7 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "TestForm.frx":D104
            Key             =   "Print "
            Object.Tag             =   "1"
         EndProperty
         BeginProperty ListImage8 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "TestForm.frx":D646
            Key             =   "Bold"
            Object.Tag             =   "2"
         EndProperty
         BeginProperty ListImage9 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "TestForm.frx":D758
            Key             =   "Italic"
            Object.Tag             =   "2"
         EndProperty
         BeginProperty ListImage10 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "TestForm.frx":D86A
            Key             =   "Underline"
            Object.Tag             =   "2"
         EndProperty
         BeginProperty ListImage11 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "TestForm.frx":D97C
            Key             =   "Group"
            Object.Tag             =   "2"
         EndProperty
         BeginProperty ListImage12 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "TestForm.frx":DA8E
            Key             =   "UnGroup"
            Object.Tag             =   "2"
         EndProperty
      EndProperty
   End
   Begin VB.Menu BtnMenu 
      Caption         =   "BtnMenu"
      Visible         =   0   'False
      Begin VB.Menu Item1 
         Caption         =   "&Document"
      End
      Begin VB.Menu Item2 
         Caption         =   "&Template"
      End
      Begin VB.Menu Item3 
         Caption         =   "&Project"
      End
   End
End
Attribute VB_Name = "TestForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'==================================================
'  Sample Application for SWBCoolbar Component
'  Software with Brains, Inc.
'  This code may be modified and used at will.
'
'  This program contains a lot of code.  Most of
'  it is not necessary to use the SWBCoolbar
'  control.  It is simply here to show usage of
'  all the various properties and methods.
'  Most options can be set at design time, and
'  only the events required by your application
'  need to be trapped.
'==================================================

'==================================================
'Set or clear the background bitmap on the toolbar
'==================================================
Private Sub Background_Click()
    If (Background.Value = vbChecked) Then
        ImageList1.BackColor = &HC0C0C0
        Set SWBCoolbar1.Background = BackPic
    Else
        ImageList1.BackColor = vbButtonFace
        Set SWBCoolbar1.Background = LoadPicture("")
    End If
End Sub


Private Sub CaptionBottomOpt_Click()
    SWBCoolbar1.CaptionPos = icBottom
    SetBarHeightWidth
End Sub

Private Sub CaptionRightOpt_Click()
    SWBCoolbar1.CaptionPos = icRight
    SetBarHeightWidth
End Sub

'==================================================
'    Add or remove captions on the buttons
'==================================================
Private Sub Captions_Click()
    SWBCoolbar1.ShowCaptions = (Captions.Value = vbChecked)
    
    CaptionPosFrame.Enabled = (Captions.Value = vbChecked)
    CaptionBottomOpt.Enabled = (Captions.Value = vbChecked)
    CaptionRightOpt.Enabled = (Captions.Value = vbChecked)
    
    SetBarHeightWidth
End Sub

'==================================================
'    Show some buttons as disabled or hidden
'==================================================
Private Sub Disable_Click()
    If Disable.Value = vbChecked Then
        SWBCoolbar1.SetButtonState 2, bsDisabled
        SWBCoolbar1.SetButtonState 3, bsDisabled
        SWBCoolbar1.SetButtonState 5, bsInvisible
    Else
        SWBCoolbar1.SetButtonState 2, bsFlat
        SWBCoolbar1.SetButtonState 3, bsFlat
        SWBCoolbar1.SetButtonState 5, bsFlat
    End If
    
    SWBCoolbar1.Refresh
End Sub

'==================================================
' Make the toolbar "detachable" from the main form.
'==================================================
Private Sub Dockable_Click()
    SWBCoolbar1.Dockable = (Dockable.Value = vbChecked)
End Sub

Private Sub DockOpt_Click(Index As Integer)
    'Set the toolbar orientation according to the user's choice.
    'If the toolbar is docked, then set the control's Alignment accordingly.
    Select Case Index
        Case 0:
            SWBCoolbar1.Orientation = tborHorizontal
            If (SWBCoolbar1.Docked) Then SWBCoolbar1.Align = vbAlignTop
        Case 1:
            SWBCoolbar1.Orientation = tborVertical
            If (SWBCoolbar1.Docked) Then SWBCoolbar1.Align = vbAlignLeft
        Case 2:
            SWBCoolbar1.Orientation = tborHorizontal
            If (SWBCoolbar1.Docked) Then SWBCoolbar1.Align = vbAlignBottom
        Case 3:
            SWBCoolbar1.Orientation = tborVertical
            If (SWBCoolbar1.Docked) Then SWBCoolbar1.Align = vbAlignRight
    End Select
    
    'Always set the bar's height and width after changing orientation.
    SetBarHeightWidth
End Sub

'==================================================
'   Set up the toolbar using code rather than
'   at design-time.
'==================================================
Private Sub Form_Load()
    Dim B As Integer
    Dim X As ToolButton
    
    'Set toolbar properties.
    'These can also be set at design-time, but they
    'are shown here as an example of run-time configuration.
    SWBCoolbar1.ImageList = ImageList1.Name
    SWBCoolbar1.Dockable = True
    SWBCoolbar1.DockingGap = 900
    SWBCoolbar1.ImageList = "ImageList1"
    SWBCoolbar1.ShowTips = True
    SWBCoolbar1.ButtonHeight = 400
    SWBCoolbar1.ButtonWidth = 400
    SWBCoolbar1.BarCaption = "Sample Toolbar"
    SWBCoolbar1.CaptionPos = icBottom
    
' ****************************************************************
' This code adds buttons programmatically at run-time.
' Remove the For/Next loop to add buttons at design time.
' ****************************************************************
    SWBCoolbar1.RemoveAllButtons
    For B = 1 To ImageList1.ListImages.Count
        'This IF-BLOCK adds "separators" between some buttons.
        If (B = 4) Or (B = 7) Or (B = 8) Or (B = 11) Then
            SWBCoolbar1.AddButton "", 0, Style:=tbSeparator
        End If

        'Add each button with its image.
        'Refresh is False to avoid excess painting at this time.
        'We will refresh once at the end when all buttons have
        'been added and configured.
        SWBCoolbar1.AddButton ImageList1.ListImages(B).Key, B, _
                              Style:=CInt(ImageList1.ListImages(B).Tag), _
                              Key:=Trim(ImageList1.ListImages(B).Key), _
                              ToolTip:=ImageList1.ListImages(B).Key
                              
    Next B

    'This code sets some of the buttons to special types.
    'The New and Print buttons are drop-down menu buttons.
    'The Bold/Italic/Underline buttons are grouped together.
    SWBCoolbar1.Buttons("New").Style = tbDropMenu
    SWBCoolbar1.Buttons("Print").Style = tbDropMenu
    SWBCoolbar1.Buttons("Group").PictureDown = 12
    SWBCoolbar1.Buttons("Bold").Group = 1
    SWBCoolbar1.Buttons("Italic").Group = 1
    SWBCoolbar1.Buttons("Underline").Group = 1
    SWBCoolbar1.RemoveButton "Ungroup"

    'Refresh the toolbar now that all the buttons have been added.
    SWBCoolbar1.Refresh
' ****************************************************************

End Sub

'==================================================
' Restrict the size of the main form (not required).
'==================================================
Private Sub Form_Resize()
    If (Me.WindowState = vbNormal) Then
        If (TestForm.Width < 5500) Then TestForm.Width = 5500
        If (TestForm.Width > 9500) Then TestForm.Width = 9500
        If (TestForm.Height < 3200) Then TestForm.Height = 3200
    End If
End Sub

'==================================================
'      Add or remove the toolbar grip
'==================================================
Private Sub Grip_Click()
    SWBCoolbar1.ShowGrip = (Grip.Value = vbChecked)
End Sub

'==================================================
'    Popup Menu Choices (for DropMenu button)
'==================================================
Private Sub Item1_Click()
    If (SWBCoolbar1.Buttons("New").State = bsMenuDown) Then
        Form1.Show vbModal
    Else
        MsgBox "Document Selected", , "DropMenu Selection"
    End If
End Sub

Private Sub Item2_Click()
    MsgBox "Template Selected", , "DropMenu Selection"
End Sub

Private Sub Item3_Click()
    MsgBox "Project Selected", , "DropMenu Selection"
End Sub



'==================================================
'      Add or remove the top/bottom 3D lines
'      on the toolbar.
'==================================================
Private Sub ShowBottomLine_Click()
   SWBCoolbar1.ShowBottomLine = (ShowBottomLine.Value = vbChecked)
End Sub

Private Sub ShowTopLine_Click()
    SWBCoolbar1.ShowTopLine = (ShowTopLine.Value = vbChecked)
End Sub

'==================================================
'   Turn pop-up help tips (tooltips) on or off.
'==================================================
Private Sub ShowTips_Click()
    SWBCoolbar1.ShowTips = (ShowTips.Value = vbChecked)
End Sub

'==================================================
'              Toolbar Events
'==================================================
Private Sub SWBCoolbar1_BeginDrag()
    StatusBar1.SimpleText = "Starting to drag"
End Sub

Private Sub SWBCoolbar1_ButtonClick(Button As MouseButtonConstants, Shift As Integer, X As Single, Y As Single, Position As Integer, Key As String, State As ButtonState)
    StatusBar1.SimpleText = "ButtonClick Event: Position = " & Position & "   Key = '" & Key & "'   State = "
    
    'Display the current state of the button clicked.
    Select Case State
        Case bsFlat:
            StatusBar1.SimpleText = StatusBar1.SimpleText + "Flat"
        Case bsDown:
            StatusBar1.SimpleText = StatusBar1.SimpleText + "Down"
        Case bsUp:
            StatusBar1.SimpleText = StatusBar1.SimpleText + "Up"
        Case bsDisabled:
            StatusBar1.SimpleText = StatusBar1.SimpleText + "Disabled"
    End Select
    
    If Position = 1 Then Form1.Show vbModal
End Sub

Private Sub SWBCoolbar1_ButtonDown(Button As MouseButtonConstants, Shift As Integer, X As Single, Y As Single, Position As Integer, Key As String)
    StatusBar1.SimpleText = "ButtonDown Event: Position =" & Position & "   Key = '" & Key & "'   State = "
    StatusBar1.SimpleText = StatusBar1.SimpleText + "Down"
End Sub

Private Sub SWBCoolbar1_ButtonDropMenu(Position As Integer, Key As String, MenuX As Single, MenuY As Single)
    StatusBar1.SimpleText = "ButtonDropMenu Event: Position =" & Position & "   Key = '" & Key & "'   State = "
    StatusBar1.SimpleText = StatusBar1.SimpleText + "MenuDown"
    
    'The DropMenu event tells the calling main application where to position the menu's
    'upper-left corner by returning the MenuX and MenuY parameters.
    PopupMenu BtnMenu, X:=MenuX, Y:=MenuY
End Sub

Private Sub SWBCoolbar1_EndDrag()
    StatusBar1.SimpleText = "Ending Drag;   Docked = " & SWBCoolbar1.Docked
End Sub

Private Sub SWBCoolbar1_OrientationChanged(NewDirection As SWBCoolbarCtl.ToolbarOrientation)
    OrientationLbl.Caption = IIf(SWBCoolbar1.Orientation = tborHorizontal, "Horizontal", "Vertical")
    SetBarHeightWidth
End Sub

Private Sub SWBCoolbar1_ReDock()
    DockingFrame.Enabled = True
    Captions.Enabled = True
    
    StatusBar1.SimpleText = "Redocking;   Docked = " & SWBCoolbar1.Docked
    
    Select Case SWBCoolbar1.Align
        Case vbAlignTop:
            DockOpt(0).Value = True
        Case vbAlignLeft
            DockOpt(1).Value = True
        Case vbAlignBottom
            DockOpt(2).Value = True
        Case vbAlignRight
            DockOpt(3).Value = True
    End Select
End Sub

Private Sub SWBCoolbar1_Resize()
    StatusBar1.SimpleText = "Resize;   Docked = " & SWBCoolbar1.Docked
End Sub

Private Sub SWBCoolbar1_UnDock()
    StatusBar1.SimpleText = "Undocking;   Docked = " & SWBCoolbar1.Docked
End Sub


'==================================================
'     Set the proper height and width for the
'     toolbar based on orientation and
'     ShowCaptions property.
'     Called after changing orientation
'     or showing/hiding captions.
'==================================================
Private Sub SetBarHeightWidth()
    If (SWBCoolbar1.ShowCaptions = True) Then
        SWBCoolbar1.BarHeight = IIf(SWBCoolbar1.Orientation = tborHorizontal, IIf(SWBCoolbar1.CaptionPos = icBottom, 900, 600), SWBCoolbar1.BarHeight)
        SWBCoolbar1.BarWidth = IIf(SWBCoolbar1.Orientation = tborHorizontal, SWBCoolbar1.BarWidth, 1200)
        SWBCoolbar1.ButtonHeight = IIf(SWBCoolbar1.CaptionPos = icBottom, 700, 400)
        SWBCoolbar1.ButtonWidth = 750
    Else
        SWBCoolbar1.BarHeight = IIf(SWBCoolbar1.Orientation = tborHorizontal, 600, SWBCoolbar1.BarHeight)
        SWBCoolbar1.BarWidth = IIf(SWBCoolbar1.Orientation = tborHorizontal, SWBCoolbar1.BarWidth, 900)
        SWBCoolbar1.ButtonHeight = 400
        SWBCoolbar1.ButtonWidth = 400
    End If

    SWBCoolbar1.Refresh
End Sub

