VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "ECLIPSE Registry Demo"
   ClientHeight    =   2685
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5595
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   2685
   ScaleWidth      =   5595
   StartUpPosition =   2  'CenterScreen
   Begin VB.TextBox txtAppKeyName 
      Height          =   288
      Left            =   1375
      TabIndex        =   9
      Text            =   "Text1"
      Top             =   100
      Width           =   4140
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   320
      Left            =   4320
      TabIndex        =   8
      Top             =   2275
      Width           =   1200
   End
   Begin VB.Frame Frame1 
      Height          =   1716
      Left            =   96
      TabIndex        =   1
      Top             =   456
      Width           =   5412
      Begin VB.CommandButton cmdReg 
         Caption         =   "Delete Key"
         Height          =   320
         Index           =   2
         Left            =   4000
         TabIndex        =   13
         Top             =   900
         Width           =   1200
      End
      Begin VB.CommandButton cmdReg 
         Caption         =   "Delete Value"
         Height          =   320
         Index           =   3
         Left            =   4000
         TabIndex        =   12
         Top             =   1250
         Width           =   1200
      End
      Begin VB.OptionButton optRegType 
         Caption         =   "SZ (string)"
         Height          =   204
         Index           =   1
         Left            =   2200
         TabIndex        =   11
         Top             =   850
         Value           =   -1  'True
         Width           =   1605
      End
      Begin VB.OptionButton optRegType 
         Caption         =   "DWORD (numbers)"
         Height          =   204
         Index           =   0
         Left            =   100
         TabIndex        =   10
         Top             =   850
         Width           =   2085
      End
      Begin VB.CommandButton cmdReg 
         Caption         =   "Query Value"
         Height          =   320
         Index           =   1
         Left            =   4000
         TabIndex        =   7
         Top             =   550
         Width           =   1200
      End
      Begin VB.CommandButton cmdReg 
         Caption         =   "Store Value"
         Height          =   320
         Index           =   0
         Left            =   4000
         TabIndex        =   6
         Top             =   200
         Width           =   1200
      End
      Begin VB.TextBox txtKeyValue 
         Height          =   288
         Left            =   1020
         TabIndex        =   5
         Text            =   "Text1"
         Top             =   1152
         Width           =   2000
      End
      Begin VB.TextBox txtKeyName 
         Height          =   288
         Left            =   1000
         TabIndex        =   4
         Text            =   "Text1"
         Top             =   225
         Width           =   2000
      End
      Begin VB.Label Label1 
         Caption         =   "Key Value :"
         Height          =   192
         Index           =   2
         Left            =   120
         TabIndex        =   3
         Top             =   1200
         Width           =   804
      End
      Begin VB.Label Label1 
         Caption         =   "Key Name :"
         Height          =   192
         Index           =   1
         Left            =   96
         TabIndex        =   2
         Top             =   252
         Width           =   828
      End
   End
   Begin VB.Label Label1 
      Caption         =   "Registry Success :"
      Height          =   192
      Index           =   3
      Left            =   144
      TabIndex        =   15
      Top             =   2280
      Width           =   1332
   End
   Begin VB.Label lblSuccess 
      AutoSize        =   -1  'True
      Caption         =   "_"
      Height          =   195
      Left            =   1635
      TabIndex        =   14
      Top             =   2280
      Width           =   90
   End
   Begin VB.Label Label1 
      Caption         =   "Application Key :"
      Height          =   192
      Index           =   0
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1188
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdExit_Click()
    Unload Me
End Sub

Private Sub cmdReg_Click(Index As Integer)
Dim result
Dim KeyResult
    If txtKeyName.Text = "" Then
        ' Warn if no Key Name to create
        MsgBox "KeyName not specified!", vbCritical
        Exit Sub
    End If
    
    If txtKeyValue.Text = "" And (Index = 0 Or Index = 3) Then
        ' Warn if no Value to store. Won't succeed anyway
        result = MsgBox("No Value to store/delete. Proceed Anyway?", vbInformation Or vbYesNo)
        If result = vbNo Then Exit Sub
    End If
    Select Case Index
        Case 0
            ' Creates the key specified in the txtKeyName textbox
            ' and stores the value specified in the txtKeyValue textbox
            If optRegType(0).Value Then
                ' Stores a REG_DWORD type value
                result = SetRegValue(HKEY_LOCAL_MACHINE, txtAppKeyName.Text, txtKeyName.Text, REG_DWORD, txtKeyValue.Text)
            Else
                ' Stores a REG_SZ type value
                result = SetRegValue(HKEY_LOCAL_MACHINE, txtAppKeyName.Text, txtKeyName.Text, REG_SZ, txtKeyValue.Text)
            End If
        Case 1
            ' Retrieves the value of the name specified in the
            ' txtKeyName textbox and assign it to the txtKeyValue textbox
            If optRegType(0).Value Then
                ' Retrieves a REG_DWORD type value
                result = GetRegValue(HKEY_LOCAL_MACHINE, txtAppKeyName.Text, txtKeyName.Text, REG_DWORD, KeyResult)
                txtKeyValue.Text = regValue 'KeyResult
            Else
                ' Retrieves a REG_SZ type value
                result = GetRegValue(HKEY_LOCAL_MACHINE, txtAppKeyName.Text, txtKeyName.Text, REG_SZ, KeyResult)
                txtKeyValue.Text = regValue 'KeyResult
            End If
        Case 2
            ' Delete an entire key. Use with CAUTION when you've change the values
            result = DeleteRegEntry(HKEY_LOCAL_MACHINE, txtAppKeyName.Text)
            txtKeyValue.Text = ""
        Case 3
            ' Delete a key. Use with CAUTION when you've change the values
            result = DeleteRegValue(HKEY_LOCAL_MACHINE, txtAppKeyName.Text, txtKeyName.Text)
            txtKeyValue.Text = ""
    End Select
    ' show result in lblSuccess control, either True or False
    If result Then
        lblSuccess.ForeColor = vbBlue
    Else
        lblSuccess.ForeColor = vbRed
    End If
    lblSuccess.Caption = result
    
End Sub

Private Sub Form_Load()
Dim result
    txtAppKeyName.Text = regAppKeyName
    lblSuccess.Caption = ""
    
    ' Check if a certain key exist
    ' regAppKeyName = "Software\ECLIPSE Development Software\" & regAppName
    result = regKeyExist(HKEY_LOCAL_MACHINE, regAppKeyName)
    If Not result Then
        ' Creates the key if it doesn't exist.
        ' This key will be deleted when you end this project
        CreateRegEntry HKEY_LOCAL_MACHINE, regAppKeyName
    End If
    
    ' default key to write in the registry.
    ' This can be modified by changing the value
    ' specified in the txtKeyName and txtKeyValue controls.
    txtKeyName.Text = "RegDemo"
    txtKeyValue.Text = "Sample Value to store"
'    result = Val("XXX")
End Sub

Private Sub Form_Unload(Cancel As Integer)
Dim result
    ' Checks if a certain key exist.
    result = regKeyExist(HKEY_LOCAL_MACHINE, regAppKeyName)
    If result Then
        ' Clean up the registry by deleting only the
        ' keys and values we stored.
        DeleteRegEntry HKEY_LOCAL_MACHINE, regAppKeyName
    End If

End Sub

Private Sub optRegType_Click(Index As Integer)
    txtKeyValue.Text = ""
End Sub

Private Sub txtKeyValue_Change()
    lblSuccess.Caption = ""
End Sub

Private Sub txtKeyValue_KeyPress(KeyAscii As Integer)
    ' if option is REG_DWORD, limit input to numbers only
    ' otherwise, accept anything.
    If optRegType(0).Value Then
        If KeyAscii > 57 Then KeyAscii = 0
    End If
    
End Sub
