Attribute VB_Name = "basMetaGif"
Option Explicit
'  MetaGif converts Windows Metafiles (*.wmf or *.emf) to CompuServe Gif
'  (*.gif) files. This DLL allows image resizeing without distortion when
'  converting Metafiles. With this library you can create WEB documents
'  on the fly, from your Windows application. With MetaGif you can
'  create a Gif file that is larger than the screen.
'
'  MetaGif now provides a direct binary interface for converting graphic
'  images to Gif. From VB you can create a gif copy of a picture object.
'  The picture object can be a *.bmp, *.wmf or a *.emf file.
'
'  The main() program is a simple example of how to use MetaGif. The program
'  will convert some Windows Metafiles to CompuServe Gif files. You can use
'  Microsoft Word to view the metafiles and the gif file results.
'
'  See the MetaGif function declarations for a full description of usage.
'  If you want additional copies please see the readme.txt file for
'  order information.
'
'  The author of this program accepts no responsibility for damages
'  resulting from the use of this product and makes no warranty or
'  representation, either express or implied, including but not limited
'  to, any implied warranty of merchantability or fitness for a particular
'  purpose. This software is provided "AS IS", and you, its user, assume
'  all risks when using it.
'
'  Author:
'     David E. Suffield
'     Eckler Software
'     dsuffiel@worldaccessnet.com
'     dsuffiel@hotmail.com
'

'
' Function: MetaGif()
'
' Purpose: Convert Windows Metafiles (*.wmf or *.emf) to Gif files.
'
' Parameters:
'          szWmf    metafile file name (input)
'          szGif    gif file name (output)
'          scaleX   scale factor percentage (100 = width*1)
'          scaleY   scale factor percentage (150 = height*1.5)
'
' Returns:
'          -3    could not open the specified metafile
'          -2    could not write gif file
'          -1    not a recognized metafile
'           0    not enough memory
'           1    ok
'
' Discription:
'          This function is provided for backward compatibility. It
'          is now superseded by MetaGifEx(). The gif file will be
'          created with the following defaults - background is white,
'          background is not transparent and not interlaced.
'

'
' Function: MetaGifEx()
'
' Purpose: Convert Windows Metafiles (*.wmf or *.emf) to Gif files.
'
' Parameters:
'          szWmf    metafile file name (input)
'          szGif    gif file name (output)
'          scaleX   scale factor percentage (100 = width*1)
'          scaleY   scale factor percentage (150 = height*1.5)
'          opt      conversion options
'          param    conversion parameter
'
' Returns:
'          -3    could not open the specified metafile
'          -2    could not write gif file
'          -1    not a recognized metafile
'           0    not enough memory
'           1    ok
'
' Discription:
'          This function supersedes MetaGif(). With MetaGifEx() you
'          can 1)change the gif default background from white to any
'          color 2)make the gif background color transparent 3)create
'          an interlaced gif.
'

'
' Function: MetaGifPic()
'
' Purpose: Convert a picture object to a Gif file.
'
' Parameters:
'          hd       handle to a HBITMAP, HMETAFILE or HENHMETAFILE.
'          szGif    gif file name (output)
'          rc       pointer to a RECT structure
'          opt      conversion options
'          param    conversion parameter
'
' opt values: (note, constants are additive)
'          0           default, background is white
'          &H1000000   make gif background transparent, use with background option
'          &H2000000   make gif interlaced
'          &H8000000   set gif background color, use "param" to specify rgb color
'
' Returns:
'          -5    invalid picture object
'          -3    could not open the specified metafile
'          -2    could not write gif file
'          -1    not a recognized metafile
'           0    not enough memory
'           1    ok
'
' Discription:
'          With MetaGifPic() you can create a gif copy of a picture object.
'          The picture object can be a handle to a HBITMAP, HMETAFILE, or
'          HENHMETAFILE. Use the rc parameter to specify the desired size
'          of the gif file. Note, a metafile will scale with out distortion,
'          but a bitmap will distort with scaling.
'

'
' History:
'          1.00 Converted from 16 bit MetaGif.
'
'          2.00 Rewritten for 32 bit WIN95/NT OS.  Up to 32 times faster than
'          MetaGif 1.00.  MetaGif 2.00 supports the following display modes -
'          1, 4, 8, 16 and 24 color bits per pixel.  This corresponds to
'          monochrome, 16, 256, 32k and 16meg color displays.  MetaGif memory
'          usage depends on the size of your gif file in pixels and your default
'          color display settings.  A 24 bit color display would use 3 times
'          more memory than a 8 bit color display.
'
'          MetaGif 2.00 uses the default display settings when converting wmf files to
'          gif.  If you want the same results between Win95 and WinNT the display
'          mode setting must be identical.  For example, if you are using 24 bit
'          color on Win95 you must use the 24 bit color setting on WinNT.  This
'          requirement is also true for two different PCs.  If you create wmf
'          files on one PC and do conversions to gif on another PC make sure the
'          display mode setting are the same for both machines.
'
'          MetaGif 2.1 adds a new api call - MetaGifEx().
'
'          MetaGif 2.2 adds a new api call - MetaGifPic().
'
'          MetaGif 2.3 added support for Enhanced Metafiles (*.emf).
'
'          MetaGif 2.4 Removed LZW compression which is patented by Unisys. Added Run Length
'          Encoding which still maintains compatibility with normal LZW-based GIF
'          decoders.
'
Declare Function MetaGif Lib "METAGIF32.DLL" (ByVal szWmf As String, ByVal szGif As String, ByVal scaleX As Long, ByVal scaleY As Long) As Long
Declare Function MetaGifEx Lib "METAGIF32.DLL" (ByVal szWmf As String, ByVal szGif As String, ByVal scaleX As Long, ByVal scaleY As Long, ByVal opt As Long, ByVal param As Long) As Long
Declare Function MetaGifPic Lib "METAGIF32.DLL" (ByVal hd As Long, ByVal szGif As String, rc As RECT, ByVal opt As Long, ByVal param As Long) As Long

'Defines for MetaGifEx() "opt" parameter. Note, constants are additive.
Global Const OPT_DEFAULT = 0
Global Const OPT_TRANSPARENT = &H1000000  'make gif background transparent
Global Const OPT_INTERLACED = &H2000000   'make gif interlaced
Global Const OPT_BACKGROUND = &H8000000   'set gif background color, use "param" to specify rgb color

Type RECT
    left As Long
    top As Long
    right As Long
    bottom As Long
End Type

Declare Function GetClientRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long


