VERSION 5.00
Begin VB.Form frmUnitConversion 
   Caption         =   "Conversion Utility"
   ClientHeight    =   4635
   ClientLeft      =   2325
   ClientTop       =   2145
   ClientWidth     =   4980
   LinkTopic       =   "Form1"
   ScaleHeight     =   4635
   ScaleWidth      =   4980
   Begin VB.OptionButton Option1 
      Caption         =   "Pressure"
      Height          =   465
      Index           =   8
      Left            =   3675
      TabIndex        =   19
      Top             =   75
      Width           =   915
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Volume"
      Height          =   465
      Index           =   7
      Left            =   3765
      TabIndex        =   18
      Top             =   525
      Width           =   840
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Energy"
      Height          =   465
      Index           =   6
      Left            =   2775
      TabIndex        =   17
      Top             =   525
      Width           =   840
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Mass"
      Height          =   465
      Index           =   5
      Left            =   1875
      TabIndex        =   16
      Top             =   525
      Width           =   765
   End
   Begin VB.TextBox txtReturnVal 
      Height          =   315
      Left            =   1110
      TabIndex        =   14
      Top             =   4050
      Width           =   2565
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Angle"
      Height          =   465
      Index           =   4
      Left            =   990
      TabIndex        =   4
      Top             =   525
      Width           =   765
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Time"
      Height          =   465
      Index           =   3
      Left            =   165
      TabIndex        =   3
      Top             =   525
      Width           =   765
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Speed"
      Height          =   465
      Index           =   2
      Left            =   2685
      TabIndex        =   2
      Top             =   75
      Width           =   840
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Temperature"
      Height          =   465
      Index           =   1
      Left            =   1335
      TabIndex        =   1
      Top             =   75
      Width           =   1215
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Distance"
      Height          =   465
      Index           =   0
      Left            =   210
      TabIndex        =   0
      Top             =   75
      Width           =   990
   End
   Begin VB.CommandButton cmdConvert 
      Caption         =   "Calculate"
      Default         =   -1  'True
      Height          =   465
      Left            =   1200
      TabIndex        =   12
      TabStop         =   0   'False
      Top             =   3075
      Width           =   1215
   End
   Begin VB.CommandButton cmdDoneConversions 
      Caption         =   "Close"
      Height          =   465
      Left            =   2415
      TabIndex        =   9
      TabStop         =   0   'False
      Top             =   3075
      Width           =   1215
   End
   Begin VB.Frame fraConversion 
      Height          =   1890
      Left            =   75
      TabIndex        =   8
      Top             =   975
      Width           =   4815
      Begin VB.TextBox txtValueIn 
         Height          =   315
         Left            =   1035
         TabIndex        =   7
         Top             =   1425
         Width           =   2565
      End
      Begin VB.ComboBox cmbUnitsTo 
         Height          =   315
         Left            =   2475
         Sorted          =   -1  'True
         TabIndex        =   6
         Top             =   600
         Width           =   2190
      End
      Begin VB.ComboBox cmbUnitsFrom 
         Height          =   315
         Left            =   165
         Sorted          =   -1  'True
         TabIndex        =   5
         Top             =   600
         Width           =   2190
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Value to Convert"
         Height          =   195
         Index           =   2
         Left            =   1725
         TabIndex        =   13
         Top             =   1125
         Width           =   1185
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Units to Convert TO"
         Height          =   195
         Index           =   1
         Left            =   2925
         TabIndex        =   11
         Top             =   300
         Width           =   1410
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Units to Convert FROM"
         Height          =   195
         Index           =   0
         Left            =   435
         TabIndex        =   10
         Top             =   300
         Width           =   1650
      End
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Return Value"
      Height          =   195
      Index           =   3
      Left            =   1920
      TabIndex        =   15
      Top             =   3750
      Width           =   930
   End
End
Attribute VB_Name = "frmUnitConversion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const typeDISTANCE = 0
Private Const typeTEMPERATURE = 1
Private Const typeSPEED = 2
Private Const typeTIME = 3
Private Const typeANGLE = 4
Private Const typeMASS = 5
Private Const typeENERGY = 6
Private Const typeVOLUME = 7
Private Const typePRESSURE = 8

Private ConvertDLL As New UnitConverter
Private Sub cmdConvert_Click()
Dim i As Integer, iConvertThis As Integer
On Error GoTo ErrorHandler

'make sure a number is filled into the text field
    If Not IsNumeric(txtValueIn.Text) Then
        MsgBox "Non-numeric value for input.  No conversion done.", vbExclamation, "Conversion Utility"
        txtReturnVal.Text = ""
        Exit Sub
    End If

'determine which type of conversion they are doing
    For i = 0 To (Option1.Count - 1)
        If Option1(i).Value Then
            iConvertThis = i
            Exit For
        End If
    Next

'run the conversion DLL
    Dim dblReturnVal As Double
    Dim strIn As String, strOut As String

    'determine the units they want for in/out
    i = InStr(cmbUnitsFrom.Text, "-")
    strIn = UCase(Trim(Left(cmbUnitsFrom.Text, i - 1)))
    i = InStr(cmbUnitsTo.Text, "-")
    strOut = UCase(Trim(Left(cmbUnitsTo.Text, i - 1)))

    Select Case Option1(iConvertThis).Caption
        Case "Distance"
            dblReturnVal = ConvertDLL.Length(strIn, Val(txtValueIn.Text), strOut)
        Case "Temperature"
            dblReturnVal = ConvertDLL.Temperature(strIn, Val(txtValueIn.Text), strOut)
        Case "Speed"
            dblReturnVal = ConvertDLL.Speed(strIn, Val(txtValueIn.Text), strOut)
        Case "Time"
            dblReturnVal = ConvertDLL.Time(strIn, Val(txtValueIn.Text), strOut)
        Case "Angle"
            dblReturnVal = ConvertDLL.Angle(strIn, Val(txtValueIn.Text), strOut)
        Case "Mass"
            dblReturnVal = ConvertDLL.Mass(strIn, Val(txtValueIn.Text), strOut)
        Case "Energy"
            dblReturnVal = ConvertDLL.Energy(strIn, Val(txtValueIn.Text), strOut)
        Case "Pressure"
            dblReturnVal = ConvertDLL.Pressure(strIn, Val(txtValueIn.Text), strOut)
        Case "Volume"
            dblReturnVal = ConvertDLL.Volume(strIn, Val(txtValueIn.Text), strOut)
    End Select

txtReturnVal.Text = CStr(dblReturnVal)
Exit Sub

ErrorHandler:
    MsgBox Err.Description, , Err.Number

End Sub

Private Sub cmdDoneConversions_Click()
Unload Me
End Sub

Private Sub Option1_Click(Index As Integer)

'set up the combo box lists
    cmbUnitsFrom.Clear
    cmbUnitsTo.Clear
    Select Case Index
        Case typeDISTANCE
            cmbUnitsFrom.AddItem "KM - Kilometers"
            cmbUnitsFrom.AddItem "NM - Nautical Miles"
            cmbUnitsFrom.AddItem "FT - Feet"
            cmbUnitsFrom.AddItem "KF - Kilofeet"
            cmbUnitsFrom.AddItem "HM - Hectometers"
            cmbUnitsFrom.AddItem "YD - Yards"
            cmbUnitsFrom.AddItem "M - Meters"
            cmbUnitsFrom.AddItem "SM - Statute Miles"
            cmbUnitsFrom.AddItem "IN - Inches"
            cmbUnitsFrom.AddItem "CM - Centimeters"
        Case typeTEMPERATURE
            cmbUnitsFrom.AddItem "F - Fahrenheit"
            cmbUnitsFrom.AddItem "C - Celsius"
            cmbUnitsFrom.AddItem "K - Kelvin"
        Case typeSPEED
            cmbUnitsFrom.AddItem "MPS - Meters per Second"
            cmbUnitsFrom.AddItem "KPH - Kilometers per Hour"
            cmbUnitsFrom.AddItem "KTS - Knots"
            cmbUnitsFrom.AddItem "MPH - Miles per Hour"
        Case typeTIME
            cmbUnitsFrom.AddItem "DAY - Days"
            cmbUnitsFrom.AddItem "HR - Hours"
            cmbUnitsFrom.AddItem "MIN - Minutes"
            cmbUnitsFrom.AddItem "SEC - Seconds"
            cmbUnitsFrom.AddItem "WK - Weeks"
            cmbUnitsFrom.AddItem "MON - Months"
        Case typeANGLE
            cmbUnitsFrom.AddItem "MIL - Mil"
            cmbUnitsFrom.AddItem "DEG - Degree"
            cmbUnitsFrom.AddItem "RAD - Radian"
        Case typeMASS
            cmbUnitsFrom.AddItem "KG - Kilogram"
            cmbUnitsFrom.AddItem "LB - Pound"
            cmbUnitsFrom.AddItem "TON - Ton"
            cmbUnitsFrom.AddItem "MT - Metric Ton"
            cmbUnitsFrom.AddItem "OZ - Ounce"
            cmbUnitsFrom.AddItem "G - Grams"
        Case typeENERGY
            cmbUnitsFrom.AddItem "J - Joule"
            cmbUnitsFrom.AddItem "CAL - Calorie"
            cmbUnitsFrom.AddItem "BTU - British Thermal Unit"
            cmbUnitsFrom.AddItem "ERG - Erg (CGS unit)"
            cmbUnitsFrom.AddItem "FTLB - Foot-Pounds"
            cmbUnitsFrom.AddItem "KCAL - Kilocalorie"
            cmbUnitsFrom.AddItem "KWH - Kilowatt Hour"
            cmbUnitsFrom.AddItem "EV - Electron Volt"
        Case typePRESSURE
            cmbUnitsFrom.AddItem "PA - Pascal"
            cmbUnitsFrom.AddItem "ATM - Atmospheres"
            cmbUnitsFrom.AddItem "TORR - Milimeters of Mercury"
            cmbUnitsFrom.AddItem "BAR - Bars"
            cmbUnitsFrom.AddItem "PSI - Pounds per Square Inch"
            cmbUnitsFrom.AddItem "KPA - Kilopascal"
        Case typeVOLUME
            cmbUnitsFrom.AddItem "LT - Liter"
            cmbUnitsFrom.AddItem "GA - Gallon"
            cmbUnitsFrom.AddItem "QT - Quart"
            cmbUnitsFrom.AddItem "PT - Pint"
            cmbUnitsFrom.AddItem "OZ - Fluid Ounce"
    End Select

Dim i As Integer
For i = 1 To cmbUnitsFrom.ListCount
    cmbUnitsTo.AddItem cmbUnitsFrom.List(i - 1)
Next i
End Sub
