Attribute VB_Name = "IniModule"
' --------------------------------------------------------
' Module    : IniModule(Init.bas)
' Written by: Elito C. Lelina III
'             ECLIPSE Development Software
' URL       : www.geocities.com/SiliconValley/Campus/3118/
' email     : eclipseds@hotmail.com
' --------------------------------------------------------
'
' This module contains functions for reading and
' setting Key values from an initialization file.
' These functions are provided for compatibility
' with 16-bit applications written for Windows.
' Win32-based applications should store initialization
' information in the registry.
'
' This program makes no guarantees and no support is provided,
' but comments/bug reports are welcome.
'
' Warning:  Windows depends heavily on initialization file.
' Create initialization file Backup before editing.
' You should only edit values when you know what
' they should be.  If editing values as a test, make a note
' of the original value and restore it when you are done.


' Variable to hold the value of a keyname
Public IniValue As Variant
Public iKeyName() As String
Public iKeyValue()
Public iKeyCount As Long

'Private Declare Function GetProfileString Lib "kernel32" Alias "GetProfileStringA" (ByVal lpAppName As String, lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long) As Long
'Private Declare Function OSWritePrivateProfileString% Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal AppName$, ByVal KeyName$, ByVal keydefault$, ByVal FileName$)
'Private Declare Function OSGetPrivateProfileString% Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal AppName$, ByVal KeyName$, ByVal keydefault$, ByVal ReturnString$, ByVal NumBytes As Integer, ByVal FileName$)

' Retrieves an Integer from the specified keyname in the given
' section of the WIN.INI file
Private Declare Function GetProfileInt Lib "kernel32" Alias "GetProfileIntA" _
        (ByVal lpAppName As String, _
        ByVal lpKeyName As String, _
        ByVal nDefault As Long) As Long

' Retrieves all of the keys and values for the specified section
' of the WIN.INI file.
Private Declare Function GetProfileSection Lib "kernel32" Alias "GetProfileSectionA" _
        (ByVal lpAppName As String, _
        ByVal lpReturnedString As String, _
        ByVal nSize As Long) As Long

' Retrieves the string associated with the specified key in the
' given section of the WIN.INI file.
Private Declare Function GetProfileString Lib "kernel32" Alias "GetProfileStringA" _
        (ByVal lpAppName As String, _
        ByVal lpKeyName As String, _
        ByVal lpDefault As String, _
        ByVal lpReturnedString As String, _
        ByVal nSize As Long) As Long

' Replaces the contents of the specified section in the
' WIN.INI file with the specified keys and values.
Private Declare Function WriteProfileSection Lib "kernel32" Alias "WriteProfileSectionA" _
        (ByVal lpAppName As String, _
        ByVal lpString As String) As Long

' Copies a string into the specified section of the WIN.INI file.
Private Declare Function WriteProfileString Lib "kernel32" Alias "WriteProfileStringA" _
        (ByVal lpszSection As String, _
        ByVal lpszKeyName As String, _
        ByVal lpszString As String) As Long

' Retrieves an integer associated with a key in the specified
' section of the given initialization file.
Private Declare Function GetPrivateProfileInt Lib "kernel32" Alias "GetPrivateProfileIntA" _
        (ByVal lpApplicationName As String, _
        ByVal lpKeyName As String, _
        ByVal nDefault As Long, _
        ByVal lpFileName As String) As Long

' Retrieves all of the keys and values for the specified section from an initialization file.
Private Declare Function GetPrivateProfileSection Lib "kernel32" Alias "GetPrivateProfileSectionA" _
        (ByVal lpAppName As String, _
        ByVal lpReturnedString As String, _
        ByVal nSize As Long, _
        ByVal lpFileName As String) As Long

' Retrieves a string from the specified section in an initialization file.
Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" _
        (ByVal lpApplicationName As String, _
        ByVal lpKeyName As Any, _
        ByVal lpDefault As String, _
        ByVal lpReturnedString As String, _
        ByVal nSize As Long, _
        ByVal lpFileName As String) As Long

' Replaces the keys and values under the specified section in an initialization file.
Private Declare Function WritePrivateProfileSection Lib "kernel32" Alias "WritePrivateProfileSectionA" _
        (ByVal lpAppName As String, _
        ByVal lpString As String, _
        ByVal lpFileName As String) As Long

' Copies a string into the specified section of the specified initialization file.
Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" _
        (ByVal lpApplicationName As String, _
        ByVal lpKeyName As Any, _
        ByVal lpString As Any, _
        ByVal lpFileName As String) As Long
'
' Structure of an INI File (i.e. MyFile.INI)
' [SectionName]
' KeyName = KeyValue

'****************************************************************
' The following function Stores/Retrieves Values from
' a WIN.INI file.
'****************************************************************

' Purpose   : Retrieves an Integer from the specified keyname in the given
'             section of the WIN.INI file
'             SectionName = Null terminated String
'             KeyName = Null terminated String
' Example   : result = GetWinInteger("MyApp","Left")
'             If result then MyInt = IniValue
Public Function GetWinInteger(SectionName As String, KeyName As String) As Boolean
Dim DefaultData As Long
Dim ReturnValue As Long
    On Local Error GoTo GetWinInteger_Err
    ' We supplied the value 32767 as the default value
    ' indicating that the requested key doesn't exist
    DefaultData = 32767
    IniValue = ""
    ReturnValue = GetProfileInt(SectionName, KeyName, DefaultData)
    If ReturnValue = DefaultData Then
        ' The key either doesn't exist, has no value or the value
        ' is equal to 32767, so be sure to supply a value that is
        ' unlikely to be use
        GetWinInteger = False
    Else
        GetWinInteger = True
        IniValue = GetWinInteger
    End If
    
GetWinInteger_End:
    Exit Function
    
GetWinInteger_Err:
    MsgBox "Error Retrieving Value."
    GetWinInteger = False
    Resume GetWinInteger_End
End Function
    
' Purpose   : Retrieves all of the keys and values for the
'             specified section of the WIN.INI file.
'             SectionName = Null terminated String
' Example   : result = GetWinAllKeys("MyApp")
Public Function GetWinAllKeys(SectionName As String) As Boolean
Dim ReturnValue
Dim ReturnString As String
Dim cbData As Long
Dim TmpNum As Long
Dim h As Long
Dim I As Long

    On Local Error GoTo GetWinAllKeys_Err
    ReturnString = String$(16200, 0)    'ensure large enough buffer. Max for Win95 is 16378
    cbData = Len(ReturnString)         ' length of ReturnString in bytes
    Erase iKeyName, iKeyValue           ' Clear all stored values
    iKeyCount = 0                       ' Clear Key count
    IniValue = ""
    ' Get the total length of characters contained by the specified section
    ReturnValue = GetProfileSection(SectionName, ReturnString, cbData)

    ' Parses the string, removes Null Characters,
    ' and stores the keys to iKeyName(Index)
    ' and values to iKeyValue(Index)
    For I = 1 To ReturnValue
        TmpNum = InStr(ReturnString, "=")
        If TmpNum Then
            iKeyCount = iKeyCount + 1
            ReDim Preserve iKeyName(iKeyCount), iKeyValue(iKeyCount)
            iKeyName(iKeyCount) = Left(ReturnString, TmpNum - 1)
            h = InStr(ReturnString, Chr$(0))
            iKeyValue(iKeyCount) = Mid(ReturnString, TmpNum + 1, h - 1 - TmpNum)
            ReturnString = Right(ReturnString, Len(ReturnString) - h)
            I = h
            DoEvents
            'MsgBox iKeyName(iKeyCount) & " = " & iKeyValue(iKeyCount)
            IniValue = IniValue & iKeyName(iKeyCount) & " = " & iKeyValue(iKeyCount) & vbCrLf
        End If
    Next I
    If iKeyCount = 0 Then
        ' The section doesn't exist or doesn't contain any keys
        GetWinAllKeys = False
    Else
        GetWinAllKeys = True
    End If

GetWinAllKeys_End:
    Exit Function
    
GetWinAllKeys_Err:
    MsgBox "Error Retrieving Keys"
    GetWinAllKeys = False
    Resume GetWinAllKeys_End
End Function

' Purpose   : Retrieves the string associated with the specified
'             key in the given section of the WIN.INI file.
'             SectionName = Null terminated String
Public Function GetWinKey(SectionName As String, KeyName As String) As Boolean
Dim ReturnString As String
Dim ReturnValue As Long
    On Local Error GoTo GetWinKey_Err
    ReturnString = String$(255, 0)
    IniValue = ""
    ' Query the given KeyName
    ReturnValue = GetProfileString(SectionName, KeyName, "NotFound", ReturnString, Len(ReturnString))
    If Left(ReturnString, InStr(ReturnString, Chr$(0)) - 1) = "NotFound" Then
        ' Requested Key doesn't exist or is equal to "NotFound"
        GetWinKey = False
    Else
        GetWinKey = True
        IniValue = Left(ReturnString, InStr(ReturnString, Chr$(0)) - 1)
    End If
    
GetWinKey_End:
    Exit Function
    
GetWinKey_Err:
    MsgBox "Error Retrieving Key"
    GetWinKey = False
    Resume GetWinKey_End
End Function

' Purpose   :Replaces the contents of the specified section in the
'            WIN.INI file with the specified keys and values.
' Example   : result=WriteWinAllKeys("MyApp", MyKeys)
'             MyKeys should be in the format:
'             MyKeys = "Key1 = Value1" & chr$(0)
'             MyKeys = MyKeys & "Key2 = Value2" & chr$(0)
'             MyKeys = MyKeys & ..."Keyn = Valuen" & chr$(0) & chr$(0)
Public Function WriteWinAllKeys(SectionName As String, KeyName As String) As Boolean
On Local Error GoTo WriteWinAllKeys_Err
    IniValue = ""
    WriteWinAllKeys = WriteProfileSection(SectionName, KeyName)
    
WriteWinAllKeys_End:
    Exit Function
    
WriteWinAllKeys_Err:
    MsgBox "Error Writing Keys"
    WriteWinAllKeys = False
    Resume WriteWinAllKeys_End:

End Function

' Purpose   : Copies a string into the specified section of the WIN.INI file.
' Example   : result=WriteWinKey("MyApp", MyKeys, MyValue)
Public Function WriteWinKey(SectionName As String, KeyName As String, KeyValue As String)
On Local Error GoTo WriteWinKey_Err
    IniValue = ""
    WriteWinKey = WriteProfileString(SectionName, KeyName, KeyValue)
    
WriteWinKey_End:
    Exit Function
    
WriteWinKey_Err:
    MsgBox "Error Writing Key"
    WriteWinKey = False
    Resume WriteWinKey_End:

End Function

'****************************************************************
' The following function Stores/Retrieves Values from
' a user provided INI file. If the file doesn't contain
' a valid path, Windows searches the Windows directory
' for the file.
'****************************************************************

' Purpose   : Retrieves an integer associated with a key in the
'             specified section of the given initialization file.
'             SectionName = Null terminated String
'             KeyName = Null terminated String
'             IniFileName = Null terminated String containing a valid external file
' Example   : result = GetInteger("MyApp", "MyKey", "MyApp.Ini")
'             If result then MyInt = IniValue
Public Function GetInteger(SectionName As String, KeyName As String, IniFileName As String) As Boolean
Dim DefaultData As Long
Dim ReturnValue As Long
    On Local Error GoTo GetInteger_Err
    ' We supplied the value 32767 as the default value
    ' indicating that the requested key doesn't exist
    DefaultData = 32767
    IniValue = ""
    ReturnValue = GetPrivateProfileInt(SectionName, KeyName, DefaultData, IniFileName)
    If ReturnValue = DefaultData Then
        ' The key either doesn't exist, has no value or the value
        ' is equal to 32767, so be sure to supply a value that is
        ' unlikely to be use
        GetInteger = False
    Else
        GetInteger = True
        IniValue = GetInteger
    End If
    
GetInteger_End:
    Exit Function
    
GetInteger_Err:
    MsgBox "Error Retrieving Value."
    GetInteger = False
    Resume GetInteger_End

End Function

' Purpose   : Retrieves all of the keys and values for the
'             specified section from an initialization file.
'             SectionName = Null terminated String
'             IniFileName = Null terminated String containing a valid external file
' Example   : result = GetAllKeys("MyApp", "MyApp.Ini")
Public Function GetAllKeys(SectionName As String, IniFileName As String) As Boolean
Dim ReturnValue
Dim ReturnString As String
Dim cbData As Long
Dim TmpNum As Long
Dim h As Long
Dim I As Long

    On Local Error GoTo GetAllKeys_Err
    ReturnString = String$(16200, 0)    'ensure large enough buffer. Max for Win95 is 16378
    cbData = Len(ReturnString)         ' length of ReturnString in bytes
    Erase iKeyName, iKeyValue           ' Clear all stored values
    iKeyCount = 0                       ' Clear Key count
    IniValue = ""
    ' Get the total length of characters contained by the specified section
    ReturnValue = GetPrivateProfileSection(SectionName, ReturnString, cbData, IniFileName)
    
    ' Parses the string, removes Null Characters,
    ' and stores the keys to iKeyName(Index)
    ' and values to iKeyValue(Index)
    For I = 1 To ReturnValue
        TmpNum = InStr(ReturnString, "=")
        If TmpNum Then
            iKeyCount = iKeyCount + 1
            ReDim Preserve iKeyName(iKeyCount), iKeyValue(iKeyCount)
            iKeyName(iKeyCount) = Left(ReturnString, TmpNum - 1)
            h = InStr(ReturnString, Chr$(0))
            iKeyValue(iKeyCount) = Mid(ReturnString, TmpNum + 1, h - 1 - TmpNum)
            ReturnString = Right(ReturnString, Len(ReturnString) - h)
            I = h
            DoEvents
            'MsgBox iKeyName(iKeyCount) & " = " & iKeyValue(iKeyCount)
            IniValue = IniValue & iKeyName(iKeyCount) & " = " & iKeyValue(iKeyCount) & vbCrLf
        End If
    Next I
    If iKeyCount = 0 Then
        ' The section doesn't exist or doesn't contain any keys
        GetAllKeys = False
    Else
        GetAllKeys = True
    End If

GetAllKeys_End:
    Exit Function
    
GetAllKeys_Err:
    MsgBox "Error Retrieving Keys"
    GetAllKeys = False
    Resume GetAllKeys_End

End Function

' Purpose   : Retrieves a string from the specified section in
'             an initialization file.
'             SectionName = Null terminated String
'             KeyName = Null terminated String
'             IniFileName = Null terminated String containing a valid external file
Public Function GetKey(SectionName As String, KeyName As String, IniFileName As String) As Boolean
Dim ReturnString As String
Dim ReturnValue As Long
    On Local Error GoTo GetKey_Err
    ReturnString = String$(255, 0)
    IniValue = ""
    ' Query the given KeyName
    ReturnValue = GetPrivateProfileString(SectionName, KeyName, "NotFound", ReturnString, Len(ReturnString), IniFileName)
    If Left(ReturnString, InStr(ReturnString, Chr$(0)) - 1) = "NotFound" Then
        ' Requested Key doesn't exist or is equal to "NotFound"
        GetKey = False
    Else
        GetKey = True
        IniValue = Left(ReturnString, InStr(ReturnString, Chr$(0)) - 1)
    End If
    
GetKey_End:
    Exit Function
    
GetKey_Err:
    MsgBox "Error Retrieving Key"
    GetKey = False
    Resume GetKey_End
End Function

' Purpose   : Replaces the keys and values under the specified
'             section in an initialization file.
'             SectionName = Null terminated String
'             KeyName = Null terminated String
'             IniFileName = Null terminated String containing a valid external file
' Example   : result=WriteAllKeys("MyApp", MyKeys, "MyApp.Ini")
'             MyKeys should be in the format:
'             MyKeys = "Key1 = Value1" & chr$(0)
'             MyKeys = MyKeys & "Key2 = Value2" & chr$(0)
'             MyKeys = MyKeys & ..."Keyn = Valuen" & chr$(0) & chr$(0)
Public Function WriteAllKeys(SectionName As String, KeyName As String, IniFileName As String) As Boolean
On Local Error GoTo WriteAllKeys_Err
    IniValue = ""
    WriteAllKeys = WritePrivateProfileSection(SectionName, KeyName, IniFileName)
    
WriteAllKeys_End:
    Exit Function
    
WriteAllKeys_Err:
    MsgBox "Error Writing Keys"
    WriteAllKeys = False
    Resume WriteAllKeys_End:

End Function

' Purpose   : Copies a string into the specified section of the
'             specified initialization file.
'             SectionName = Null terminated String
'             KeyName = Null terminated String
'             IniFileName = Null terminated String containing a valid external file
' Example   : result = WriteKey("MyApp", "MyKey", MyValue, "MyApp.Ini")
Public Function WriteKey(SectionName As String, KeyName As String, KeyValue As String, IniFileName As String)
On Local Error GoTo WriteKey_Err
    IniValue = ""
    WriteKey = WritePrivateProfileString(SectionName, KeyName, KeyValue, IniFileName)
    
WriteKey_End:
    Exit Function
    
WriteKey_Err:
    MsgBox "Error Writing Key"
    WriteKey = False
    Resume WriteKey_End:

End Function

