Attribute VB_Name = "Module2"

'
' Draws a rotating card, spinning 360
' around the horizontal axis, centered at x%,y%
' position on form f.
'
Sub Card_FlipVert(cpk As Cardpack, f As Form, c%, x%, y%)
    Dim yc%, cw%, ch%, h%, hDC%
    
    cw% = cpk.CardWidth
    ch% = cpk.CardHeight
    hDC% = f.hDC
    
    yc% = y%
    
    ' draw card with decreasing height
    For h% = ch% To 0 Step -1
        ' erase external border
        f.Line (x%, yc%)-(x% + cw%, yc% + h%), f.BackColor, B
        
        ' draw shrunken card
        yc% = y% + (ch% - h%) \ 2
        cpk.DrawCard hDC%, c%, x%, yc%, cw%, h%
    Next h%
    
    ' flip card before redrawing
    If c% And FACING_UP Then
        c% = c% - FACING_UP + FACING_DOWN
    Else
        c% = c% + FACING_UP - FACING_DOWN
    End If
    
    ' draw card with increasing height
    For h% = 0 To ch%
        yc% = y% + (ch% - h%) \ 2
        cpk.DrawCard hDC%, c%, x%, yc%, cw%, h%
    Next h%

End Sub



'
' Draws a rotating card, spinning 360
' around the vertical axis, centered at x%,y%
' position on form f.
'
Sub Card_FlipHoriz(cpk As Cardpack, f As Form, c%, x%, y%)
    Dim xc%, cw%, ch%, w%, hDC%
    
    cw% = cpk.CardWidth
    ch% = cpk.CardHeight
    xc% = x%
    hDC% = f.hDC
    
    ' draw card with decreasing width
    For w% = cw% To 0 Step -1
        ' erase external border
        f.Line (xc%, y%)-(xc% + w%, y% + ch%), f.BackColor, B
        
        ' draw shrunken card
        xc% = x% + (cw% - w%) \ 2
        cpk.DrawCard hDC%, c%, xc%, y%, w%, ch%
    Next w%
    
    ' flip card before redrawing
    If c% And FACING_UP Then
        c% = c% - FACING_UP + FACING_DOWN
    Else
        c% = c% + FACING_UP - FACING_DOWN
    End If
    
    ' draw card with increasing width
    For w% = 0 To cw%
        xc% = x + (cw% - w%) \ 2
        cpk.DrawCard hDC%, c%, xc%, y%, w%, ch%
    Next w%

End Sub

