'---------------------------------------------------------------------------
' CARDPACK.BAS - Copyright(c) 1995..1998 by Andy Zanna
'---------------------------------------------------------------------------
' Definitions and constants for use with the
' Cardpack Control, up to version 1.7
'
' Notes:
' - Not all of these are applicable to older versions and VBX variants 
' - The ActiveX variants of the control also has equivalent constants
'   defined in its type library. These can be accessed from Visual Basic's
'   "Object Browser" (hit F2 key) 
'---------------------------------------------------------------------------

' these are usually found as return values from properties and queries
Global Const CARD_EMPTY = 0  ' a card VALUE, indicate 'no cards in this position
Global Const CARD_NONE = -1  ' a card INDEX, indicates 'no such card'

Global Const ACE = 1
Global Const JACK = 11
Global Const QUEEN = 12
Global Const KING = 13
Global Const JOKER = 14

Global Const HEARTS = &H10
Global Const DIAMONDS = &H20
Global Const CLUBS = &H30
Global Const SPADES = &H40

' used in: For s% = HEARTS To SPADES Step ONE_SUIT ...
Global Const ONE_SUIT = &H10

Global Const FACING_DOWN = &H100
Global Const FACING_UP = &H200


' This is the available range for card backs.
' You should specify your preferred backs with your own constants.

Global Const CARD_FIRST_BACK = &H1000
Global Const CARD_LAST_BACK = &HF000



'---------------------------------------------------------------------------
' Enumerated values for the Control properties
'---------------------------------------------------------------------------

' *** Sorting ***
Global Const CARDS_SORT_BYSUIT = 0
Global Const CARDS_SORT_BYVAL = 1


' *** Spread Style ****
Global Const CARDS_SPREAD_STACKED = 0
Global Const CARDS_SPREAD_SLANTED = 1
Global Const CARDS_SPREAD_TIGHT = 2
Global Const CARDS_SPREAD_WIDE = 3
Global Const CARDS_SPREAD_STREWN = 4
Global Const CARDS_SPREAD_USERDEF = 5


'*** Spread Direction ***
Global Const CARDS_SPREAD_UP = 0
Global Const CARDS_SPREAD_DOWN = 1
Global Const CARDS_SPREAD_RIGHT = 2
Global Const CARDS_SPREAD_LEFT = 3
Global Const CARDS_SPREAD_UP_RIGHT = 4
Global Const CARDS_SPREAD_UP_LEFT = 5
Global Const CARDS_SPREAD_DOWN_RIGHT = 6
Global Const CARDS_SPREAD_DOWN_LEFT = 7


' *** EmptyPicture ****
Global Const CARDS_EMPTY_NONE = 0
Global Const CARDS_EMPTY_CROSS = 1
Global Const CARDS_EMPTY_CIRCLE = 2


' *** Stack Facing Direction ****
Global Const CARDS_FACING_DOWN = 0
Global Const CARDS_FACING_UP = 1


' -------------------------------------------------------------------
' Cards actions (synchronous methods) and Msgs logged by the
' logger itself after an action was issued.
'
' These commands are issued by assigning one of the values below
' to the property "Action=". This is required since VB has no way
' to extend the standard set of methods for a custom control.
' -------------------------------------------------------------------

Global Const CARDS_ACTION_NONE = 0
Global Const CARDS_ACTION_SHUFFLE = 1
Global Const CARDS_ACTION_SORT = 2
Global Const CARDS_ACTION_TURN_UP = 3
Global Const CARDS_ACTION_TURN_DOWN = 4
Global Const CARDS_ACTION_DESELECT = 5
Global Const CARDS_ACTION_SELECT = 6
Global Const CARDS_ACTION_PACK = 7
Global Const CARDS_ACTION_CLEAR = 8

' -------------------------------------------------------------------
' Cards descriptor bits (just in case you need to interpret a
' descriptor after it has been extracted
' -------------------------------------------------------------------

Global Const CARD_VALUE_BITS = &HF
Global Const CARD_SUIT_BITS = &HF0
Global Const CARD_FACING_BITS = &H300
Global Const CARD_BACK_BITS = &HF000
Global Const CARD_SELECT_BIT = &H800

'
' Return the attribute as bit pattern (not numeric value)
'
Function CardBack(c%) As Integer
    CardBack = c% And CARD_BACK_BITS
End Function

'
' Return the attribute as bit pattern (not numeric value)
'
Function CardFacing(c%) As Integer
    CardFacing = c% And CARD_FACING_BITS
End Function

'
' Reverse card
'
Function CardFlip(c%) As Integer
    
    Dim curr_facing%

    curr_facing% = c% And CARD_FACING_BITS

    CardFlip = c% And (Not CARD_FACING_BITS) Or (CARD_FACING_BITS And (Not curr_facing%))

End Function

'
' Return the attribute as bit pattern (not numeric value)
'
Function CardSelection(c%) As Integer
    CardSelection = c% And CARD_SELECT_BIT
End Function

'
' Return the attribute as bit pattern (not numeric value)
'
Function CardSuit(c%) As Integer
    CardSuit = c% And CARD_SUIT_BITS
End Function

'
' Return the attribute as bit pattern (not numeric value)
'
Function CardValue(c%) As Integer
    CardValue = c% And CARD_VALUE_BITS
End Function

'
' Returns human name of a card
'
Function CardName$(c%)
    Dim v$, s$
    
    If c% = CARD_EMPTY Then
        CardName$ = "Empty"
        Exit Function
    End If
    
    Select Case CardValue(c%)
        Case ACE
            v$ = "Ace"
        Case JACK
            v$ = "Jack"
        Case QUEEN
            v$ = "Queen"
        Case KING
            v$ = "King"
        Case JOKER
            v$ = "Joker"
        Case Else
            v$ = Str$(CardValue(c%))
    End Select
    
    Select Case CardSuit(c%)
        Case SPADES
            s$ = "Spades"
        Case CLUBS
            s$ = "Clubs"
        Case DIAMONDS
            s$ = "Diamonds"
        Case HEARTS
            s$ = "Hearts"
        Case Else
            s$ = ""
    End Select
    
    If s$ <> "" Then
        CardName$ = v$ & " of " & s$
    Else
        CardName$ = v$
    End If
    
End Function

