' ******************************
' *     Menu Organizer 1.1     *
' *                            *
' *    Author: Ashley Hatch    *
' *      Date: 7/19/1998       *
' *                            *
' ******************************


' *** Variables to control program flow ***
	Dim Go
	Dim KillStartMenu
	Dim KillFavoritesMenu
	Dim StartDone
	Dim FavDone

	StartDone = 0
	FavDone = 0

' *** Inform user of the operation and allow them to proceed or cancel ***
	Go = MsgBox("This script will reset your Start Menu and/or your IE4 Favorites Menu to its default-ordering scheme", _
        	    vbOKCancel, "Menu Organizer 1.1")

	If Go = vbCancel Then
		WScript.Quit
	End If

' *** Creates the variable which allows us to delete the necessary registry entries ***
	Dim WSHShell
	Set WSHShell = WScript.CreateObject("WScript.Shell")

' *** Allow user to choose to clean their Start Menu and to executes that decision ***
	KillStartMenu = MsgBox("Do you wish to reset your Start Menu?", vbYesNo + 32, "Start Menu Organizer 1.1")

	If KillStartMenu = vbYes Then
		WSHShell.RegDelete "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\"
		StartDone = 1
	End IF

' *** Allow user to choose to clean their IE4 Favorites Menu and to executes that decision ***
	KillFavoritesMenu = MsgBox("Do you wish to reset your IE4 Favorites Menu?", vbYesNo + 32, "IE4 Favorites Menu Organizer 1.1")

	If KillFavoritesMenu = vbYes Then
		WSHShell.RegDelete "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Favorites\"
		FavDone = 1
	End IF

' *** Outputs information relating the finalization of the sorting of the menus ***
	If StartDone = 1 Then
		If FavDone = 1 Then
			MsgBox "Your menus are now sorted! You need to reboot to finalize the changes.", vbOkOnly + 64, "Thank you for using Menu Organizer 1.1"
		
		Else
			MsgBox "Your Start Menu is now sorted! You need to reboot to finalize the change.", vbOkOnly + 64, "Thank you for using Start Menu Organizer 1.1"
		End If
	Else
		If FavDone = 1 Then
			MsgBox "Your Favorites Menu is now sorted! You need to reboot to finalize the change.", vbOkOnly + 64, "Thank you for using IE4 Favorites Menu Organizer 1.1"
		End If
	End If