  title Visual DialogScript Setup Wizard
  option scale,96
  if %0
    directory change,@path(%0)
  end
  if @not(@file(PACKING.LST))
    warn Unable to run setup@CR()Cannot find file PACKING.LST
    exit
  end
  %T = Visual DialogScript Setup
  %U = Visual DialogScript 2.5
  %V = This wizard will set up the %U files in their desired location on your hard disk and create a program group on the start menu.
  %X = Press Finish to install %U to your hard disk.
  rem %D is default directory
  %D = C:\Program Files\Visual DialogScript
DIALOG CREATE,%T,-1,0,400,160,-
  dlgtype(nosys),-
  style(Title;Arial;18;B;;DKBLUE),-
  text(title;20;40;340;40;%U;Title),-
  text(text1;60;40;320;40;%V),-
  text(text2;30;40;;;Install into this directory:),-
  edit(eddir;52;40;288;;%D),-
  button(brwse;52;332;24;21;...),-
  button(bcdir;82;236;120;22;Use current location),-
  check(cbmenu;30;40;320;;Create start menu shortcuts?;1),-
  check(cbass;52;40;320;;Create file type association?;1),-
  text(text4;30;40;320;;%X),-
  progress(prog;64;40;320;32;0),-
  button(Back;120;140;;;<< Back),-
  button(Next;120;208;;;Next >>),-
  button(Finish;120;296;;;Cancel)
  dialog disable,Back
  rem %Z = no. of pages
  %Z = 4
  rem %P = current page no.
  %P = %Z
  %A = HIDE
  repeat
    rem hide all but first page controls
    gosub pagectrl
    %P = @pred(%P)
  until @equal(%P,1)
:evloop
  wait event
  goto @event()
:nextbutton
  %A = HIDE
  gosub pagectrl
  %P = @succ(%P)
  %A = show
  gosub pagectrl
  if @greater(%P,1)
    dialog enable,Back
  end
  if @equal(%P,%Z)
    dialog disable,Next
    dialog set,Finish,Finish
  end
  goto evloop
:backbutton
  %A = HIDE
  gosub pagectrl
  %P = @pred(%P)
  %A = show
  gosub pagectrl
  if @equal(%P,1)
    dialog disable,Back
  end
  if @greater(%Z,%P)
    dialog enable,Next
    dialog set,Finish,Cancel
  end
  goto evloop
:finishbutton
  if @equal(%P,%Z)
    gosub install
    exit
  else
    if @ask(Are you sure you want to cancel %T?)
      exit
    end
  end
  goto evloop
:brwsebutton
  %D = @dirdlg()
  if @ok()
    dialog set,eddir,%D
  end
  goto evloop
:bcdirbutton
  %D = @curdir()
  dialog set,eddir,%D
  goto evloop
:pagectrl
  if @equal(%P,4)
    dialog %A,text4
    dialog %A,prog
  end
  if @equal(%P,3)
    dialog %A,cbmenu
    dialog %A,cbass
  end
  if @equal(%P,2)
    dialog %A,text2
    dialog %A,eddir
    dialog %A,brwse
    dialog %A,bcdir
  end
  if @equal(%P,1)
    dialog %A,text1
    dialog %A,title
  end
  exit
:install
  rem load the list of files to install
  list 1,create
  list 1,loadfile,PACKING.LST
  %Z = @sum(@count(1),4)
  %P = 100
  %D = @dlgtext(eddir)
  if @not(@equal(%D,@curdir()))
    rem create the output directory
    gosub showprog
    dialog set,text4,Creating directory %D
    if @file(%D,D)
      if @not(@ask(Directory %D already exists.@CR()Files may be overwritten. Continue?))
        exit
      end
    else
      directory create,%D
      if @not(@file(%D,D))
        beep
        warn Could not create %D
        exit
      end
    end
      directory create,%D\Examples
    repeat
      %F = @next(1)
      if %F
        %P = @sum(%P,100)
        gosub showprog
        dialog set,text4,Copying file %F
        if @equal(@ext(%F),dsc)@equal(@ext(%F),ico)@equal(@ext(%F),wav)
          file copy,%F,%D\Examples\%F
        else
          file copy,%F,%D\%F
        end
      end
    until @null(%F)
    list 1,close
  end
  %P = @prod(@diff(%Z,2),100)
  gosub showprog
  wait 1
  if @dlgtext(cbmenu)
    dialog set,text4,Create the start menu shortcuts
    DDE LINK,Progman,Progman
    if @ok()
      DDE EXECUTE,[CreateGroup(%U)]
    end
    if @ok()
      DDE EXECUTE,[ShowGroup(%U",1")]
    end
    if @ok()
      DDE EXECUTE,[AddItem(@shortname(%D\ds.exe)",Visual DialogScript")]
      DDE EXECUTE,[AddItem(@shortname(%D\ds.hlp)",Visual DialogScript 2.5 Help,winhelp.exe")]
      DDE EXECUTE,[AddItem(@shortname(%D\tutorial.hlp)",Visual DialogScript 2.5 Tutorial,winhelp.exe")]
    end
    if @not(@ok())
      warn Setup failed to create start menu shortcuts
    end
    DDE TERMINATE
  end
  wait 1
  %P = @prod(@diff(%Z,1),100)
  gosub showprog
  wait 1
  if @dlgtext(cbass)
    dialog set,text4,Create the file type association
    %W = Visual DialogScript.Script
    registry write,root,.dsc,,%W
    registry write,root,%W,,Visual DialogScript Script
    registry write,root,%W\shell\open\command,,@chr(34)%D\ds.exe@chr(34) @chr(34)"%1"@chr(34)
  end
  dialog set,text4,Creating default Registry entries
  wait 1
  %K = Software\JM Tech\DialogScript\2.0\Tools
  registry write,curuser,%K\Tool1,Name,&Bitmap Editor
  registry write,curuser,%K\Tool1,Path,@windir()\PBRUSH.EXE
  registry write,curuser,%K\Tool2,Name,&Icon Editor
  registry write,curuser,%K\Tool2,Path,#
  registry write,curuser,%K\Tool3,Name,&Window Spy
  registry write,curuser,%K\Tool3,Path,%D\WINSPY.EXE
  registry write,curuser,%K\Tool4,Name
  registry write,curuser,%K\Tool4,Path
  %P = @prod(%Z,100)
  gosub showprog
  wait 1
  if @file(%D\README.TXT)
    if @ask(Would you like to view the README.TXT file?)
      run notepad %D\README.TXT,wait
    end
  end
  info %T finished.
  exit
:showprog
  dialog set,prog,@div(%P,%Z)
  exit