  REM BACKUP.DSC - Drag'n'drop backup utility
  option filenames,short
  title Backup
  if @file(%1\BACKUP.SET)
    %1 = %1\BACKUP.SET
  end
:testlabel
  if @zero(@pos(@volinfo(a:),%1))
    goto askinsert
  else
    goto testarchive
  end
:askinsert
  if @query(Insert backup disk for %1@CR()in drive A: and press OK)
    goto testlabel
  else
    goto end
  end
:testarchive
  if @file(A:\BACKUP.ZIP)@file(A:\BACKUP.ZIP,D)
    if @query(Overwrite backup of @datetime(t 'on' dd mmm yy,@file(A:\BACKUP.ZIP,DT))?)
      file delete,A:\BACKUP.ZIP
      goto startbackup
    else
      goto askinsert
    end
  end
:startbackup
  if @equal(@ext(%1),SET)
    file copy,%1,A:\@name(%1).SET
    runh command /c ZIP -r -S -b @env(TEMP) A:\Backup "-@ <"%1,WAIT
  else
    runh ZIP.EXE -r -S -b @env(TEMP) A:\Backup %1 -i *.*,WAIT
  end
  if @zero(@retcode())
    info Backup completed.@CR()@volinfo(A,F)Kb free on disk.
  else
    beep
    warn Backup failed: error code @retcode()
  end
:end
