#define WIN32_LEAN_AND_MEAN
#define STRICT
#include <windows.h>
#include "resource.h"

// Our classname
#define APPNAME "RegionBuilderDemo"

// Global vars
HINSTANCE hInstMain;
HWND hWndMain;
// The backgroud bitmap
HBITMAP bmp_background;
// The transparent color for our background bitmap
DWORD transcolor = RGB(255,255,255);

// Helper functions in bitmap.c
extern SIZE Bitmap_GetSize(HBITMAP bmp);
extern Bitmap_DrawTransparent(HDC hdc, HBITMAP hBitmap, int x, int y, COLORREF cTransparentColor);

//*******************************************************************
// Loads a Win32 Region from a Resource
// 
// hInst - Instance of the resources module
// hWnd  - Window assign the region to
// name  - The name of the resource
//
// return - Success
//*******************************************************************
BOOL Assign_Region(HINSTANCE hInst, HWND hWnd, char *name)
{
	HGLOBAL	hResource;
	HRSRC findres;
	BYTE *data;
	DWORD rgnsize;
	HRGN region;

	// Try to find the resource of type "RGN"
	findres = FindResource(hInst, name, "RGN");
	if (!findres)
		return FALSE;

	// Load it into memory
	hResource = LoadResource(hInst, findres);
	if (!hResource)
		return FALSE;

	// Get a memory pointer to it
	data = (BYTE *)LockResource(hResource);
	if (!data)
		return FALSE;

	// Skip header ("EDRGN")
	data += 5;

	// Get the size of the region
	rgnsize = *(DWORD *)data;
	
	data += 4;
	// Try to create the region
	region = ExtCreateRegion(NULL, rgnsize, (LPRGNDATA)data);
	if (!region)
		return FALSE;

	// And set it
	return SetWindowRgn(hWnd, region, FALSE);

	// NOTE:
	// We don't have to call FreeResource(hResource)
	// because Win32 handles that for us
}

// Our window message callback
LRESULT CALLBACK WndProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch (iMsg)
	{
	case WM_CREATE:
		{
			SIZE size;
			RECT client, window;
			int winadjustx, winadjusty;

			// Load the bitmap
			bmp_background = LoadImage(hInstMain, MAKEINTRESOURCE(BMP_BACKGROUND), IMAGE_BITMAP, 0, 0, 0);
			if (!bmp_background)
				return -1;

			// Adjust the windows size
			size = Bitmap_GetSize(bmp_background);
			GetClientRect(hWnd,&client);
			GetWindowRect(hWnd,&window);
			winadjustx = (window.right - window.left) - (client.right - client.left);
			winadjusty = (window.bottom - window.top) - (client.bottom - client.top);
			MoveWindow(hWnd,0,0,size.cx+winadjustx,size.cy+winadjusty,TRUE);

			// Load and Assign the regoin
			if (!Assign_Region(hInstMain, hWnd, MAKEINTRESOURCE(RGN_BACKGROUND)))
				return -1;
		}
		return 0;
	case WM_LBUTTONDOWN:
		// Simulate a click on the titlebar of the window 
		// to move it when clikcing inside the client area
		PostMessage(hWnd, WM_NCLBUTTONDOWN, HTCAPTION, lParam);
	    break;
	case WM_PAINT:
		{
			PAINTSTRUCT ps;
			HDC hdc;
			
			hdc = BeginPaint(hWnd, &ps);
		
			// Draw our background
			Bitmap_DrawTransparent(hdc, 
				bmp_background, 
				0, 
				0, 
				transcolor);
		}
		break;
	case WM_CHAR:
		// ESC can close the window to
		if (wParam == 27)
			SendMessage(hWnd, WM_CLOSE, 0, 0);
		break;
	case WM_CLOSE:
		SendMessage(hWnd, WM_QUIT, 0, 0);
		break;
	case WM_DESTROY:
		// Free GDI resources
		DeleteObject(bmp_background);
		PostQuitMessage(0);
		return 0;
	}
	return DefWindowProc(hWnd, iMsg, wParam, lParam);
}

BOOL Init_Window(void)
{
	WNDCLASSEX wc;
	
	wc.cbSize = sizeof(wc);
	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstMain;
	wc.hIcon = NULL;
	wc.hIconSm = NULL;
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.lpszMenuName = NULL;
	wc.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	wc.lpszClassName = APPNAME;
	
	if (!RegisterClassEx(&wc))
		return FALSE;

	hWndMain = CreateWindow(APPNAME,
		"RegionBuilder Demo",
		WS_POPUP,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		NULL,
		(HMENU)NULL,
		hInstMain,
		NULL);
	
	return (hWndMain != NULL);
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR param, int iShow)
{
	MSG msg;
	
	hInstMain = hInstance;

	// Initialize our window
	if (!Init_Window())
		return -1;

	ShowWindow(hWndMain, SW_SHOWNORMAL);
	UpdateWindow(hWndMain);

	while (GetMessage(&msg,NULL,0,0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return 0;
}
