//******************************************************************************
// PLC Sample Compiler/Executor                 Copyright 1998 Adept Software **
//******************************************************************************

#include "Adept.H"
#include "PLC_Main.h"
#include "PLC_Exec.h"
#include "PLC_DT.h"
#include "PLC_C.h"

//******************************************************************************
//******************************************************************************
// LOCAL ROUTINES

// sample external command
static	void	Print			(PLC_DATATYPE *Parms,sdword ParmTotal)
{	// (parms) 0-x:any type
	sdword	ParmLoop;

	if(ParmTotal<1) throw("Command \"Print\": invalid parameters");
	for(ParmLoop=0 ; ParmLoop<ParmTotal ; ParmLoop++)
	{
		switch(Parms[ParmLoop].Type)
		{
		case PLC_DT_INT:	printf("%i",PLC_DT_GetInt(&Parms[ParmLoop])); break;
		case PLC_DT_FLOAT:	printf("%f",PLC_DT_GetFloat(&Parms[ParmLoop])); break;
		case PLC_DT_STRING:	printf("%s",PLC_DT_GetString(&Parms[ParmLoop])); break;
		}
	}
}

//**************************************

// loads a source file and adds a 0 to the end
static	char	*LoadSource		(char *Filename)
{
	HANDLE	Handle;
	char	*Buffer;
	dword	Size,TempSize;

	Handle=CreateFile(Filename,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,0,NULL);
	if(Handle==INVALID_HANDLE_VALUE) throw("File Error: Unable to open file");
	Size=GetFileSize(Handle,NULL);
	MEM_Alloc(&Buffer,Size+1);
	Buffer[Size]=0;
	if(!ReadFile(Handle,Buffer,Size,&TempSize,NULL) || TempSize!=Size) throw("File Error: Unable to read file");
	if(!CloseHandle(Handle)) throw("File Error: Unable to close file");
	
	return Buffer;
}

//******************************************************************************
//******************************************************************************
// PUBLIC ROUTINES

void	main		(void)
{
	char			*SampleFile;
	char			SampleStatement[]="for(Loop=0 ; Loop<5 ; Loop++) Print(Fred+=2,\"\n\")";
	
#if 0 && defined _DEBUG
	// makes memory allocation very slow (including string data types) 
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF		// enable memory checking
		|_CRTDBG_CHECK_ALWAYS_DF			// check memory block integrity at every alloc/free
		|_CRTDBG_DELAY_FREE_MEM_DF			// check for writing after blocks are freed (hogs memory)
		|_CRTDBG_LEAK_CHECK_DF				// check for leaks at exit
	);
#endif

	// 1. Start PLC
	printf("\nStarting PLC...\n");
	PLC_Startup(300);
	try
	{
		// 2. Initialize language module
		PLC_C_Init();
		// 3. Add external commands
		PLC_AddCommand("Print",Print);
		
		// 4. Compile (sample statement)
		printf("Compiling sample statement...\n");
		PLC_CompileStatements("TestStatement",SampleStatement);
		// 5. Execute (sample statement)
		printf("Executing sample statement...\n\n");
		PLC_Execute("TestStatement",NULL);
		// wait for enter
		printf("\nPress [ENTER]\n");
		getchar();

		// load & compile sample script file
		printf("Compiling sample file...\n");
		SampleFile=LoadSource("Sample.Scr");
		PLC_Compile(SampleFile);
		MEM_Free(&SampleFile);
		// execute & display result
		printf("Executing sample file: main()...\n\n");
		PLC_Execute("main",NULL);
		printf("\nResult: %i\n",PLC_DT_GetInt(&PLC_Result));
		// wait for enter
		printf("\nPress [ENTER]\n");
		getchar();
	}
	catch(char *String)
	{
		printf("\n\nError running sample program:\n%s\nAborting program.. Press [ENTER]\n",String);
		getchar();
	}
	// 6. Shutdown
	PLC_Shutdown();
}

//******************************************************************************
//******************************************************************************
