//******************************************************************************
// ADEPT SOFTWARE STANDARD LIBRARY              Copyright 1998 Adept Software **
//******************************************************************************

#define ADEPT_C
#include "Adept.H"

//**************************************
// INTERFACE

//**************************************
// LOCAL VARIABLES

//******************************************************************************
//******************************************************************************
// LOCAL ROUTINES

//******************************************************************************
//******************************************************************************
// PUBLIC ROUTINES

void	MEM_Alloc1			(void **BufferPtr,dword Size)
{
	*BufferPtr=NULL;

	if(Size==0) throw("Memory Error: Attempt to alloc 0 bytes");
	if(BufferPtr==NULL) throw("Memory Error: Attempt to alloc NULL buffer pointer");
	*BufferPtr=malloc(Size);
	if(*BufferPtr==NULL) throw("Memory Error: Unable to alloc buffer");
}

//**************************************

void	MEM_AllocInit1		(void **BufferPtr,dword Size)
{
	MEM_Alloc1(BufferPtr,Size);
	memset(*BufferPtr,0,Size);
}

//**************************************

void	MEM_Realloc1		(void **BufferPtr,dword Size)
{
	void	*TempPtr;

	if(Size==0) throw("Memory Error: Attempt to realloc 0 bytes");
	if(BufferPtr==NULL) throw("Memory Error: Attempt to realloc NULL buffer pointer");
	if(*BufferPtr==NULL) throw("Memory Error: Attempt to realloc NULL buffer");
	TempPtr=realloc(*BufferPtr,Size);
	if(TempPtr==NULL) throw("Memory Error: Unable to realloc buffer");
	*BufferPtr=TempPtr;
}

//**************************************

void	MEM_ReallocInit1	(void **BufferPtr,dword OldSize,dword Size)
{
	if(Size<OldSize) throw("Memory Error: Attempt to init a smaller realloc size");
	MEM_Realloc1(BufferPtr,Size);
	if(Size!=OldSize) memset(ptradd(*BufferPtr,OldSize),0,Size-OldSize);
}

//**************************************

void	MEM_Free1			(void **BufferPtr)
{
	if(BufferPtr==NULL) throw("Memory Error: Attempt to free NULL buffer pointer");
	if(*BufferPtr==NULL) throw("Memory Error: Attempt to free NULL buffer");
	free(*BufferPtr);
	*BufferPtr=NULL;
}

//******************************************************************************
// LINKED LIST ROUTINES

void	LNK_AnchorInit		(LNK_LINK *Anchor)
{
#ifdef _DEBUG
	if(Anchor==NULL) throw("LNK_AnchorInit(): NULL parm");
#endif
	Anchor->Prev=Anchor->Next=Anchor;
	Anchor->Anchor=TRUE;
}

//**************************************

void	LNK_LinkInit		(LNK_LINK *Link)
{
#ifdef _DEBUG
	if(Link==NULL) throw("LNK_LinkInit(): NULL parm");
#endif
	Link->Prev=Link->Next=Link;
	Link->Anchor=FALSE;
}

//******************************************************************************

void	LNK_AddAfter		(LNK_LINK *OrigLink,LNK_LINK *Link)
{
#ifdef _DEBUG
	if(OrigLink==NULL || Link==NULL) throw("LNK_AddAfter(): NULL parm");
#endif
	Link->Anchor=FALSE;

	Link->Prev=OrigLink;
	Link->Next=OrigLink->Next;
	(Link->Next)->Prev=Link;
	OrigLink->Next=Link;
}

//**************************************

void	LNK_AddBefore		(LNK_LINK *OrigLink,LNK_LINK *Link)
{
#ifdef _DEBUG
	if(OrigLink==NULL || Link==NULL) throw("LNK_AddBefore(): NULL parm");
#endif
	Link->Anchor=FALSE;

	Link->Next=OrigLink;
	Link->Prev=OrigLink->Prev;
	(Link->Prev)->Next=Link;
	OrigLink->Prev=Link;
}

//******************************************************************************

void	LNK_MoveAfter		(LNK_LINK *OrigLink,LNK_LINK *Link)
{
#ifdef _DEBUG
	if(OrigLink==NULL || Link==NULL) throw("LNK_MoveAfter(): NULL parm");
#endif
	(Link->Prev)->Next=Link->Next;
	(Link->Next)->Prev=Link->Prev;

	Link->Prev=OrigLink;
	Link->Next=OrigLink->Next;
	(Link->Next)->Prev=Link;
	OrigLink->Next=Link;
}

//**************************************

void	LNK_MoveBefore		(LNK_LINK *OrigLink,LNK_LINK *Link)
{
#ifdef _DEBUG
	if(OrigLink==NULL || Link==NULL) throw("LNK_MoveBefore(): NULL parm");
#endif
	(Link->Prev)->Next=Link->Next;
	(Link->Next)->Prev=Link->Prev;

	Link->Next=OrigLink;
	Link->Prev=OrigLink->Prev;
	(Link->Prev)->Next=Link;
	OrigLink->Prev=Link;
}

//******************************************************************************

void	LNK_Remove			(LNK_LINK *Link)
{
#ifdef _DEBUG
	if(Link==NULL) throw("LNK_Remove(): NULL parm");
#endif
	(Link->Prev)->Next=Link->Next;
	(Link->Next)->Prev=Link->Prev;
	Link->Prev=Link->Next=Link;
}

//**************************************

void	LNK_Relocate		(LNK_LINK *Link,void *OldLinkPos)
{
#ifdef _DEBUG
	if(Link==NULL) throw("LNK_Relocate(): NULL parm");
#endif
	if(Link->Next==OldLinkPos) Link->Prev=Link->Next=Link;
	else
	{
		(Link->Prev)->Next=Link;
		(Link->Next)->Prev=Link;
	}
}

//******************************************************************************

void	*LNK_Next			(LNK_LINK *Link)
{
#ifdef _DEBUG
	if(Link==NULL) throw("LNK_Next(): NULL parm");
#endif
	if(Link==Link->Next) Link=NULL;
	else Link=Link->Next;
	return (Link==NULL || Link->Anchor)? NULL : Link;
}

//**************************************

void	*LNK_Prev			(LNK_LINK *Link)
{
#ifdef _DEBUG
	if(Link==NULL) throw("LNK_Prev(): NULL parm");
#endif
	if(Link==Link->Next) Link=NULL;
	else Link=Link->Prev;
	return (Link==NULL || Link->Anchor)? NULL : Link;
}

//******************************************************************************
//******************************************************************************
